/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.cache.redis.RedisPoolMgr;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupCountUtil {
    private static final Logger Log = LoggerFactory.getLogger(CreateGroupCountUtil.class);
    private static final String REDIS_KEK = "msg:createGroupCheck:";
    private static final Integer REDIS_EXPIRE = 86400;

    public static boolean checkUserCreateGroupCount(String username) {
        try {
            int userCount;
            username = username.toLowerCase();
            int createGroupUserCount = JiveGlobals.getIntProperty((String)"xmpp.create.groupCount", (int)-1);
            if (createGroupUserCount == 0) {
                return false;
            }
            if (createGroupUserCount >= 0 && createGroupUserCount <= (userCount = CreateGroupCountUtil.getCurrCount(CreateGroupCountUtil.getRedisKey(username)))) {
                return false;
            }
        }
        catch (Exception e) {
            Log.error("checkUserCreateGroupCount ,username :{} ,error:{} ,e  ", new Object[]{username, e.getMessage(), e});
        }
        return true;
    }

    private static int getCurrCount(String key) {
        String userCount;
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null && (userCount = redisPoolMgr.get(key)) != null && !userCount.isEmpty()) {
            return Integer.parseInt(userCount);
        }
        return 0;
    }

    public static void setCurrCount(String username) {
        try {
            username = username.toLowerCase();
            RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
            String key = CreateGroupCountUtil.getRedisKey(username);
            int count = CreateGroupCountUtil.getCurrCount(key);
            if (redisPoolMgr != null) {
                redisPoolMgr.set(key, String.valueOf(count + 1), REDIS_EXPIRE.intValue());
            }
        }
        catch (Exception e) {
            Log.error("setCurrCount ,username :{} ,error:{} ,e  ", new Object[]{username, e.getMessage(), e});
        }
    }

    private static String getRedisKey(String username) {
        return REDIS_KEK + CreateGroupCountUtil.getDayStr() + ":" + username;
    }

    private static String getDayStr() {
        SimpleDateFormat SDF_SIMPLE = new SimpleDateFormat("yyyy-MM-dd");
        return SDF_SIMPLE.format(new Date());
    }
}

