/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.weaver.cache.redis.RedisPoolMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.plugin.bean.GroupMessage;
import org.jivesoftware.openfire.plugin.util.SeeHistoryMsgUtil;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDatabaseUtil {
    private static final Logger Log = LoggerFactory.getLogger(GroupDatabaseUtil.class);
    private static final String SELECT_MOBILE_RONGGROUPNOTICE = "select * from mobile_rongGroupNotice where targetid=? order by operate_date desc";
    private static final String INSERT_MOBILE_RONGGROUPNOTICE = "insert into mobile_rongGroupNotice (targetid,content,sendid,operate_date)  values (?,?,?,?)";
    private static String SEARCH_MY_GROUP = "SELECT a.description AS groupName FROM ofGroup a,ofGroupUser b WHERE a.groupName = b.groupName AND (b.isdel is null or b.isdel <> '1') AND a.description LIKE ? AND b.username LIKE ? ORDER BY a.description";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<String> searchMyGroup(String pageNumber, String pageSize, String groupName, String groupMembers) {
        ArrayList<String> listGroupName;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block4: {
            connection = null;
            preparedStatement = null;
            resultSet = null;
            listGroupName = new ArrayList<String>();
            try {
                connection = DbConnectionManager.getConnection();
                preparedStatement = connection.prepareStatement(SEARCH_MY_GROUP);
                preparedStatement.setString(1, "%" + groupName + "%");
                preparedStatement.setString(2, "%" + groupMembers + "%");
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                listGroupName.add(resultSet.getString("groupName"));
            }
            catch (Exception exception) {
                DbConnectionManager.closeConnection(resultSet, (Statement)preparedStatement, (Connection)connection);
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(resultSet, (Statement)preparedStatement, (Connection)connection);
                    throw throwable;
                }
            }
        }
        DbConnectionManager.closeConnection((ResultSet)resultSet, (Statement)preparedStatement, (Connection)connection);
        return listGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getGroupNoticeList(String groupId) {
        ArrayList<Map<String, Object>> noticeList = new ArrayList<Map<String, Object>>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_MOBILE_RONGGROUPNOTICE);
            pstmt.setString(1, groupId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> notice = new HashMap<String, String>();
                notice.put("id", rs.getString("id"));
                notice.put("targetid", rs.getString("targetid"));
                notice.put("sendid", rs.getString("sendid"));
                notice.put("content", rs.getString("content"));
                notice.put("operate_date", rs.getString("operate_date"));
                noticeList.add(notice);
            }
        }
        catch (Exception e) {
            try {
                Log.error("getGroupNoticeList,groupid={},err={}", (Object)groupId, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return noticeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long saveGroupNotice(String groupId, String content, String sendId, String date) {
        long result = 0L;
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            String[] keysName = new String[]{"id"};
            pstmt = con.prepareStatement(INSERT_MOBILE_RONGGROUPNOTICE, keysName);
            pstmt.setString(1, groupId);
            pstmt.setString(2, content);
            pstmt.setString(3, sendId);
            pstmt.setString(4, date);
            pstmt.execute();
            ResultSet generatedKeys = pstmt.getGeneratedKeys();
            while (generatedKeys.next()) {
                result = generatedKeys.getLong(1);
            }
        }
        catch (Exception e) {
            try {
                Log.error("saveGroupNotice,sendId:{},err:{},e:{}", new Object[]{sendId, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupNotice(String groupId, String content, String sendId, String noticeId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" update mobile_rongGroupNotice set content = ?,sendid=? where targetid = ? and id = ? ");
            pstmt.setString(1, content);
            pstmt.setString(2, sendId);
            pstmt.setString(3, groupId);
            pstmt.setString(4, noticeId);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                Log.error("updateGroupNotice,error:{},e:{},groupId:{},content:{},sendId:{},noticeId:{}", new Object[]{e.getMessage(), e, groupId, content, sendId, noticeId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroupNotice(String groupId, String noticeId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" delete from mobile_rongGroupNotice where targetid = ? and id = ? ");
            pstmt.setString(1, groupId);
            pstmt.setString(2, noticeId);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                Log.error("deleteGroupNotice,error:{},e:{},groupId:{}noticeId:{}", new Object[]{e.getMessage(), e, groupId, noticeId});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    public static void main(String[] args) {
        HashMap<String, Boolean> s = new HashMap<String, Boolean>();
        s.put("2838|1-MdVCKbQDu-5g-vspXvLQ", true);
        GroupDatabaseUtil gdu = new GroupDatabaseUtil();
        gdu.seeHistoryMsg("8d460dc6-82e3-47c3-aeb2-1bfaf2736aef", s, 10, "2838|1-MdVCKbQDu-5g-vspXvLQ", "2838|1-MdVCKbQDu-5g-vspXvLQ");
    }

    public void delRedisKeyForSeeKeyMsg(String groupId) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        if (redisPoolMgr != null) {
            redisPoolMgr.del("seeGroupHistoryMsg:" + groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchGroupUser(String username, List<String> groupUsers, int pageSize, int pageNumber) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = this.getSQLForSearchGroupUsers(username, groupUsers);
        String sqlByPage = "";
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = " SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlByPage = " SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
        } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sqlByPage);
            int index = 0;
            if (username != null && !username.isEmpty()) {
                pstmt.setString(++index, username);
            }
            pstmt.setInt(++index, groupUsers.size());
            for (String uName : groupUsers) {
                pstmt.setString(++index, uName);
            }
            rs = pstmt.executeQuery();
            ArrayList groups = new ArrayList();
            while (rs.next()) {
                HashMap<String, CharSequence> group = new HashMap<String, CharSequence>();
                group.put("groupName", rs.getString("description"));
                group.put("groupId", rs.getString("groupName"));
                group.put("groupMemberSize", rs.getString("groupUserCount"));
                group.put("msgContent", rs.getString("msgcontent"));
                group.put("lasttime", rs.getString("lasttime"));
                group.put("groupIconUrl", rs.getString("groupIcon"));
                group.put("groupType", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupType"), (CharSequence)"0"));
                group.put("secretGroupType", StringUtils.defaultIfEmpty((CharSequence)rs.getString("secretGroupType"), (CharSequence)"0"));
                groups.add(group);
            }
            result.put("allGroups", groups);
            result.put("pageNumber", pageNumber);
            result.put("pageSize", pageSize);
            result.put("totalCount", pageSize);
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            Log.error("searchGroupUser,error:{}", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        return result;
    }

    private String getSQLForSearchGroupUsers(String username, List<String> groupUsers) {
        String sql = "";
        String sqlBack = " a.groupName as groupName,g.description,b.msgcontent as msgcontent,b.lasttime as lasttime,g.secretGroupType as secretGroupType,(select count(1) as userCount from ofGroupUser where groupName = g.groupName) as groupUserCount,(select propValue from ofgroupProp where groupName = g.groupName and name = 'groupType') as groupType ,g.groupIconUrl as groupIcon";
        String sqlFrom = " ofGroup g join ofGroupUser a on g.groupName = a.groupName left join social_IMConversation b on a.groupName = b.targetid and b.targettype = 1 ";
        String sqlWhere = " g.description is not null and g.description <> '' ";
        if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlWhere = " g.description is not null ";
        }
        String sqlOrder = " order by b.lasttime desc ";
        if (username != null && !username.isEmpty()) {
            sqlWhere = sqlWhere + " and a.username = ? AND (a.isdel is null or a.isdel <> '1')";
        }
        if (groupUsers != null && groupUsers.size() > 0) {
            sqlWhere = sqlWhere + " and (select count(1) as userCount from ofGroupUser where groupName = g.groupName ) =  ? ";
            for (String uName : groupUsers) {
                sqlWhere = sqlWhere + " and EXISTS (select 1 from ofGroupUser where groupName = g.groupName and username = ? )";
            }
        }
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select ROW_NUMBER() OVER(ORDER BY b.lasttime DESC) AS rn," + sqlBack + " from" + sqlFrom + " where" + sqlWhere;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.postgresql)) {
            sql = "select " + sqlBack + " from" + sqlFrom + " where" + sqlWhere + sqlOrder;
        }
        return sql;
    }

    private String[] getSQLForSearchGroup1(String username, String queryGroupName, String groupType, String groupAdmin, Long createTimeStart, Long createTimeEnd, String createUser, String tagValue, boolean needSearchGroupMemberName, String groupPropType, List<String> groupSearchMembers, String isTop, List<String> groupMembers) {
        boolean branch;
        String sqlBack = " g.groupName as groupName,g.groupIconUrl as groupIcon,g.createUser as createUser, g.groupType as groupType,g.createtime as createtime,g.description,g.isTop as isTop,g.secretGroupType as secretGroupType,b.msgcontent as msgcontent,b.lasttime as lasttime, (select count(1) as userCount from ofGroupUser where groupName = g.groupName and (ofgroupUser.isdel is null or ofgroupuser.isdel <> '1')) as groupUserCount";
        String sqlFrom = " ofGroup g join ofGroupUser a on g.groupName = a.groupName and a.username = ? AND (a.isdel is null or a.isdel <> '1') left join social_IMRecentConver b on g.groupName = b.targetid and b.userId = ? ";
        String sqlWhere = " g.description is not null and g.description <> ''  and (g.deleteGroup <> 'true' or deleteGroup is NULL) and ( g.secretGroupType <> '1' or  g.secretGroupType is NULL ) ";
        if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.postgresql)) {
            sqlWhere = " g.description is not null and (g.deleteGroup <> 'true' or deleteGroup is NULL) and ( g.secretGroupType <> '1' or  g.secretGroupType is NULL )";
        }
        if (username == null || username.isEmpty()) {
            sqlWhere = sqlWhere + " and not EXISTS (select 1 from ofGroupProp where  groupName = g.groupName and name = 'deleteGroup' and propValue = 'true' )";
        }
        String sqlOrder = " order by b.lasttime desc ";
        String totalSql = "";
        String sql = "";
        if (queryGroupName != null && !queryGroupName.isEmpty()) {
            String keyWord;
            Iterator<String> groupNameSearch = "description";
            if (!JiveGlobals.getBooleanProperty((String)"GroupNameToPinyin", (boolean)true)) {
                groupNameSearch = "searchGroupName";
            }
            String groupTagSearch = "tagValue";
            if (!JiveGlobals.getBooleanProperty((String)"GroupTagToPinyin", (boolean)true)) {
                groupTagSearch = "searchTagValue";
            }
            String searchName = "name";
            if (!JiveGlobals.getBooleanProperty((String)"UserNameToPinyin", (boolean)true)) {
                searchName = "searchname";
            }
            if (needSearchGroupMemberName && username != null && !username.isEmpty()) {
                int i;
                ArrayList<String> keyWords = new ArrayList<String>();
                if (queryGroupName.contains(" ")) {
                    String[] queryGroupNameArr = queryGroupName.split(" ");
                    for (i = 0; i < queryGroupNameArr.length; ++i) {
                        keyWord = queryGroupNameArr[i];
                        if (keyWord == null || keyWord.isEmpty()) continue;
                        keyWords.add(keyWord);
                    }
                }
                if (keyWords != null && keyWords.size() == 1) {
                    queryGroupName = (String)keyWords.get(0);
                }
                if (keyWords != null && keyWords.size() > 1) {
                    String groupSearchType = JiveGlobals.getProperty((String)"groupSeachType", (String)"2");
                    if ("1".equals(groupSearchType)) {
                        String keyWord2;
                        int i2;
                        String groupTagLike;
                        String groupUserNameLike;
                        if (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm)) {
                            String descriptionlike = "";
                            groupUserNameLike = "";
                            groupTagLike = "";
                            for (i2 = 0; i2 < keyWords.size(); ++i2) {
                                keyWord2 = (String)keyWords.get(i2);
                                if (keyWord2 == null || keyWord2.isEmpty()) continue;
                                descriptionlike = descriptionlike.isEmpty() ? descriptionlike + " (upper(dbms_lob.substr(g." + groupNameSearch + ")) LIKE upper(?)) " : descriptionlike + " (and upper(dbms_lob.substr(g." + groupNameSearch + ")) LIKE upper(?)) ";
                                groupUserNameLike = groupUserNameLike.isEmpty() ? groupUserNameLike + " EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(dbms_lob.substr(ofuser." + searchName + ")) LIKE upper(?))" : groupUserNameLike + "AND EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(dbms_lob.substr(ofuser." + searchName + ")) LIKE upper(?))";
                                groupTagLike = groupTagLike.isEmpty() ? groupTagLike + " EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and (upper(dbms_lob.substr(" + groupTagSearch + ")) like upper(?))" : groupTagLike + " AND EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and (upper(dbms_lob.substr(" + groupTagSearch + ")) like upper(?))";
                            }
                            sqlWhere = sqlWhere + " and ((" + descriptionlike + ") or (" + groupUserNameLike + ")) or  (" + groupTagLike + "))";
                        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                            String descriptionlike = "";
                            groupUserNameLike = "";
                            groupTagLike = "";
                            for (i2 = 0; i2 < keyWords.size(); ++i2) {
                                keyWord2 = (String)keyWords.get(i2);
                                if (keyWord2 == null || keyWord2.isEmpty()) continue;
                                descriptionlike = descriptionlike.isEmpty() ? descriptionlike + " (upper(g." + groupNameSearch + ") LIKE upper(?)) " : descriptionlike + " and (upper(g." + groupNameSearch + ") LIKE upper(?)) ";
                                groupUserNameLike = groupUserNameLike.isEmpty() ? groupUserNameLike + " EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(ofuser." + searchName + ") LIKE upper(?))" : groupUserNameLike + " AND EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(ofuser." + searchName + ") LIKE upper(?))";
                                groupTagLike = groupTagLike.isEmpty() ? groupTagLike + " EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and (upper(" + groupTagSearch + ") like upper(?))" : groupTagLike + "AND EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and (upper(" + groupTagSearch + ") like upper(?))";
                            }
                            sqlWhere = sqlWhere + " and ((" + descriptionlike + ") or (" + groupUserNameLike + ")) or (" + groupTagLike + "))";
                        } else {
                            String descriptionlike = "";
                            groupUserNameLike = "";
                            groupTagLike = "";
                            for (i2 = 0; i2 < keyWords.size(); ++i2) {
                                keyWord2 = (String)keyWords.get(i2);
                                if (keyWord2 == null || keyWord2.isEmpty()) continue;
                                descriptionlike = descriptionlike.isEmpty() ? descriptionlike + " (g." + groupNameSearch + " like ?) " : descriptionlike + " and (g." + groupNameSearch + " like ?) ";
                                groupUserNameLike = groupUserNameLike.isEmpty() ? groupUserNameLike + " EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and ofuser." + searchName + " LIKE ?)" : groupUserNameLike + " AND EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and ofuser." + searchName + " LIKE ?)";
                                groupTagLike = groupTagLike.isEmpty() ? groupTagLike + " EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and " + groupTagSearch + " like ?) " : groupTagLike + " AND EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and " + groupTagSearch + " like ?) ";
                            }
                            sqlWhere = sqlWhere + " and ( (" + descriptionlike + ") or (" + groupUserNameLike + ")or (" + groupTagLike + "))";
                        }
                    } else if ("2".equals(groupSearchType)) {
                        for (i = 0; i < keyWords.size(); ++i) {
                            keyWord = (String)keyWords.get(i);
                            if (keyWord == null || keyWord.isEmpty()) continue;
                            sqlWhere = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) ? sqlWhere + " and ( upper(dbms_lob.substr(g." + groupNameSearch + ")) LIKE upper(?)  or EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(dbms_lob.substr(ofuser." + searchName + ")) LIKE upper(?) )  or EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and upper(dbms_lob.substr(" + groupTagSearch + ")) like upper(? ) )) " : (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? sqlWhere + " and ( upper(g." + groupNameSearch + ") LIKE upper(?)  or EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(ofuser." + searchName + ") LIKE upper(?) )  or EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and upper(" + groupTagSearch + ") like upper(?) )) " : sqlWhere + " and (g." + groupNameSearch + " like ?  or EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1') and ofuser." + searchName + " like ? )  or EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and " + groupTagSearch + " like ?) ) ");
                        }
                    }
                } else {
                    sqlWhere = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) ? sqlWhere + " and ( upper(dbms_lob.substr(g." + groupNameSearch + ")) LIKE upper(?)  or EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(dbms_lob.substr(ofuser." + searchName + ")) LIKE upper(?) )  or EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and upper(dbms_lob.substr(" + groupTagSearch + ")) like upper(?) )) " : (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? sqlWhere + " and ( upper(g." + groupNameSearch + ") LIKE upper(?)  or EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1')  and upper(ofuser." + searchName + ") LIKE upper(?) )  or EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and upper(" + groupTagSearch + ") like upper(?) )) " : sqlWhere + " and (g." + groupNameSearch + " like ?  or EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1') and ofuser." + searchName + " like ? )  or EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and " + groupTagSearch + " like ? ) ) ");
                }
            } else if (queryGroupName.contains(" ")) {
                int i;
                String descriptionlike;
                String[] queryGroupNameArr = queryGroupName.split(" ");
                if (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm)) {
                    descriptionlike = "";
                    for (i = 0; i < queryGroupNameArr.length; ++i) {
                        keyWord = queryGroupNameArr[i];
                        if (keyWord == null || keyWord.isEmpty()) continue;
                        descriptionlike = descriptionlike.isEmpty() ? descriptionlike + " (upper(dbms_lob.substr(g." + groupNameSearch + ")) LIKE upper(?)) " : descriptionlike + " (and upper(dbms_lob.substr(g." + groupNameSearch + ")) LIKE upper(?)) ";
                    }
                    sqlWhere = sqlWhere + " and (" + descriptionlike + ")";
                } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                    descriptionlike = "";
                    for (i = 0; i < queryGroupNameArr.length; ++i) {
                        keyWord = queryGroupNameArr[i];
                        if (keyWord == null || keyWord.isEmpty()) continue;
                        descriptionlike = descriptionlike.isEmpty() ? descriptionlike + " (upper(g." + groupNameSearch + ") LIKE upper(?)) " : descriptionlike + " and (upper(g." + groupNameSearch + ") LIKE upper(?)) ";
                    }
                    sqlWhere = sqlWhere + " and (" + descriptionlike + ")";
                } else {
                    descriptionlike = "";
                    for (i = 0; i < queryGroupNameArr.length; ++i) {
                        keyWord = queryGroupNameArr[i];
                        if (keyWord == null || keyWord.isEmpty()) continue;
                        descriptionlike = descriptionlike.isEmpty() ? descriptionlike + " (g." + groupNameSearch + " like ?) " : descriptionlike + " and (g." + groupNameSearch + " like ?) ";
                    }
                    sqlWhere = sqlWhere + " and (" + descriptionlike + ")";
                }
            } else {
                sqlWhere = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) ? sqlWhere + " AND upper(dbms_lob.substr(g." + (String)((Object)groupNameSearch) + ")) LIKE upper(?) " : (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? sqlWhere + " AND upper(g." + groupNameSearch + ") LIKE upper(?) " : sqlWhere + " and g." + groupNameSearch + " like ? ");
            }
        }
        if ("1".equals(groupType)) {
            sqlWhere = sqlWhere + " and  g.createUser = ? ";
        } else if ("2".equals(groupType)) {
            sqlWhere = sqlWhere + " and (g.createUser is null or g.createUser <> ?)";
        }
        if (groupAdmin != null && !groupAdmin.isEmpty()) {
            sqlWhere = sqlWhere + " and EXISTS (select 1 from ofGroupUser where groupName = g.groupName and administrator = 1 and username = ? AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1') ) ";
        }
        if (createUser != null && !createUser.isEmpty()) {
            sqlWhere = sqlWhere + " and  g.createUser = ? ";
        }
        if (createTimeStart != null && createTimeStart > 0L || createTimeEnd != null && createTimeEnd > 0L) {
            if (createTimeStart != null && createTimeStart > 0L) {
                sqlWhere = sqlWhere + " and g.createtime >= ? ";
            }
            if (createTimeEnd != null && createTimeEnd > 0L) {
                sqlWhere = sqlWhere + " and g.createtime <= ? ";
            }
        }
        if (tagValue != null && !tagValue.isEmpty() && username != null && !username.isEmpty()) {
            sqlWhere = sqlWhere + " and EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and tagValue = ?) ";
        }
        if (groupPropType != null && !groupPropType.isEmpty()) {
            sqlWhere = !"0".equals(groupPropType) ? sqlWhere + " and g.groupType = ? " : sqlWhere + " and (g.groupType = ? OR g.groupType is NULL) ";
        }
        if (isTop != null && !isTop.isEmpty()) {
            sqlWhere = !"0".equals(isTop) ? sqlWhere + " and g.isTop = ? " : sqlWhere + " and (g.isTop = ? OR g.isTop is NULL) ";
        }
        if (groupSearchMembers != null && groupSearchMembers.size() > 0) {
            for (String uName : groupSearchMembers) {
                sqlWhere = sqlWhere + " and EXISTS (select 1 from ofGroupUser where groupName = g.groupName and username = ? AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1') )";
            }
        }
        if (groupMembers != null && groupMembers.size() > 0) {
            sqlWhere = sqlWhere + " and (select count(1) as userCount from ofGroupUser where groupName = g.groupName and (isdel is null or isdel = '0' ) ) = ? ";
            for (String uName : groupMembers) {
                sqlWhere = sqlWhere + " and EXISTS (select 1 from ofGroupUser where groupName = g.groupName and username = ? AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1') )";
            }
        }
        boolean bl = branch = !needSearchGroupMemberName && username != null && !username.isEmpty();
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select ROW_NUMBER() OVER(ORDER BY b.lasttime DESC) AS rn," + sqlBack + " from" + sqlFrom + " where" + sqlWhere;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.jc.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.DatabaseType.gs.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select " + sqlBack + " from" + sqlFrom + " where" + sqlWhere + sqlOrder;
        } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select " + sqlBack + " from" + sqlFrom + " where" + sqlWhere + sqlOrder;
        }
        totalSql = "select count(1) as totalCount from " + sqlFrom + " where" + sqlWhere;
        if (branch) {
            totalSql = "select count(1) as totalCount from (" + sql + ") mid";
        }
        return new String[]{totalSql, sql};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchGroupMessage(String username, String queryGroupName, String groupType, Integer pageSize, Integer pageNumber, String groupAdmin, Long createTimeStart, Long createTimeEnd, String createUser, String tagValue, boolean needSearchGroupMemberName, String groupPropType, List<String> groupSearchMembers, String isTop, List<String> groupMembers) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] sqlS = this.getSQLForSearchGroup1(username, queryGroupName, groupType, groupAdmin, createTimeStart, createTimeEnd, createUser, tagValue, needSearchGroupMemberName, groupPropType, groupSearchMembers, isTop, groupMembers);
        String totalCountSql = sqlS[0];
        Log.info("totalCountSql:{}", (Object)totalCountSql);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String keyWord;
            int a;
            Iterator<String> keyWords;
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(totalCountSql);
            if (JiveGlobals.getBooleanProperty((String)"queryGroupTimeOut", (boolean)false)) {
                pstmt.setQueryTimeout(JiveGlobals.getIntProperty((String)"queryGroupTimeOutSeconds", (int)3));
            }
            int i = 0;
            if (username != null && !username.isEmpty() && !username.contains(",")) {
                pstmt.setString(++i, username);
                pstmt.setString(++i, this.getUserIDByUsername(username));
            }
            if (needSearchGroupMemberName && queryGroupName != null && !queryGroupName.isEmpty()) {
                keyWords = new ArrayList();
                if (queryGroupName.contains(" ")) {
                    String[] queryGroupNameArr = queryGroupName.split(" ");
                    for (a = 0; a < queryGroupNameArr.length; ++a) {
                        keyWord = queryGroupNameArr[a];
                        if (keyWord == null || keyWord.isEmpty()) continue;
                        keyWords.add(keyWord);
                    }
                }
                if (keyWords != null && keyWords.size() == 1) {
                    queryGroupName = (String)keyWords.get(0);
                }
                if (keyWords != null && keyWords.size() > 1) {
                    for (int b = 0; b < keyWords.size(); ++b) {
                        String keyWord2 = (String)keyWords.get(b);
                        if (keyWord2 == null || keyWord2.isEmpty()) continue;
                        pstmt.setString(++i, "%" + keyWord2 + "%");
                        pstmt.setString(++i, "%" + keyWord2 + "%");
                        pstmt.setString(++i, "%" + keyWord2 + "%");
                    }
                } else {
                    pstmt.setString(++i, "%" + queryGroupName + "%");
                    pstmt.setString(++i, "%" + queryGroupName + "%");
                    pstmt.setString(++i, "%" + queryGroupName + "%");
                }
            } else if (queryGroupName != null && !queryGroupName.isEmpty()) {
                keyWords = new ArrayList();
                if (queryGroupName.contains(" ")) {
                    String[] queryGroupNameArr = queryGroupName.split(" ");
                    for (a = 0; a < queryGroupNameArr.length; ++a) {
                        keyWord = queryGroupNameArr[a];
                        if (keyWord == null || keyWord.isEmpty()) continue;
                        keyWords.add(keyWord);
                        for (int b = 0; b < keyWords.size(); ++b) {
                            pstmt.setString(++i, "%" + keyWord + "%");
                        }
                    }
                } else {
                    pstmt.setString(++i, "%" + queryGroupName + "%");
                }
            }
            if ("1".equals(groupType)) {
                pstmt.setString(++i, username);
            } else if ("2".equals(groupType)) {
                pstmt.setString(++i, username);
            }
            if (groupAdmin != null && !groupAdmin.isEmpty()) {
                pstmt.setString(++i, groupAdmin);
            }
            if (createUser != null && !createUser.isEmpty()) {
                pstmt.setString(++i, createUser);
            }
            if (createTimeStart != null && createTimeStart > 0L || createTimeEnd != null && createTimeEnd > 0L) {
                if (createTimeStart != null && createTimeStart > 0L) {
                    pstmt.setLong(++i, createTimeStart);
                }
                if (createTimeEnd != null && createTimeEnd > 0L) {
                    pstmt.setLong(++i, createTimeEnd);
                }
            }
            if (tagValue != null && !tagValue.isEmpty()) {
                pstmt.setString(++i, tagValue);
            }
            if (groupPropType != null && !groupPropType.isEmpty()) {
                pstmt.setString(++i, groupPropType);
            }
            if (isTop != null && !isTop.isEmpty()) {
                pstmt.setString(++i, isTop);
            }
            if (groupSearchMembers != null && groupSearchMembers.size() > 0) {
                for (String uName : groupSearchMembers) {
                    pstmt.setString(++i, uName);
                }
            }
            if (groupMembers != null && groupMembers.size() > 0) {
                pstmt.setInt(++i, groupMembers.size());
                for (String uName : groupMembers) {
                    pstmt.setString(++i, uName);
                }
            }
            rs = pstmt.executeQuery();
            int totalCount = 0;
            while (rs.next()) {
                totalCount = rs.getInt("totalCount");
            }
            result.put("totalCount", totalCount);
            ArrayList groups = new ArrayList();
            if (totalCount > 0) {
                String keyWord3;
                int a2;
                Iterator<String> keyWords2;
                DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
                String sql = sqlS[1];
                String sqlByPage = "";
                if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sqlByPage = "SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
                } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                    sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
                } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
                } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                    sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
                }
                Log.info("sqlByPage:{}", (Object)sqlByPage);
                pstmt = con.prepareStatement(sqlByPage);
                if (JiveGlobals.getBooleanProperty((String)"queryGroupTimeOut", (boolean)false)) {
                    pstmt.setQueryTimeout(JiveGlobals.getIntProperty((String)"queryGroupTimeOutSeconds", (int)3));
                }
                int j = 0;
                if (username != null && !username.isEmpty() && !username.contains(",")) {
                    pstmt.setString(++j, username);
                    pstmt.setString(++j, this.getUserIDByUsername(username));
                }
                if (needSearchGroupMemberName && queryGroupName != null && !queryGroupName.isEmpty()) {
                    keyWords2 = new ArrayList();
                    if (queryGroupName.contains(" ")) {
                        String[] queryGroupNameArr = queryGroupName.split(" ");
                        for (a2 = 0; a2 < queryGroupNameArr.length; ++a2) {
                            keyWord3 = queryGroupNameArr[a2];
                            if (keyWord3 == null || keyWord3.isEmpty()) continue;
                            keyWords2.add(keyWord3);
                        }
                    }
                    if (keyWords2 != null && keyWords2.size() == 1) {
                        queryGroupName = (String)keyWords2.get(0);
                    }
                    if (keyWords2 != null && keyWords2.size() > 1) {
                        for (int b = 0; b < keyWords2.size(); ++b) {
                            String keyWord4 = (String)keyWords2.get(b);
                            if (keyWord4 == null || keyWord4.isEmpty()) continue;
                            pstmt.setString(++j, "%" + keyWord4 + "%");
                            pstmt.setString(++j, "%" + keyWord4 + "%");
                            pstmt.setString(++j, "%" + keyWord4 + "%");
                        }
                    } else {
                        pstmt.setString(++j, "%" + queryGroupName + "%");
                        pstmt.setString(++j, "%" + queryGroupName + "%");
                        pstmt.setString(++j, "%" + queryGroupName + "%");
                    }
                } else if (queryGroupName != null && !queryGroupName.isEmpty()) {
                    keyWords2 = new ArrayList();
                    if (queryGroupName.contains(" ")) {
                        String[] queryGroupNameArr = queryGroupName.split(" ");
                        for (a2 = 0; a2 < queryGroupNameArr.length; ++a2) {
                            keyWord3 = queryGroupNameArr[a2];
                            if (keyWord3 == null || keyWord3.isEmpty()) continue;
                            keyWords2.add(keyWord3);
                            for (int b = 0; b < keyWords2.size(); ++b) {
                                String keyword = (String)keyWords2.get(b);
                                if (keyword == null || keyword.isEmpty()) continue;
                                pstmt.setString(++j, "%" + keyword + "%");
                            }
                        }
                    } else {
                        pstmt.setString(++j, "%" + queryGroupName + "%");
                    }
                }
                if ("1".equals(groupType)) {
                    pstmt.setString(++j, username);
                } else if ("2".equals(groupType)) {
                    pstmt.setString(++j, username);
                }
                if (groupAdmin != null && !groupAdmin.isEmpty()) {
                    pstmt.setString(++j, groupAdmin);
                }
                if (createUser != null && !createUser.isEmpty()) {
                    pstmt.setString(++j, createUser);
                }
                if (createTimeStart != null && createTimeStart > 0L || createTimeEnd != null && createTimeEnd > 0L) {
                    if (createTimeStart != null && createTimeStart > 0L) {
                        pstmt.setLong(++j, createTimeStart);
                    }
                    if (createTimeEnd != null && createTimeEnd > 0L) {
                        pstmt.setLong(++j, createTimeEnd);
                    }
                }
                if (tagValue != null && !tagValue.isEmpty()) {
                    pstmt.setString(++j, tagValue);
                }
                if (groupPropType != null && !groupPropType.isEmpty()) {
                    pstmt.setString(++j, groupPropType);
                }
                if (isTop != null && !isTop.isEmpty()) {
                    pstmt.setString(++j, isTop);
                }
                if (groupSearchMembers != null && groupSearchMembers.size() > 0) {
                    for (String uName : groupSearchMembers) {
                        pstmt.setString(++j, uName);
                    }
                }
                if (groupMembers != null && groupMembers.size() > 0) {
                    pstmt.setInt(++j, groupMembers.size());
                    for (String uName : groupMembers) {
                        pstmt.setString(++j, uName);
                    }
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    HashMap<String, CharSequence> group = new HashMap<String, CharSequence>();
                    group.put("groupName", StringUtils.defaultIfEmpty((CharSequence)rs.getString("description"), (CharSequence)""));
                    group.put("groupId", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupName"), (CharSequence)""));
                    group.put("groupMemberSize", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupUserCount"), (CharSequence)""));
                    group.put("msgContent", StringUtils.defaultIfEmpty((CharSequence)rs.getString("msgcontent"), (CharSequence)""));
                    group.put("lasttime", StringUtils.defaultIfEmpty((CharSequence)rs.getString("lasttime"), (CharSequence)""));
                    group.put("groupIconUrl", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupIcon"), (CharSequence)""));
                    group.put("createUser", StringUtils.defaultIfEmpty((CharSequence)rs.getString("createUser"), (CharSequence)""));
                    group.put("createtime", StringUtils.defaultIfEmpty((CharSequence)rs.getString("createtime"), (CharSequence)""));
                    group.put("groupType", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupType"), (CharSequence)"0"));
                    group.put("isTop", StringUtils.defaultIfEmpty((CharSequence)rs.getString("isTop"), (CharSequence)"0"));
                    group.put("secretGroupType", StringUtils.defaultIfEmpty((CharSequence)rs.getString("secretGroupType"), (CharSequence)"0"));
                    groups.add(group);
                }
            }
            result.put("allGroups", groups);
            result.put("pageNumber", pageNumber);
            result.put("pageSize", pageSize);
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("searchGroupMessage error:{}", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupMessage> getGroupMessage(String username) {
        long startTime = System.currentTimeMillis();
        ArrayList<GroupMessage> groups = new ArrayList<GroupMessage>();
        GroupManager groupManager = GroupManager.getInstance();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("select a.groupName as groupName,b.msgcontent as msgcontent,b.lasttime as lasttime  from ofGroupUser a left join social_IMConversation b on a.groupName = b.targetid and b.targettype = 1  where  a.username = ? AND (a.isdel is null or a.isdel <> '1')  order by b.lasttime desc ");
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                GroupMessage gm = new GroupMessage();
                String groupName = rs.getString("groupName");
                try {
                    Group group = groupManager.getGroup(groupName);
                    gm.setGroup(group);
                }
                catch (Exception e) {
                    Log.error("getGroupMessage ,groupNot found.groupName:{},username :{}", (Object)groupName, (Object)username);
                    continue;
                }
                gm.setLasttime(rs.getString("lasttime"));
                gm.setMsgContent(rs.getString("msgcontent"));
                groups.add(gm);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroupMessage ,error :{} ,username :{} ", (Object)e.getMessage(), (Object)username);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        long endTime = System.currentTimeMillis();
        Log.info("getGroupMessage ,username :{} ,groupSize :{} ,cost:{} ms", new Object[]{username, groups.size(), endTime - startTime});
        return groups;
    }

    public static List<String> zinterstore(String key2, String key3, String key4) {
        Log.info("zinterstore,key2:{},key3:{},key4:{}", new Object[]{key2, key3, key4});
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        try {
            Set adminsUserKey = null;
            if (key3.equals(key4)) {
                adminsUserKey = redisPoolMgr.zrange(key3, 0L, -1L);
            } else {
                Set key4Set;
                adminsUserKey = redisPoolMgr.zrange(key3, 0L, -1L);
                if (adminsUserKey == null || adminsUserKey.isEmpty()) {
                    adminsUserKey = new HashSet();
                }
                if ((key4Set = redisPoolMgr.zrange(key4, 0L, -1L)) != null && !key4Set.isEmpty()) {
                    adminsUserKey.addAll(key4Set);
                }
            }
            Log.info("adminUserKey :{} ", (Object)adminsUserKey);
            ArrayList adminsUserList = new ArrayList(adminsUserKey);
            Set queueKeys = redisPoolMgr.zrange(key2, 0L, -1L);
            Log.info("queueKeys :{} ", (Object)queueKeys);
            ArrayList queueKeyList = new ArrayList(queueKeys);
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(adminsUserList);
            result.retainAll(queueKeyList);
            Log.info("result:{}", result);
            return result;
        }
        catch (Exception e) {
            Log.error("redis get error, key: {} ,err msg:{}", (Object)e.getMessage());
            return null;
        }
    }

    public boolean seeHistoryMsg(String groupId, Map<String, Boolean> users, int seeHistoryMsg, String opeartar, String groupAdmin) {
        Log.info("seeHistoryMsg.groupId:{},users:{}\uff0copeartar :{} ,groupAdmin :{} ", new Object[]{groupId, users, opeartar, groupAdmin});
        try {
            SeeHistoryMsgUtil.seeHistoryMsg(seeHistoryMsg, groupId, groupAdmin, opeartar, users);
        }
        catch (Exception e) {
            Log.error("seeHistoryMsg ,error :{} ,e :{} ", (Object)e.getMessage(), (Object)e);
        }
        return true;
    }

    private String getUserIDByUsername(String username) {
        if (username != null && username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }

    private String getConversationItmesKeyHead(String targetId) {
        return "conversation:itmes:" + targetId + ":";
    }

    private String getConversationTopKey(String userId) {
        return "conversation:top:" + userId;
    }

    private String getConversationRightKey(String userId) {
        return "conversation:right:" + userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteConversationByExitGroup(String groupId, List<String> userids) {
        boolean isSuccess;
        block13: {
            PreparedStatement pstmt;
            Connection con;
            long updatetime;
            block14: {
                isSuccess = true;
                updatetime = System.currentTimeMillis();
                Log.info("deleteConversationByExitGroup groupId:{},userid:{}", (Object)groupId, userids);
                try {
                    RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
                    for (String userid : userids) {
                        String key = this.getConversationItmesKeyHead(groupId) + this.getUserIDByUsername(userid);
                        boolean result = redisPoolMgr.hexists(key, "isdel");
                        if (result) {
                            redisPoolMgr.hset(key, "isdel", "1");
                            redisPoolMgr.hset(key, "istop", "0");
                            redisPoolMgr.zadd(this.getConversationRightKey(this.getUserIDByUsername(userid)), System.currentTimeMillis(), key, 604800);
                            redisPoolMgr.zadd("conversation:queue", System.currentTimeMillis(), key, 604800);
                        }
                        redisPoolMgr.zrem(this.getConversationTopKey(this.getUserIDByUsername(userid)), key);
                    }
                }
                catch (Exception e) {
                    Log.error("GroupDatabaseUtil->deleteOFConversation: userid:{},targetid:{}, error:{}", new Object[]{userids, groupId, e.getMessage()});
                }
                if (userids != null) break block14;
                con = null;
                pstmt = null;
                try {
                    con = DbConnectionManager.getConnection();
                    pstmt = con.prepareStatement(" update social_IMRecentConver set isdel = 1,updatetime = ? where targetid = ? ");
                    pstmt.setLong(1, updatetime);
                    pstmt.setString(2, groupId);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    try {
                        Log.error("deleteConversationByExitGroup,groupId:{},userid:{},error:{}", new Object[]{groupId, userids, e.getMessage()});
                        isSuccess = false;
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeConnection(pstmt, (Connection)con);
                        throw throwable;
                    }
                    DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
                    break block13;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
                break block13;
            }
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(" update social_IMRecentConver set isdel = 1,updatetime = ? where targetid = ? and userid = ? ");
                for (String userid : userids) {
                    pstmt.setLong(1, updatetime);
                    pstmt.setString(2, groupId);
                    pstmt.setString(3, this.getUserIDByUsername(userid));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (SQLException e) {
                try {
                    Log.error("deleteConversationByExitGroup,groupId:{},userid:{},error:{}", new Object[]{groupId, userids, e.getMessage()});
                    isSuccess = false;
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchGroups(String userName, String createUser, String groupName, Long createTimeStart, Long createTimeEnd, Integer pageSize, Integer pageNumber) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] sqlS = this.getSQLForSearchGroups(userName, createUser, groupName, createTimeStart, createTimeEnd);
        String totalCountSql = sqlS[0];
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(totalCountSql);
            int i = 0;
            if (userName != null && !userName.isEmpty()) {
                pstmt.setString(++i, userName);
            }
            if (groupName != null && !groupName.isEmpty()) {
                pstmt.setString(++i, "%" + groupName + "%");
            }
            if (createUser != null && !createUser.isEmpty()) {
                pstmt.setString(++i, createUser);
            }
            if (createTimeStart != null && createTimeStart > 0L) {
                pstmt.setLong(++i, createTimeStart);
            }
            if (createTimeEnd != null && createTimeEnd > 0L) {
                pstmt.setLong(++i, createTimeEnd);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                result.put("totalCount", rs.getInt("totalCount"));
            }
            DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
            String sql = sqlS[1];
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "SELECT * FROM (" + sql + ") AS pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + ")pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
            }
            pstmt = con.prepareStatement(sqlByPage);
            int j = 0;
            if (userName != null && !userName.isEmpty()) {
                pstmt.setString(++j, userName);
            }
            if (groupName != null && !groupName.isEmpty()) {
                pstmt.setString(++j, "%" + groupName + "%");
            }
            if (createUser != null && !createUser.isEmpty()) {
                pstmt.setString(++j, createUser);
            }
            if (createTimeStart != null && createTimeStart > 0L) {
                pstmt.setLong(++j, createTimeStart);
            }
            if (createTimeEnd != null && createTimeEnd > 0L) {
                pstmt.setLong(++j, createTimeEnd);
            }
            ArrayList groups = new ArrayList();
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> group = new HashMap<String, String>();
                group.put("groupName", rs.getString("description"));
                group.put("groupId", rs.getString("groupName"));
                group.put("groupMemberSize", rs.getString("groupUserCount"));
                group.put("msgContent", rs.getString("msgcontent"));
                group.put("lasttime", rs.getString("lasttime"));
                group.put("groupIconUrl", rs.getString("groupIcon"));
                group.put("createtime", rs.getString("createtime"));
                group.put("createUser", rs.getString("createUser"));
                groups.add(group);
            }
            result.put("allGroups", groups);
            result.put("pageNumber", pageNumber);
            result.put("pageSize", pageSize);
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            Log.error("searchGroupMessage error:{}", (Object)e.getMessage());
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        return result;
    }

    private String[] getSQLForSearchGroups(String userName, String createUser, String groupName, Long createTimeStart, Long createTimeEnd) {
        String sqlBack = " a.groupName as groupName,g.description,b.msgcontent as msgcontent,b.lasttime as lasttime,(select count(1) as userCount from ofGroupUser where groupName = g.groupName AND (ofgroupuser.isdel is null or ofgroupuser.isdel <> '1') ) as groupUserCount ,g.groupIconUrl as groupIcon,g.createtime as createtime,g.createUser as createUser ";
        String sqlFrom = " ofGroup g join ofGroupUser a on g.groupName = a.groupName left join social_IMConversation b on a.groupName = b.targetid and b.targettype = 1 ";
        String sqlWhere = " g.description is not null and g.description <> ''";
        if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sqlWhere = " g.description is not null ";
        }
        String sqlOrder = " order by b.lasttime desc ";
        String totalSql = "";
        String sql = "";
        if (userName != null && !userName.isEmpty()) {
            sqlWhere = sqlWhere + " and a.username = ? ";
        }
        if (groupName != null && !groupName.isEmpty()) {
            sqlWhere = sqlWhere + " and g.description like ? ";
        }
        if (createUser != null && !createUser.isEmpty()) {
            sqlWhere = sqlWhere + " and g.createUser = ? ";
        }
        if (createTimeStart != null && createTimeStart > 0L || createTimeEnd != null && createTimeEnd > 0L) {
            if (createTimeStart != null && createTimeStart > 0L) {
                sqlWhere = sqlWhere + " and g.createTime >= ? ";
            }
            if (createTimeEnd != null && createTimeEnd > 0L) {
                sqlWhere = sqlWhere + " and g.createTime <= ? ";
            }
        }
        totalSql = "select count(1) as totalCount from " + sqlFrom + " where" + sqlWhere;
        if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
            sql = "select ROW_NUMBER() OVER(ORDER BY b.lasttime DESC) AS rn," + sqlBack + " from" + sqlFrom + " where" + sqlWhere;
        } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.dm.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.DatabaseType.st.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
            sql = "select " + sqlBack + " from" + sqlFrom + " where" + sqlWhere + sqlOrder;
        }
        return new String[]{totalSql, sql};
    }
}

