/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.weaver.util.GroupNoticeUtil;
import com.weaver.util.ThreadPoolFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.jivesoftware.openfire.plugin.bean.DizMessage;
import org.jivesoftware.openfire.plugin.tag.GroupTagUtil;
import org.jivesoftware.openfire.plugin.util.GroupDatabaseUtil;
import org.jivesoftware.openfire.plugin.util.UsernameUtil;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class GroupOpUtil {
    private static final Logger Log = LoggerFactory.getLogger(GroupOpUtil.class);
    GroupManager groupManager = GroupManager.getInstance();
    UserManager userManager = UserManager.getInstance();

    public boolean dismissGroup(String operator, String groupId, String content) {
        Group group = null;
        User user = null;
        String operaName = null;
        try {
            group = this.groupManager.getGroup(groupId);
            if (operator != null && !operator.isEmpty()) {
                user = this.userManager.getUser(operator);
                operaName = UsernameUtil.getUserName(operator, user.getName());
            }
        }
        catch (GroupNotFoundException e) {
            Log.error("dissmissGroup.fromJID :{} .groupID:{}.group is not found .", (Object)operator, (Object)groupId);
            return true;
        }
        catch (UserNotFoundException e) {
            Log.error("dissmissGroup .fromJID :{} .groupID :{} .user is not found .", (Object)operator, (Object)groupId);
            return false;
        }
        PersistableMap groupPropMap = group.getProperties();
        if (groupPropMap != null) {
            groupPropMap.put((Object)"deleteGroup", (Object)"true");
            groupPropMap.put((Object)"dissolution_time", (Object)String.valueOf(System.currentTimeMillis()));
        }
        GroupDatabaseUtil gdb = new GroupDatabaseUtil();
        gdb.deleteConversationByExitGroup(groupId, null);
        ArrayList<String> userList = new ArrayList<String>();
        Collection jids = group.getAll();
        for (JID jid : jids) {
            userList.add(jid.getNode());
        }
        GroupTagUtil gtu = new GroupTagUtil();
        gtu.delGroupTags(groupId, userList);
        if (content == null || content.isEmpty()) {
            String deleteGroup = LocaleUtils.getLocalizedString((String)"group.iq.deleteGroup", (String)"group");
            content = operaName == null || operaName.isEmpty() ? LocaleUtils.getLocalizedString((String)"group.iq.admin", (String)"group") + deleteGroup : operaName + deleteGroup;
        }
        final Group grouptemp = group;
        final User usertemp = user;
        String extensiontemp = "deleteGroup";
        final String finalContent = content;
        ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Message infoMessage = new Message();
                infoMessage.setID(StringUtils.randomString((int)8));
                infoMessage.setType(Message.Type.chat);
                if (usertemp != null && !usertemp.getUsername().isEmpty()) {
                    infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                } else {
                    infoMessage.setFrom(XMPPServer.getInstance().getServerInfo().getXMPPDomain());
                }
                infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                DizMessage diz = null;
                diz = usertemp != null && !usertemp.getUsername().isEmpty() ? new DizMessage(10, usertemp.getUID(), "deleteGroup") : new DizMessage(10, "admin", "deleteGroup");
                diz.setContent(finalContent);
                infoMessage.setBody(diz.toString());
                Log.info("dissmissGroup infoMessage:{}", (Object)infoMessage.toString());
                GroupPlugin.groupPlugin.sendMessage(infoMessage);
                try {
                    Collection admins = grouptemp.getAdmins();
                    Collection members = grouptemp.getMembers();
                    ArrayList<JID> adminsList = new ArrayList<JID>();
                    for (JID jid : admins) {
                        adminsList.add(jid);
                    }
                    ArrayList<JID> membersList = new ArrayList<JID>();
                    for (JID jid : members) {
                        membersList.add(jid);
                    }
                    for (JID jid : adminsList) {
                        grouptemp.getAdmins().remove(jid);
                    }
                    for (JID jid : membersList) {
                        grouptemp.getMembers().remove(jid);
                    }
                }
                catch (Exception e) {
                    Log.error("dissmiss Group.dissmiss groupMembers error:{},groupId:{}", (Object)e.getMessage(), (Object)grouptemp.getName());
                }
            }
        });
        return true;
    }

    public void deleteGroupUsers(String operater, String groupId, List<String> users, String content, boolean needMsg, List<String> members, String groupType) {
        try {
            JID jid;
            Group group = this.groupManager.getGroup(groupId);
            User user = null;
            StringJoiner extension = new StringJoiner(",");
            ArrayList<String> userNamesList = new ArrayList<String>();
            String operaterName = "";
            PersistableMap groupProp = group.getProperties();
            String groupManagers = null;
            if (groupProp != null && groupProp.containsKey((Object)"groupManagers")) {
                groupManagers = (String)groupProp.get((Object)"groupManagers");
            }
            JSONArray jsonManagers = null;
            if (groupManagers != null) {
                jsonManagers = JSON.parseArray(groupManagers);
            }
            boolean needRemoveManager = false;
            ArrayList<JID> userlist = new ArrayList<JID>();
            for (String username : users) {
                try {
                    user = this.userManager.getUser(username);
                    userNamesList.add(UsernameUtil.getUserName(operater, user.getName()));
                    if (jsonManagers != null && jsonManagers.contains((Object)username)) {
                        jsonManagers.remove((Object)username);
                        Log.info("user:{},is group manager.not delete from group:{}", (Object)username, (Object)groupId);
                        needRemoveManager = true;
                    }
                    if (user == null) continue;
                    JID jid2 = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    Collection groupMembers = group.getMembers();
                    Collection groupAdmins = group.getAdmins();
                    if (groupMembers == null || !groupMembers.contains(jid2) && !groupAdmins.contains(jid2)) continue;
                    userlist.add(jid2);
                    members.add(username);
                    extension.add(user.getUID());
                }
                catch (UserNotFoundException e) {
                    Log.error("deleteGroupUsers,user {} not found.", (Object)username);
                }
            }
            GroupTagUtil gtu = new GroupTagUtil();
            gtu.delUserGroupTags(groupId, users);
            if (needRemoveManager) {
                groupProp.put((Object)"groupManagers", (Object)jsonManagers.toString());
            }
            try {
                if (operater != null && !operater.isEmpty()) {
                    user = this.userManager.getUser(operater);
                    operaterName = UsernameUtil.getUserName(operater, user.getName());
                }
            }
            catch (UserNotFoundException e) {
                Log.error("deteleGroupUsers,user {} not found.", (Object)operater);
            }
            if (userlist.size() <= 0 || "".equals(extension)) {
                Log.info("deleteGroupUsers.user not found.or user is not group member.groupName:{},users:{}", (Object)groupId, users);
                return;
            }
            if (content == null || content.isEmpty()) {
                StringBuilder contentSbld = new StringBuilder();
                contentSbld.append(operaterName);
                contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.deletejiang", (String)"group"));
                if (userNamesList.size() > 4) {
                    contentSbld.append((String)userNamesList.get(0));
                    contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.etc", (String)"group"));
                    contentSbld.append(userNamesList.size());
                    contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.delete.people", (String)"group"));
                } else {
                    contentSbld.append(String.join((CharSequence)",", userNamesList));
                }
                contentSbld.append(LocaleUtils.getLocalizedString((String)"group.iq.delete.group", (String)"group"));
                content = contentSbld.toString();
            }
            if (operater == null || operater.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                if (userNamesList.size() > 4) {
                    sb.append((String)userNamesList.get(0));
                    sb.append(LocaleUtils.getLocalizedString((String)"group.iq.etc", (String)"group"));
                    sb.append(userNamesList.size());
                    sb.append(LocaleUtils.getLocalizedString((String)"group.iq.delete.people", (String)"group"));
                } else {
                    sb.append(String.join((CharSequence)",", userNamesList));
                }
                sb.append(LocaleUtils.getLocalizedString((String)"group.iq.delete.group", (String)"group"));
                content = sb.toString();
            }
            final User usertemp = user;
            final String extensiontemp = extension.toString();
            final Group grouptemp = group;
            final ArrayList<JID> userlisttemp = userlist;
            final String finalContent = content;
            final String groupPropType = groupType;
            Iterator iterator = userlisttemp.iterator();
            while (iterator.hasNext()) {
                jid = (JID)iterator.next();
                grouptemp.getMembers().remove(jid);
                grouptemp.getAdmins().remove(jid);
            }
            if ("0".equals(groupPropType) && grouptemp.getAdmins().size() == 0 && grouptemp.getMembers().size() > 0 && (iterator = grouptemp.getMembers().iterator()).hasNext()) {
                jid = (JID)iterator.next();
                grouptemp.getMembers().remove(jid);
                grouptemp.getAdmins().add(jid);
            }
            if (needMsg) {
                ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        String show_userIds;
                        Message infoMessage = new Message();
                        infoMessage.setID(StringUtils.randomString((int)8));
                        infoMessage.setType(Message.Type.chat);
                        infoMessage.setFrom(new JID(usertemp.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                        infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                        DizMessage diz = new DizMessage(4, usertemp.getUID(), extensiontemp);
                        if (!"0".equals(groupPropType)) {
                            diz = new DizMessage(19, "admin", extensiontemp);
                            int groupRuleChangeNotice = JiveGlobals.getIntProperty((String)"groupRuleChangeNotice", (int)1);
                            if (GroupNoticeUtil.checkGroupJudgtActiveDay((String)grouptemp.getName())) {
                                if (0 == groupRuleChangeNotice) {
                                    diz.setShow_userIds("-1");
                                    diz.setNo_conv("1");
                                    diz.setNo_db("1");
                                } else if (1 == groupRuleChangeNotice) {
                                    show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                                    diz.setShow_userIds(show_userIds);
                                    diz.setTo_users(show_userIds);
                                } else if (2 == groupRuleChangeNotice) {
                                    diz.setShow_userIds("0");
                                }
                            } else {
                                diz.setNo_conv("1");
                                if (0 == groupRuleChangeNotice) {
                                    diz.setShow_userIds("-1");
                                    diz.setNo_conv("1");
                                    diz.setNo_db("1");
                                } else if (1 == groupRuleChangeNotice) {
                                    show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                                    diz.setShow_userIds("-1");
                                    diz.setTo_users(show_userIds);
                                } else if (2 == groupRuleChangeNotice) {
                                    diz.setShow_userIds("-1");
                                }
                            }
                        } else {
                            int groupKickOutNotice = JiveGlobals.getIntProperty((String)"groupKickOutNotice", (int)1);
                            if (GroupNoticeUtil.checkGroupJudgtActiveDay((String)grouptemp.getName())) {
                                if (0 == groupKickOutNotice) {
                                    diz.setShow_userIds("-1");
                                    diz.setNo_conv("1");
                                    diz.setNo_db("1");
                                } else if (1 == groupKickOutNotice) {
                                    show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                                    diz.setShow_userIds(show_userIds);
                                    diz.setTo_users(show_userIds);
                                } else if (2 == groupKickOutNotice) {
                                    diz.setShow_userIds("0");
                                }
                            } else {
                                diz.setNo_conv("1");
                                if (0 == groupKickOutNotice) {
                                    diz.setShow_userIds("-1");
                                    diz.setNo_conv("1");
                                } else if (1 == groupKickOutNotice) {
                                    show_userIds = GroupNoticeUtil.getAdminAndManagerIds((String)grouptemp.getName());
                                    diz.setShow_userIds("-1");
                                    diz.setTo_users(show_userIds);
                                } else if (2 == groupKickOutNotice) {
                                    diz.setShow_userIds("0");
                                    diz.setShow_userIds("-1");
                                }
                            }
                        }
                        diz.setContent(finalContent);
                        infoMessage.setBody(diz.toString());
                        Log.info("deleteGroupUsers,infoMessage:{}", (Object)infoMessage.toString());
                        GroupPlugin.groupPlugin.sendMessage(infoMessage);
                        for (JID userJID : userlisttemp) {
                            Message newMessage = infoMessage.createCopy();
                            newMessage.setTo(userJID);
                            newMessage.setFrom(new JID("admin", "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), grouptemp.getName(), true));
                            GroupPlugin.groupPlugin.sendMessage(newMessage);
                        }
                    }
                });
            }
        }
        catch (GroupNotFoundException e) {
            Log.error("deleteGroupUsers,group {} not fount.", (Object)groupId);
        }
    }

    public void addGroupUsers(String operater, String groupName, List<String> users, String content, String shareCoder, boolean needMsg, List<String> members, String groupType) {
        try {
            final Group group = this.groupManager.getGroup(groupName);
            User user = null;
            String extension = "";
            String failedExtension = "";
            String operaName = "";
            String userNames = "";
            String groupAdmin = null;
            HashMap<String, Boolean> userMap = new HashMap<String, Boolean>();
            for (String username : users) {
                try {
                    user = this.userManager.getUser(username);
                    userNames = userNames + UsernameUtil.getUserName(operater, user.getName()) + ",";
                    if (user == null) continue;
                    Collection groupMembers = group.getMembers();
                    Collection groupAdmins = group.getAdmins();
                    for (JID jid : groupAdmins) {
                        groupAdmin = jid.getNode();
                    }
                    JID jid = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    if (groupMembers == null || groupMembers.contains(jid) || groupAdmins.contains(jid)) continue;
                    groupMembers.add(jid);
                    extension = extension + user.getUID() + ",";
                    boolean needDelete = members.add(username);
                    userMap.put(username, needDelete);
                }
                catch (UserNotFoundException e) {
                    JID jid = new JID(username, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    group.getMembers().add(jid);
                    boolean needDelete = members.add(username);
                    userMap.put(username, needDelete);
                }
            }
            try {
                if (operater != null && !operater.isEmpty()) {
                    user = this.userManager.getUser(operater);
                    operaName = UsernameUtil.getUserName(operater, user.getName());
                }
            }
            catch (UserNotFoundException e) {
                Log.error("addGroupUsers,user is {} not found.", (Object)operater);
                return;
            }
            if ("".equals(extension)) {
                Log.info("addGroupUsers.User not found.or User is already group user.groupName:{},users:{}", (Object)groupName, users);
                return;
            }
            if (extension.endsWith(",")) {
                extension = extension.substring(0, extension.length() - 1);
            }
            if (failedExtension.endsWith(",")) {
                failedExtension = failedExtension.substring(0, failedExtension.length() - 1);
            }
            if (content == null || content.isEmpty()) {
                if (shareCoder != null && !shareCoder.isEmpty()) {
                    String shareUserName = "";
                    String operaUserName = "";
                    try {
                        User shareCoderUser = this.userManager.getUser(shareCoder);
                        shareUserName = UsernameUtil.getUserName(operater, shareCoderUser.getName());
                        User opearUser = this.userManager.getUser(users.get(0));
                        operaUserName = opearUser.getName();
                    }
                    catch (UserNotFoundException e) {
                        Log.error("shareCoder is not a user.shareCoder:{}", (Object)shareCoder);
                    }
                    String tongguo = LocaleUtils.getLocalizedString((String)"group.iq.tongguo", (String)"group");
                    String shareCoderGroup = LocaleUtils.getLocalizedString((String)"group.iq.shareCoder", (String)"group");
                    content = operaUserName + tongguo + shareUserName + shareCoderGroup;
                } else {
                    if (userNames.endsWith(",")) {
                        userNames = userNames.substring(0, userNames.length() - 1);
                    }
                    if ("0".equals(groupType)) {
                        String invite = LocaleUtils.getLocalizedString((String)"group.iq.invite", (String)"group");
                        String invitePerson = LocaleUtils.getLocalizedString((String)"group.iq.invite.person", (String)"group");
                        String invitePersons = LocaleUtils.getLocalizedString((String)"group.iq.invite.persons", (String)"group");
                        content = users.size() > 10 ? operaName + invite + users.size() + invitePersons : operaName + invite + userNames + invitePerson;
                    } else {
                        String welcome = LocaleUtils.getLocalizedString((String)"group.iq.welcome", (String)"group");
                        String joinGroup = LocaleUtils.getLocalizedString((String)"group.iq.joinGroup", (String)"group");
                        String joinGroupPerson = LocaleUtils.getLocalizedString((String)"group.iq.joinPersonGroup", (String)"group");
                        if (userNames.endsWith(",")) {
                            userNames = userNames.substring(0, userNames.length() - 1);
                        }
                        content = users.size() > 10 ? welcome + users.size() + joinGroupPerson : welcome + userNames + joinGroup;
                    }
                }
            }
            PersistableMap groupProp = group.getProperties();
            int seeHisotryMsg = 0;
            if (groupProp != null && groupProp.containsKey((Object)"seeHistoryMsg")) {
                seeHisotryMsg = Integer.parseInt((String)groupProp.get((Object)"seeHistoryMsg"));
            }
            if (seeHisotryMsg != 0) {
                GroupDatabaseUtil gdb = new GroupDatabaseUtil();
                gdb.seeHistoryMsg(groupName, userMap, seeHisotryMsg, operater, groupAdmin);
            }
            if (needMsg || !"0".equals(groupType)) {
                final String extensionFinal = extension;
                final String failedExtensionFinal = failedExtension;
                final User userFinal = user;
                final String finalContent = content;
                final String sharecoder = shareCoder;
                final String groupTypeFinal = groupType;
                ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        Message infoMessage = new Message();
                        infoMessage.setID(StringUtils.randomString((int)8));
                        infoMessage.setType(Message.Type.chat);
                        infoMessage.setFrom(new JID(userFinal.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                        infoMessage.setTo(new JID(group.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                        DizMessage diz = null;
                        diz = new DizMessage(1, userFinal.getUID(), extensionFinal, failedExtensionFinal);
                        if (sharecoder != null && !sharecoder.isEmpty()) {
                            diz = new DizMessage(12, sharecoder, extensionFinal, failedExtensionFinal);
                        }
                        if (!"0".equals(groupTypeFinal)) {
                            diz = new DizMessage(17, userFinal.getUID(), extensionFinal, failedExtensionFinal);
                        }
                        diz.setContent(finalContent);
                        infoMessage.setBody(diz.toString());
                        Log.info("GroupOpUtil addGroupUsers,infoMessage:{}", (Object)infoMessage.toString());
                        GroupPlugin.groupPlugin.sendMessage(infoMessage);
                    }
                });
            }
        }
        catch (GroupNotFoundException e) {
            Log.error("GroupOpUtil addGroupUsers,group {} not found.", (Object)groupName);
        }
    }

    public Group createGroup(String groupName, String description, List<String> users, List<String> admins, String groupIconUrl, String groupIconType, String groupIconUserIds, String content, boolean needSendMsg, List<String> members, String seeHistoryMsg, String isDRCodeAddGroupUser, String isCommonMembersAddGroupUser, String groupType, String maxGroupMember) {
        try {
            Group group = this.groupManager.createGroup(groupName, description);
            User user = null;
            String extension = "";
            String failedExtension = "";
            String userNames = "";
            String operaName = "";
            HashSet<JID> mems = new HashSet<JID>();
            UsernameUtil usernameUtil = new UsernameUtil();
            for (String string : users) {
                try {
                    user = this.userManager.getUser(string);
                    userNames = userNames + UsernameUtil.getUserName(string, user.getName()) + ",";
                    if (user == null) continue;
                    mems.add(new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    members.add(string);
                    extension = extension + user.getUID() + ",";
                }
                catch (UserNotFoundException e) {
                    JID jid = new JID(string, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    mems.add(jid);
                    members.add(string);
                }
            }
            group.getMembers().addAll(mems);
            if ("0".equals(groupType)) {
                for (String string : admins) {
                    try {
                        user = this.userManager.getUser(string);
                        operaName = UsernameUtil.getUserName(string, user.getName());
                        if (user == null) continue;
                        group.getAdmins().add(new JID(string, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                        members.add(string);
                        extension.replaceAll(string + ",", "");
                    }
                    catch (UserNotFoundException e) {
                        Log.error("createGroup,user {} not found.", (Object)string);
                    }
                }
            } else {
                for (String string : admins) {
                    try {
                        user = this.userManager.getUser(string);
                        operaName = UsernameUtil.getUserName(string, user.getName());
                        if (user == null) continue;
                        group.getMembers().add(new JID(string, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                        members.add(string);
                        extension.replaceAll(string + ",", "");
                    }
                    catch (UserNotFoundException e) {
                        Log.error("createGroup,user {} not found.", (Object)string);
                    }
                }
            }
            PersistableMap groupPropMap = group.getProperties();
            if ("0".equals(groupType)) {
                for (String admin : admins) {
                    groupPropMap.put((Object)"createUser", (Object)admin);
                }
            }
            groupPropMap.put((Object)"createtime", (Object)String.valueOf(System.currentTimeMillis()));
            if (groupIconUrl != null) {
                groupPropMap.put((Object)"groupIconUrl", (Object)groupIconUrl);
            }
            groupPropMap.put((Object)"groupIconType", (Object)groupIconType);
            if (groupIconUserIds != null && !groupIconUserIds.isEmpty()) {
                groupPropMap.put((Object)"groupIconUserIds", (Object)groupIconUserIds);
            }
            if (seeHistoryMsg != null && !seeHistoryMsg.isEmpty()) {
                groupPropMap.put((Object)"seeHistoryMsg", (Object)seeHistoryMsg);
            }
            groupPropMap.put((Object)"isDRCodeAddGroupUser", (Object)isDRCodeAddGroupUser);
            groupPropMap.put((Object)"isCommonMembersAddGroupUser", (Object)isCommonMembersAddGroupUser);
            groupPropMap.put((Object)"groupType", (Object)groupType);
            groupPropMap.put((Object)"maxGroupMember", (Object)maxGroupMember);
            if (extension.endsWith(",")) {
                extension = extension.substring(0, extension.length() - 1);
            }
            if (content == null || content.isEmpty()) {
                if ("0".equals(groupType)) {
                    String string = LocaleUtils.getLocalizedString((String)"group.iq.invite", (String)"group");
                    String invitePerson = LocaleUtils.getLocalizedString((String)"group.iq.invite.person", (String)"group");
                    String invitePersons = LocaleUtils.getLocalizedString((String)"group.iq.invite.persons", (String)"group");
                    if (userNames.endsWith(",")) {
                        userNames = userNames.substring(0, userNames.length() - 1);
                    }
                    content = users.size() > 10 ? operaName + string + users.size() + invitePersons : operaName + string + userNames + invitePerson;
                } else {
                    String string = LocaleUtils.getLocalizedString((String)"group.iq.welcome", (String)"group");
                    String joinGroup = LocaleUtils.getLocalizedString((String)"group.iq.joinGroup", (String)"group");
                    String joinGroupPerson = LocaleUtils.getLocalizedString((String)"group.iq.joinPersonGroup", (String)"group");
                    if (userNames.endsWith(",")) {
                        userNames = userNames.substring(0, userNames.length() - 1);
                    }
                    content = users.size() > 10 ? string + users.size() + joinGroupPerson : string + userNames + joinGroup;
                }
            }
            if (failedExtension.endsWith(",")) {
                failedExtension = failedExtension.substring(0, failedExtension.length() - 1);
            }
            if (needSendMsg) {
                final User user2 = user;
                final String extensiontemp = extension;
                final String failedExtensionFinal = failedExtension;
                final Group grouptemp = group;
                final String finalContent = content;
                final String groupTypeFinal = groupType;
                ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        Message infoMessage = new Message();
                        infoMessage.setID(StringUtils.randomString((int)8));
                        infoMessage.setType(Message.Type.chat);
                        infoMessage.setFrom(new JID(user2.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                        infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                        DizMessage diz = null;
                        diz = "0".equals(groupTypeFinal) ? new DizMessage(1, user2.getUID(), extensiontemp, failedExtensionFinal) : new DizMessage(17, user2.getUID(), extensiontemp, failedExtensionFinal);
                        diz.setContent(finalContent);
                        infoMessage.setBody(diz.toString());
                        Log.info("GroupOpUtil createGroup,infoMessage:{}", (Object)infoMessage.toString());
                        GroupPlugin.groupPlugin.sendMessage(infoMessage);
                    }
                });
            }
            return group;
        }
        catch (GroupAlreadyExistsException e) {
            Log.error("GroupOpUtil createGroup,group is exist:{}", (Object)groupName);
            return null;
        }
    }

    public static List<String> getListByStr(String str) {
        if (str != null) {
            String[] strs = str.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (String s : strs) {
                if (s == null || s.isEmpty()) continue;
                list.add(s);
            }
            return list;
        }
        return new ArrayList<String>();
    }

    public void addGroupUsersByShare(String operater, String groupName, String username) {
        try {
            final Group group = this.groupManager.getGroup(groupName);
            Collection groupAllMembers = group.getAll();
            User user = null;
            String extension = "";
            String failedExtension = "";
            String operaName = "";
            String userNames = "";
            String groupAdmin = null;
            HashMap<String, Boolean> userMap = new HashMap<String, Boolean>();
            try {
                user = this.userManager.getUser(username);
                userNames = UsernameUtil.getUserName(operater, user.getName());
                if (user != null) {
                    Collection groupMembers = group.getMembers();
                    Collection groupAdmins = group.getAdmins();
                    for (JID jid : groupAdmins) {
                        groupAdmin = jid.getNode();
                    }
                    JID jid = new JID(user.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true);
                    if (groupMembers != null && !groupMembers.contains(jid) && !groupAdmins.contains(jid)) {
                        boolean needDelete = groupMembers.add(jid);
                        userMap.put(username, needDelete);
                    }
                }
            }
            catch (UserNotFoundException e) {
                Log.error("addGroupUsersByShare,username is {} not found.", (Object)username);
            }
            try {
                user = this.userManager.getUser(operater);
                operaName = UsernameUtil.getUserName(operater, user.getName());
            }
            catch (UserNotFoundException e) {
                Log.error("addGroupUsers,user is {} not found.", (Object)operater);
                return;
            }
            String content = null;
            String tongguo = LocaleUtils.getLocalizedString((String)"group.iq.tongguo", (String)"group");
            String shareCoderGroup = LocaleUtils.getLocalizedString((String)"group.iq.shareCoder", (String)"group");
            content = userNames + tongguo + operaName + shareCoderGroup;
            PersistableMap groupProp = group.getProperties();
            int seeHisotryMsg = 0;
            if (groupProp != null && groupProp.containsKey((Object)"seeHistoryMsg")) {
                seeHisotryMsg = Integer.parseInt((String)groupProp.get((Object)"seeHistoryMsg"));
            }
            if (seeHisotryMsg != 0) {
                GroupDatabaseUtil gdb = new GroupDatabaseUtil();
                gdb.seeHistoryMsg(groupName, userMap, seeHisotryMsg, operater, groupAdmin);
            }
            final String extensionFinal = username;
            final String failedExtensionFinal = failedExtension;
            final User userFinal = user;
            final String finalContent = content;
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(userFinal.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(group.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(16, userFinal.getUID(), extensionFinal, failedExtensionFinal);
                    diz.setContent(finalContent);
                    infoMessage.setBody(diz.toString());
                    Log.info("GroupOpUtil addGroupUsersByShare,infoMessage:{}", (Object)infoMessage.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
        }
        catch (GroupNotFoundException e) {
            Log.error("GroupOpUtil addGroupUsers,group {} not found.", (Object)groupName);
        }
    }

    public void createGroup(String groupName, String description, List<String> admins, String groupIconUrl, String groupIconType, String groupIconUserIds, String seeHistoryMsg, String isDisableWords, String isDisableMsgRead, String isDRCodeAddGroupUser, String isCommonMembersAddGroupUser, String maxGroupMember, String secretGroupType) {
        GroupManager groupManager = GroupManager.getInstance();
        User user = null;
        String userName = null;
        try {
            Group group = groupManager.createGroup(groupName, description);
            for (String string : admins) {
                try {
                    user = this.userManager.getUser(string);
                    userName = UsernameUtil.getUserName(string, user.getName());
                    if (user == null) continue;
                    group.getAdmins().add(new JID(string, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                }
                catch (UserNotFoundException e) {
                    Log.error("createGroup,user {} not found.", (Object)string);
                }
            }
            PersistableMap groupPropMap = group.getProperties();
            for (String admin : admins) {
                groupPropMap.put((Object)"createUser", (Object)admin);
            }
            groupPropMap.put((Object)"createtime", (Object)String.valueOf(System.currentTimeMillis()));
            if (groupIconUrl != null) {
                groupPropMap.put((Object)"groupIconUrl", (Object)groupIconUrl);
            }
            groupPropMap.put((Object)"groupIconType", (Object)groupIconType);
            groupPropMap.put((Object)"seeHistoryMsg", (Object)seeHistoryMsg);
            if (groupIconUserIds != null && !groupIconUserIds.isEmpty()) {
                groupPropMap.put((Object)"groupIconUserIds", (Object)groupIconUserIds);
            }
            groupPropMap.put((Object)"isDisableWords", (Object)isDisableWords);
            groupPropMap.put((Object)"isDisableMsgRead", (Object)isDisableMsgRead);
            groupPropMap.put((Object)"isDRCodeAddGroupUser", (Object)isDRCodeAddGroupUser);
            groupPropMap.put((Object)"isCommonMembersAddGroupUser", (Object)isCommonMembersAddGroupUser);
            groupPropMap.put((Object)"maxGroupMember", (Object)maxGroupMember);
            groupPropMap.put((Object)"secretGroupType", (Object)secretGroupType);
            final User user2 = user;
            String extensiontemp = "";
            String failedExtensionFinal = "";
            final Group grouptemp = group;
            final String finalContent = userName + "\u521b\u5efa\u4e86\u7fa4\u7ec4";
            ThreadPoolFactory.getFixedThreadPoolImpl().getFixedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    Message infoMessage = new Message();
                    infoMessage.setID(StringUtils.randomString((int)8));
                    infoMessage.setType(Message.Type.chat);
                    infoMessage.setFrom(new JID(user2.getUID(), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
                    infoMessage.setTo(new JID(grouptemp.getName(), "group." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), "all", true));
                    DizMessage diz = new DizMessage(1, user2.getUID(), "", "");
                    diz.setContent(finalContent);
                    infoMessage.setBody(diz.toString());
                    Log.info("createGroup,infoMessage:{}", (Object)infoMessage.toString());
                    GroupPlugin.groupPlugin.sendMessage(infoMessage);
                }
            });
        }
        catch (GroupAlreadyExistsException e) {
            e.printStackTrace();
        }
    }
}

