/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import java.util.List;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.plugin.GroupPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class ProcessGroupMessageThread
extends Thread {
    private Message message;
    private List<JID> userList;
    private JID from;
    private Group group;
    private static final Logger Log = LoggerFactory.getLogger(ProcessGroupMessageThread.class);

    public ProcessGroupMessageThread(Message message, List<JID> userList, JID from, Group group) {
        this.message = message;
        this.userList = userList;
        this.from = from;
        this.group = group;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        for (JID jid : this.userList) {
            JID userJid = new JID(jid.getNode().toLowerCase(), this.from.getDomain(), null, true);
            Message msg = this.message.createCopy();
            msg.setTo(userJid);
            msg.setFrom(new JID(this.from.getNode(), "group." + this.from.getDomain(), this.group.getName(), true));
            GroupPlugin.groupPlugin.sendMessage(msg);
        }
        long endTime = System.currentTimeMillis();
        Log.info("done propcessGroup groupId:{},groupMemberSizes:{},cost:{} ms", new Object[]{this.group.getName(), this.userList.size(), endTime - startTime});
    }
}

