/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class SearchGroupDataBaseUtil {
    private static final Logger Log = LoggerFactory.getLogger(SearchGroupDataBaseUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> searchGroupMessage(String username, String queryGroupName, String groupType, Integer pageSize, Integer pageNumber, String groupAdmin, Long createTimeStart, Long createTimeEnd, String createUser, String tagValue, boolean needSearchGroupMemberName, List<String> group_members, String groupPropType, String groupId, String isTop, String dissolution, String del_status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] sqlS = this.getSearchGroupSQLs(username, queryGroupName, groupType, groupAdmin, createTimeStart, createTimeEnd, createUser, tagValue, needSearchGroupMemberName, group_members, groupPropType, groupId, isTop, dissolution, del_status);
        String totalCountSql = sqlS[0];
        Log.info("searchGroupMessage totalCountSql:{}", (Object)totalCountSql);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(totalCountSql);
            int i = 0;
            if (groupId != null && !groupId.isEmpty()) {
                pstmt.setString(++i, groupId);
            }
            if (queryGroupName != null && !queryGroupName.isEmpty()) {
                if (needSearchGroupMemberName) {
                    pstmt.setString(++i, "%" + queryGroupName + "%");
                    pstmt.setString(++i, "%" + queryGroupName + "%");
                    pstmt.setString(++i, queryGroupName);
                } else {
                    pstmt.setString(++i, "%" + queryGroupName + "%");
                }
            }
            if (groupAdmin != null && !groupAdmin.isEmpty()) {
                pstmt.setString(++i, groupAdmin);
            }
            if (createUser != null && !createUser.isEmpty()) {
                pstmt.setString(++i, createUser);
            }
            if (createTimeStart != null && createTimeStart > 0L) {
                pstmt.setString(++i, String.valueOf(createTimeStart));
            }
            if (createTimeEnd != null && createTimeEnd > 0L) {
                pstmt.setString(++i, String.valueOf(createTimeEnd));
            }
            if (tagValue != null && !tagValue.isEmpty()) {
                pstmt.setString(++i, tagValue);
            }
            if (group_members != null && group_members.size() > 0) {
                pstmt.setInt(++i, group_members.size());
                for (String uName : group_members) {
                    pstmt.setString(++i, uName);
                }
            }
            if (groupPropType != null && !groupPropType.isEmpty()) {
                pstmt.setString(++i, groupPropType);
            }
            if (isTop != null && !isTop.isEmpty()) {
                pstmt.setString(++i, isTop);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                result.put("totalCount", rs.getInt("totalCount"));
            }
            DbConnectionManager.closeStatement((ResultSet)rs, (Statement)pstmt);
            String sql = sqlS[1];
            String sqlByPage = "";
            if (DbConnectionManager.DatabaseType.sqlserver.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = "select * FROM( SELECT ROW_NUMBER () OVER (ORDER BY createTime DESC) AS rn,* FROM (" + sql + ") AS pageTable ) AS pageTableRn WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs)) {
                sqlByPage = "SELECT * FROM (SELECT rownum as rn, pageTable.* FROM (" + sql + " order by createTime DESC )pageTable) WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize;
            } else if (DbConnectionManager.DatabaseType.mysql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " order by createTime DESC  LIMIT " + (pageNumber - 1) * pageSize + "," + pageSize;
            } else if (DbConnectionManager.DatabaseType.postgresql.equals((Object)DbConnectionManager.getDatabaseType())) {
                sqlByPage = sql + " order by createTime DESC  LIMIT " + pageSize + " offset " + (pageNumber - 1) * pageSize;
            }
            Log.info("searchGroupMessage sqlByPage:{}", (Object)sqlByPage);
            pstmt = con.prepareStatement(sqlByPage);
            int j = 0;
            if (groupId != null && !groupId.isEmpty()) {
                pstmt.setString(++j, groupId);
            }
            if (queryGroupName != null && !queryGroupName.isEmpty()) {
                if (needSearchGroupMemberName) {
                    pstmt.setString(++j, "%" + queryGroupName + "%");
                    pstmt.setString(++j, "%" + queryGroupName + "%");
                    pstmt.setString(++j, queryGroupName);
                } else {
                    pstmt.setString(++j, "%" + queryGroupName + "%");
                }
            }
            if (groupAdmin != null && !groupAdmin.isEmpty()) {
                pstmt.setString(++j, groupAdmin);
            }
            if (createUser != null && !createUser.isEmpty()) {
                pstmt.setString(++j, createUser);
            }
            if (createTimeStart != null && createTimeStart > 0L) {
                pstmt.setLong(++j, createTimeStart);
            }
            if (createTimeEnd != null && createTimeEnd > 0L) {
                pstmt.setLong(++j, createTimeEnd);
            }
            if (tagValue != null && !tagValue.isEmpty()) {
                pstmt.setString(++j, tagValue);
            }
            if (group_members != null && group_members.size() > 0) {
                pstmt.setInt(++j, group_members.size());
                for (String uName : group_members) {
                    pstmt.setString(++j, uName);
                }
            }
            if (groupPropType != null && !groupPropType.isEmpty()) {
                pstmt.setString(++j, groupPropType);
            }
            if (isTop != null && !isTop.isEmpty()) {
                pstmt.setString(++j, isTop);
            }
            ArrayList groups = new ArrayList();
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, CharSequence> group = new HashMap<String, CharSequence>();
                group.put("groupName", StringUtils.defaultIfEmpty((CharSequence)rs.getString("description"), (CharSequence)""));
                group.put("groupId", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupName"), (CharSequence)""));
                group.put("groupMemberSize", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupUserCount"), (CharSequence)""));
                group.put("msgContent", "");
                group.put("lasttime", "");
                group.put("groupIconUrl", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupIcon"), (CharSequence)""));
                group.put("createUser", StringUtils.defaultIfEmpty((CharSequence)rs.getString("createUser"), (CharSequence)""));
                group.put("createtime", StringUtils.defaultIfEmpty((CharSequence)rs.getString("createtime"), (CharSequence)""));
                group.put("groupType", StringUtils.defaultIfEmpty((CharSequence)rs.getString("groupType"), (CharSequence)"0"));
                group.put("isTop", StringUtils.defaultIfEmpty((CharSequence)rs.getString("isTop"), (CharSequence)"0"));
                group.put("dissolution_time", StringUtils.defaultIfEmpty((CharSequence)rs.getString("dissolution_time"), (CharSequence)""));
                String del_status1 = rs.getString("deleteGroup");
                if ("true".equals(del_status1)) {
                    group.put("del_status", "1");
                } else {
                    group.put("del_status", "0");
                }
                Map<String, String> resultMembers = this.getGroupMemberInfo(rs.getString("groupName"));
                if (resultMembers != null) {
                    group.put("member_leader", resultMembers.get("group_owner"));
                    group.put("group_member", resultMembers.get("group_member_ids"));
                }
                groups.add(group);
            }
            result.put("allGroups", groups);
            result.put("pageNumber", pageNumber);
            result.put("pageSize", pageSize);
        }
        catch (SQLException e) {
            try {
                Log.error("searchGroupMessage ,error:{},username:{},queryGroupName:{}, groupType:{}, groupAdmin:{}, createTimeStart:{},createTimeEnd:{}, createUser:{}, tagValue:{}, needSearchGroupMemberName:{}, group_members:{}, groupPropType:{}", new Object[]{e.getMessage(), username, queryGroupName, groupType, groupAdmin, createTimeStart, createTimeEnd, createUser, tagValue, needSearchGroupMemberName, group_members, groupPropType});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        Log.info("searchGroupMessage ,result:{},username:{},queryGroupName:{}, groupType:{}, groupAdmin:{}, createTimeStart:{},createTimeEnd:{}, createUser:{}, tagValue:{}, needSearchGroupMemberName:{}, group_members:{}, groupPropType:{}", new Object[]{JSON.toJSONString(result), username, queryGroupName, groupType, groupAdmin, createTimeStart, createTimeEnd, createUser, tagValue, needSearchGroupMemberName, group_members, groupPropType});
        return result;
    }

    private Map<String, String> getGroupMemberInfo(String groupName) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Group group = null;
        try {
            group = GroupManager.getInstance().getGroup(groupName);
        }
        catch (GroupNotFoundException e) {
            return resultMap;
        }
        Collection allMembers = group.getAll();
        ArrayList<String> listGroupMember = new ArrayList<String>();
        Iterator iterator = allMembers.iterator();
        String strJid = "";
        while (iterator.hasNext()) {
            String[] arrayJid;
            JID jid = (JID)iterator.next();
            strJid = jid.getNode();
            if (!StringUtils.isNotBlank((CharSequence)strJid) || null == (arrayJid = strJid.split("\\|")) || arrayJid.length <= 0) continue;
            listGroupMember.add(arrayJid[0]);
        }
        Collection allAdmins = group.getAdmins();
        String group_owner = "";
        for (JID jid : allAdmins) {
            String[] arrayJid = jid.getNode().split("\\|");
            if (null == arrayJid || arrayJid.length <= 0) continue;
            group_owner = arrayJid[0];
        }
        ArrayList<String> listGroupManager = new ArrayList<String>();
        PersistableMap groupManager = group.getProperties();
        if (groupManager != null && groupManager.containsKey((Object)"groupManagers")) {
            String groupManagers = (String)groupManager.get((Object)"groupManagers");
            JSONArray groupManagerArray = JSON.parseArray((String)groupManagers);
            if (groupManagerArray == null) {
                groupManagerArray = new JSONArray();
            }
            for (int i = 0; i < groupManagerArray.size(); ++i) {
                String manager = groupManagerArray.getString(i).toLowerCase();
                listGroupManager.add(this.getUserIDByUsername(manager));
            }
        }
        if (listGroupManager == null || listGroupManager.size() == 0 || listGroupManager.isEmpty()) {
            resultMap.put("group_admin_ids", "");
        } else {
            resultMap.put("group_admin_ids", StringUtils.join((Object[])listGroupManager.toArray(), (String)","));
        }
        resultMap.put("group_owner", group_owner);
        resultMap.put("group_member_ids", StringUtils.join((Object[])listGroupMember.toArray(), (String)","));
        return resultMap;
    }

    public String[] getSearchGroupSQLs(String username, String queryGroupName, String groupType, String groupAdmin, Long createTimeStart, Long createTimeEnd, String createUser, String tagValue, boolean needSearchGroupMemberName, List<String> group_members, String groupPropType, String groupId, String isTop, String dissolution, String del_status) {
        String sqlBack = "SELECT g.createTime,g.groupName,description,g.groupType as groupType,g.deleteGroup,g.createUser as createUser,g.groupIconUrl AS groupIcon,g.isTop AS isTop,g.dissolution_time, (SELECT COUNT(1) AS userCount FROM ofGroupUser WHERE groupName = g.groupName and (ofGroupUser.isdel is null or ofGroupUser.isdel <> '1')) AS groupUserCount ";
        String sqlFrom = " ofGroup g  ";
        String sqlWhere = "";
        sqlWhere = DbConnectionManager.DatabaseType.oracle.equals((Object)DbConnectionManager.getDatabaseType()) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.dm) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.st) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.jc) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.ob) || DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.gs) ? sqlWhere + " g.description is not null and (g.secretGroupType <> '1' or g.secretGroupType is null) " : sqlWhere + " (g.description is not null and g.description <> '') and (g.secretGroupType <> '1' or g.secretGroupType is null) ";
        if (groupId != null && !groupId.isEmpty()) {
            sqlWhere = sqlWhere + " and g.groupName = ?  ";
        }
        if (!"1".equals(dissolution)) {
            sqlWhere = sqlWhere + "  and (g.deleteGroup <> 'true' or g.deleteGroup is null)  ";
        }
        if ("1".equals(del_status)) {
            sqlWhere = sqlWhere + " and g.deleteGroup = 'true' ";
        } else if ("0".equals(del_status)) {
            sqlWhere = sqlWhere + "  and (g.deleteGroup <> 'true' or g.deleteGroup is null)  ";
        }
        if (queryGroupName != null && !queryGroupName.isEmpty()) {
            sqlWhere = needSearchGroupMemberName && username != null && !username.isEmpty() ? sqlWhere + " and (g.description like ?  or EXISTS (select 1 from ofgroupuser left join ofuser on ofuser.username = ofgroupuser.username where ofgroupuser.groupname = g.groupName and ofuser.name like ? )  or EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and tagValue = ? ) ) " : sqlWhere + " and g.description like ? ";
        }
        if (groupAdmin != null && !groupAdmin.isEmpty()) {
            sqlWhere = sqlWhere + " and EXISTS (select 1 from ofGroupUser where groupName = g.groupName and administrator = 1 and username = ?) ";
        }
        if (createUser != null && !createUser.isEmpty()) {
            sqlWhere = sqlWhere + " and g.createUser = ?  ";
        }
        if (createTimeStart != null && createTimeStart > 0L || createTimeEnd != null && createTimeEnd > 0L) {
            if (createTimeStart != null && createTimeStart > 0L) {
                sqlWhere = sqlWhere + " and g.createTime >= ? ";
            }
            if (createTimeEnd != null && createTimeEnd > 0L) {
                sqlWhere = sqlWhere + " and g.createTime <= ? ";
            }
        }
        if (tagValue != null && !tagValue.isEmpty() && username != null && !username.isEmpty()) {
            sqlWhere = sqlWhere + " and EXISTS (select 1 from ofgrouptag where groupName = g.groupName and username = a.username and tagValue = ?) ";
        }
        if (group_members != null && group_members.size() > 0) {
            sqlWhere = sqlWhere + " and (select count(1) as userCount from ofGroupUser where groupName = g.groupName ) =  ? ";
            for (String uName : group_members) {
                sqlWhere = sqlWhere + " and EXISTS (select 1 from ofGroupUser where groupName = g.groupName and username = ? )";
            }
        }
        if (groupPropType != null && !groupPropType.isEmpty()) {
            sqlWhere = !"0".equals(groupPropType) ? sqlWhere + " and g.groupType = ? " : sqlWhere + " and (g.groupType = ? OR g.groupType is NULL) ";
        }
        if (isTop != null && !isTop.isEmpty()) {
            sqlWhere = !"0".equals(isTop) ? sqlWhere + " and g.isTop = ? " : sqlWhere + " and (g.isTop = ? OR g.isTop is NULL) ";
        }
        String totalSql = " select count(1) AS totalCount from ( " + sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere + ") pageCount ";
        String sql = sqlBack + " FROM " + sqlFrom + " WHERE " + sqlWhere;
        return new String[]{totalSql, sql};
    }

    private String getUserIDByUsername(String username) {
        if (username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }
}

