/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util;

import com.alibaba.fastjson.JSONObject;
import com.weaver.cache.redis.RedisPoolMgr;
import com.weaver.util.WeiSouPropertiesUtil;
import com.weaver.util.subtable.historymsg.MsgIndexUpdateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import weaver.fullsearch.interfaces.service.MegSearch;

public class SeeHistoryMsgUtil {
    private static final Logger Log = LoggerFactory.getLogger(SeeHistoryMsgUtil.class);

    public static void seeHistoryMsg(int seeHistoryMsg, String groupId, String groupAdminId, String opeartorId, Map<String, Boolean> users) {
        long startTime = System.currentTimeMillis();
        String userId = SeeHistoryMsgUtil.getUserIDByUsername(groupAdminId);
        if (userId == null || userId.isEmpty()) {
            userId = SeeHistoryMsgUtil.getUserIDByUsername(opeartorId);
        }
        if (userId == null || userId.isEmpty()) {
            userId = SeeHistoryMsgUtil.getGroupLastMember(groupId);
        }
        if (userId == null || userId.isEmpty()) {
            Log.warn("seeHistoryMsg,can not get UserId ,seeHistoryMsg :{} ,groupId :{} ,groupAdminId :{} ,opeartorId :{} ", new Object[]{seeHistoryMsg, groupId, groupAdminId, opeartorId});
            return;
        }
        SeeHistoryMsgUtil.saveHistoryMsg(seeHistoryMsg, groupId, userId, users);
        Log.info("seeHistoryMsg,groupId:{},seeHistoryMsg:{},groupAdminId:{},operatorId :{},users :{} ,cost :{} ms", new Object[]{groupId, seeHistoryMsg, groupAdminId, opeartorId, users, System.currentTimeMillis() - startTime});
    }

    private static void saveHistoryMsg(int pageSize, String groupId, String userId, Map<String, Boolean> users) {
        RedisPoolMgr redisPoolMgr = RedisPoolMgr.getInstance();
        ArrayList historyMsgRedisKeySet = new ArrayList(redisPoolMgr.zrange(SeeHistoryMsgUtil.getConversationIDKey(groupId, userId), 0L, -1L));
        if (historyMsgRedisKeySet != null && historyMsgRedisKeySet.contains("history:msg:0")) {
            historyMsgRedisKeySet.remove("history:msg:0");
        }
        List msgObj = null;
        if (historyMsgRedisKeySet != null && historyMsgRedisKeySet.size() > 0) {
            msgObj = redisPoolMgr.batchHgetall(historyMsgRedisKeySet);
        }
        int historyMsgRedisKeySetSize = 0;
        if (msgObj != null && msgObj.size() > 0) {
            historyMsgRedisKeySetSize = msgObj.size();
        }
        HashSet redisKeyReallyMsgId = new HashSet();
        HashMap<String, Long> redisMsgIds = new HashMap<String, Long>();
        if (msgObj != null && msgObj.size() > 0) {
            Long sendTime;
            String sendTimestr;
            String msgId;
            if (msgObj.size() < pageSize) {
                for (Map tempMap : msgObj) {
                    msgId = (String)tempMap.get("timestamp");
                    sendTimestr = (String)tempMap.get("sendTime");
                    if (msgId == null || msgId.isEmpty() || sendTimestr == null || sendTimestr.isEmpty()) continue;
                    sendTime = Long.parseLong((String)tempMap.get("sendTime"));
                    redisMsgIds.put("history:msg:" + msgId, sendTime);
                    redisKeyReallyMsgId.add(tempMap.get("timestamp"));
                }
            } else {
                for (int i = msgObj.size() - pageSize; i < msgObj.size(); ++i) {
                    Map tempMap;
                    tempMap = (Map)msgObj.get(i);
                    msgId = (String)tempMap.get("timestamp");
                    sendTimestr = (String)tempMap.get("sendTime");
                    if (msgId == null || msgId.isEmpty() || sendTimestr == null || sendTimestr.isEmpty()) continue;
                    sendTime = Long.parseLong((String)tempMap.get("sendTime"));
                    redisMsgIds.put("history:msg:" + msgId, sendTime);
                    redisKeyReallyMsgId.add(tempMap.get("timestamp"));
                }
            }
        }
        int needReadDbSize = 0;
        String msgLastTime = null;
        Log.info("seeHistoryMsg ,pageSize  :{},historyMsgRedisKeySetSize:{} ", (Object)pageSize, (Object)historyMsgRedisKeySetSize);
        if (pageSize - historyMsgRedisKeySetSize > 0) {
            needReadDbSize = pageSize - historyMsgRedisKeySetSize;
            msgLastTime = SeeHistoryMsgUtil.getLastMsgTime(msgObj);
        }
        List<Object> needRecordDbMsgIds = new ArrayList();
        Log.info("seeHistoryMsg ,needReadDbSize  :{},msgLastTime:{} ", (Object)needReadDbSize, (Object)msgLastTime);
        if (needReadDbSize > 0 && msgLastTime != null) {
            needRecordDbMsgIds = SeeHistoryMsgUtil.getDbMsgIds(userId, groupId, msgLastTime, needReadDbSize);
        }
        Log.info("seeHistoryMsg ,needReadDbSize start set redis :{},msgLastTime:{} ", (Object)needReadDbSize, (Object)msgLastTime);
        String historyMsgRightKey = "history:conv:" + groupId + ":";
        HashSet<Object> msgIds = new HashSet<Object>();
        if (redisKeyReallyMsgId != null && redisKeyReallyMsgId.size() > 0) {
            msgIds.addAll(redisKeyReallyMsgId);
        }
        if (needRecordDbMsgIds != null && needRecordDbMsgIds.size() > 0) {
            msgIds.addAll(needRecordDbMsgIds);
        }
        Log.info("seeHistoryMsg ,needReadDbSize start set db :{},msgLastTime:{} ", (Object)needReadDbSize, (Object)msgLastTime);
        for (String recordUser : users.keySet()) {
            String recordId = SeeHistoryMsgUtil.getUserIDByUsername(recordUser);
            if (redisMsgIds != null && !redisMsgIds.isEmpty()) {
                HashMap<String, HashMap<String, Long>> map = new HashMap<String, HashMap<String, Long>>();
                map.put(historyMsgRightKey + recordId, redisMsgIds);
                redisPoolMgr.batchzaddKey(map);
            }
            if (msgIds == null || msgIds.size() <= 0) continue;
            SeeHistoryMsgUtil.batchHistoryMsgRight(new ArrayList<String>(msgIds), recordId, users.get(recordUser));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void batchHistoryMsgRight(List<String> msgIds, String userId, boolean needDelete) {
        Log.info("batchHistoryMsgRight,msgIds :{} ,userId :{} ,needDelete :{} ", new Object[]{msgIds, userId, needDelete});
        Connection con = null;
        PreparedStatement pstmt = null;
        long timeMills = System.currentTimeMillis() + 300000L;
        SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String dateTime = SDF_ALL_TIME_FORMAT.format(timeMills);
        try {
            con = DbConnectionManager.getConnection();
            if (needDelete) {
                pstmt = con.prepareStatement("DELETE FROM Social_historyMsgRight WHERE msgId = ? and userId = ? ");
                for (String msgId : msgIds) {
                    pstmt.setString(1, userId);
                    pstmt.setString(2, msgId);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
                DbConnectionManager.closeStatement((Statement)pstmt);
            }
            Log.info("batchHistoryMsgRight1,msgIds :{} ,userId :{} ,needDelete :{} ", new Object[]{msgIds, userId, needDelete});
            pstmt = con.prepareStatement("INSERT INTO Social_historyMsgRight (userId, msgId, datetime) VALUES (?,?,?)");
            for (String msgId : msgIds) {
                pstmt.setString(1, userId);
                pstmt.setString(2, msgId);
                pstmt.setString(3, dateTime);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt.clearBatch();
            DbConnectionManager.closeStatement((Statement)pstmt);
            WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
            if (w.isWeiSouEnable()) {
                if (JiveGlobals.getBooleanProperty((String)"subtable.historyMsg", (boolean)false)) {
                    MsgIndexUpdateUtil msg = new MsgIndexUpdateUtil();
                    for (String msgId : msgIds) {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("userId", userId);
                        data.put("msgId", msgId);
                        msg.updateMsgIndex("6", null, JSONObject.toJSONString(data));
                    }
                } else {
                    Log.info("batchHistoryMsgRight2,msgIds :{} ,userId :{} ,needDelete :{} ", new Object[]{msgIds, userId, needDelete});
                    pstmt = con.prepareStatement(" update Historymsg set updatetime = ? where msgId = ? ");
                    for (String msgId : msgIds) {
                        pstmt.setString(1, dateTime);
                        pstmt.setString(2, msgId);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                }
            }
            Log.info("batchHistoryMsgRight3,msgIds :{} ,userId :{} ,needDelete :{} ", new Object[]{msgIds, userId, needDelete});
        }
        catch (SQLException e) {
            try {
                Log.error("batchHistoryMsgRight ,msgIds:{},userId :{} ,errMsg:{} ,e :{} ", new Object[]{msgIds, userId, e.getMessage(), e});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    private static List<String> getDbMsgIds(String userId, String groupId, String msgLastTime, int needReadDbSize) {
        List<Object> msgIdList = new ArrayList();
        WeiSouPropertiesUtil w = WeiSouPropertiesUtil.getInstance();
        boolean weiSouEnable = w.isWeiSouEnable();
        boolean msgSearchValidate = false;
        if (weiSouEnable) {
            msgSearchValidate = MegSearch.searchValidate((String)"MSGSEARCH");
        }
        if (weiSouEnable && msgSearchValidate) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("schemaType", "MSGSEARCH");
            paramMap.put("groupId", groupId);
            paramMap.put("pageNumber", 1);
            paramMap.put("pageSize", needReadDbSize);
            paramMap.put("endTime", msgLastTime);
            paramMap.put("userid", userId);
            HashMap<String, String> sortMap = new HashMap<String, String>();
            sortMap.put("Datetime", "false");
            HashMap aggMap = new HashMap();
            Map weiSouMap = MegSearch.search(paramMap, sortMap, aggMap);
            msgIdList = SeeHistoryMsgUtil.convertWeiSouToClient(weiSouMap);
        } else {
            if (weiSouEnable && !msgSearchValidate) {
                Log.info("==============SeeHistoryMsgSeach\u5fae\u641c\u5df2\u5f00\u542f\uff0c\u5fae\u641c\u7d22\u5f15\u4e0d\u53ef\u7528\u3002===================");
            }
            msgIdList = SeeHistoryMsgUtil.getMsgList(groupId, userId, msgLastTime, needReadDbSize);
        }
        return msgIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getMsgList(String groupId, String userId, String msgLastTime, int needReadDbSize) {
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            String sqlBack = " a.msgId as msgId";
            String sqlFrom = " historyMsg a,social_HistoryMsgRight b ";
            String sqlWhere = " a.msgId = b.msgId and a.groupId = ? and b.userId = ? and a.datetime < ? ";
            String sqlOrderBy = " order by a.id desc ";
            String sql = "";
            if (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.sqlserver)) {
                sql = "SELECT top(" + needReadDbSize + ") " + sqlBack + " From " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
            } else if (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.mysql)) {
                sql = "SELECT " + sqlBack + " From " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy + "limit 0," + needReadDbSize;
            } else {
                String sqlO = "SELECT " + sqlBack + " From " + sqlFrom + " WHERE " + sqlWhere + sqlOrderBy;
                sql = "select * from (select A.*, rownum rn from (" + sqlO + " ) A where rownum <= " + needReadDbSize + ") where rn >= 1 ";
            }
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, groupId);
            pstmt.setString(2, userId);
            pstmt.setString(3, msgLastTime);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String msgid = rs.getString("msgId");
                set.add(msgid);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error("getMsgList ,error :{} ,e :{} ,groupId :{} ,userId :{} ,msgLastTime :{},needReadDbSize:{} ", new Object[]{e.getMessage(), e, groupId, userId, msgLastTime, needReadDbSize});
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
        if (set != null && set.size() > 0) {
            list.addAll(set);
        }
        return list;
    }

    private static List<String> convertWeiSouToClient(Map<String, Object> weiSouMap) {
        ArrayList<String> msgIdList = new ArrayList<String>();
        List listResult = (List)weiSouMap.get("result");
        if (null != listResult) {
            for (int i = 0; i < listResult.size(); ++i) {
                Map mapWei = (Map)listResult.get(i);
                msgIdList.add((String)mapWei.get("msgId"));
            }
        }
        return msgIdList;
    }

    private static String getLastMsgTime(List<Map<String, String>> msgObj) {
        String updateTime = null;
        try {
            if (msgObj == null || msgObj.size() == 0) {
                SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                updateTime = SDF_ALL_TIME_FORMAT.format(System.currentTimeMillis() * 2L);
            } else {
                int msgObjSize = msgObj.size();
                Map<String, String> lastMsgMap = msgObj.get(msgObjSize - 1);
                String sendTime = lastMsgMap.get("sendTime");
                Long time = Long.parseLong(sendTime);
                SimpleDateFormat SDF_ALL_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                updateTime = SDF_ALL_TIME_FORMAT.format(time);
            }
        }
        catch (Exception e) {
            Log.error("getLastMsgTime,error :{} ,e :{} ,msgObj :{} ", new Object[]{e.getMessage(), e, msgObj});
        }
        Log.info("getLastMsgTime updateTime :{} ", (Object)updateTime);
        return updateTime;
    }

    private static String getConversationIDKey(String targetId, String userId) {
        StringBuilder sbld = new StringBuilder("history:conv:");
        sbld.append(targetId);
        sbld.append(":");
        sbld.append(userId);
        return sbld.toString();
    }

    private static String getGroupLastMember(String groupId) {
        String result = null;
        try {
            Group group = GroupManager.getInstance().getGroup(groupId);
            Collection members = group.getMembers();
            ArrayList membersList = new ArrayList(members);
            int memberSize = membersList.size();
            JID lastJID = (JID)membersList.get(memberSize - 1);
            if (lastJID != null) {
                result = SeeHistoryMsgUtil.getUserIDByUsername(lastJID.getNode());
            }
        }
        catch (Exception e) {
            Log.error("getGroupLastMember,groupId:{} ,error :{} ,e :{} ", new Object[]{groupId, e.getMessage(), e});
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(SeeHistoryMsgUtil.getUserIDByUsername("7651|1-mdvckbqdu-5g-vspxvlq"));
    }

    private static String getUserIDByUsername(String username) {
        if (username != null && username.contains("|")) {
            int index = username.indexOf("|");
            return username.substring(0, index);
        }
        return username;
    }
}

