/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util.pinyinutil;

import com.weaver.util.pinyin.ChineseToPinyinUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.util.pinyinutil.GroupPinYinBean;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupNameToPinyinThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(GroupNameToPinyinThread.class);

    @Override
    public void run() {
        int groupCount = this.getGroupCount();
        Log.info("groupCount :{} ", (Object)groupCount);
        if (groupCount <= 1000) {
            List<GroupPinYinBean> list = this.getGroupPinYinBeanList();
            this.updateListGroupPinYinBean(list);
        } else {
            int num = groupCount / 1000;
            for (int i = 0; i <= num; ++i) {
                List<GroupPinYinBean> list = this.getGroupPinYinBeanList(i);
                this.updateListGroupPinYinBean(list);
            }
        }
        JiveGlobals.setProperty((String)"GroupNameToPinyin", (String)"false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupPinYinBean> getGroupPinYinBeanList(int i) {
        int pageSize = 1000;
        int pageNumber = i + 1;
        Log.info("getGroupPinYinBeanList ,pageSize :{} ,pageNumber :{}", (Object)pageSize, (Object)pageNumber);
        String sql = " select groupname,description from ofgroup ";
        sql = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.sqlserver) ? "select * from  (select ROW_NUMBER() OVER(ORDER BY groupName DESC) AS rn,groupName,description from ofgroup) a  where a.rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.mysql) ? " select groupName,description from ofgroup order by groupName limit " + (pageNumber - 1) * pageSize + "," + pageSize : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.postgresql) ? " select groupName,description from ofgroup order by groupName " + pageSize + " offset " + (pageNumber - 1) * pageSize : "SELECT * FROM ( SELECT rownum as rn,groupName,description from ofgroup order by groupname)pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize));
        ArrayList<GroupPinYinBean> list = new ArrayList<GroupPinYinBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            Log.info("sql :{} ", (Object)sql);
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                GroupPinYinBean g = new GroupPinYinBean();
                g.setGroupName(rs.getString("groupname"));
                g.setDescription(rs.getString("description"));
                list.add(g);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroupPinYinBeanList ,error :{},e :{},i:{}", new Object[]{e.getMessage(), e, i});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }

    private String getSearchGroupName(String groupName) {
        try {
            String str = ChineseToPinyinUtil.toPinyinAndFirst((String)groupName);
            Log.info("groupName :{} ,str :{} ", (Object)groupName, (Object)str);
            return groupName + "^" + str;
        }
        catch (Exception e) {
            Log.error("=== groupName :{} ,e :{} ,e:{}", new Object[]{groupName, e.getMessage(), e});
            return groupName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListGroupPinYinBean(List<GroupPinYinBean> list) {
        PreparedStatement pstmt;
        Connection con;
        block5: {
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                int i = 0;
                pstmt = con.prepareStatement(" update ofgroup set searchGroupName = ? where groupName = ? ");
                for (GroupPinYinBean g : list) {
                    String groupName = g.getDescription();
                    pstmt.setString(1, this.getSearchGroupName(groupName));
                    pstmt.setString(2, g.getGroupName());
                    pstmt.addBatch();
                    if (++i % 100 != 0) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    i = 0;
                }
                if (i <= 0) break block5;
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (SQLException e) {
                try {
                    Log.error("updateListGroupPinYinBean ,error :{},e :{} ,list :{}", new Object[]{e.getMessage(), e, list});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupPinYinBean> getGroupPinYinBeanList() {
        ArrayList<GroupPinYinBean> list = new ArrayList<GroupPinYinBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select groupname,description from ofgroup ");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                GroupPinYinBean g = new GroupPinYinBean();
                g.setGroupName(rs.getString("groupname"));
                g.setDescription(rs.getString("description"));
                list.add(g);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroupPinYinBeanList ,error :{},e :{}", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getGroupCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block4: {
            int n;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select count(1) as groupCount from ofgroup ");
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt("groupCount");
            }
            catch (SQLException e) {
                try {
                    Log.error("getGroupCount ,error :{},e :{}", (Object)e.getMessage(), (Object)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return n;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return 0;
    }
}

