/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util.pinyinutil;

import com.weaver.util.pinyin.ChineseToPinyinUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.util.pinyinutil.GroupTagPinYinBean;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupTagToPinYinThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(GroupTagToPinYinThread.class);

    @Override
    public void run() {
        int groupTagCount = this.getGroupTagCount();
        if (groupTagCount <= 1000) {
            List<GroupTagPinYinBean> list = this.getGroupTagPinYinBeanList();
            this.updateListGroupTagPinYinBean(list);
        } else {
            int num = groupTagCount / 1000;
            for (int i = 0; i <= num; ++i) {
                List<GroupTagPinYinBean> list = this.getGroupTagPinYinBeanList(i);
                this.updateListGroupTagPinYinBean(list);
            }
        }
        JiveGlobals.setProperty((String)"GroupTagToPinyin", (String)"false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupTagPinYinBean> getGroupTagPinYinBeanList(int i) {
        int pageSize = 1000;
        int pageNumber = i + 1;
        String sql = "  select groupname,username,tagvalue from ofgrouptag  ";
        sql = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.sqlserver) ? "select * from  (select ROW_NUMBER() OVER(ORDER BY groupname DESC) AS rn,groupname,username,tagvalue from ofgrouptag) a  where a.rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.mysql) ? " select groupname,username,tagvalue from ofgrouptag order by groupname limit " + (pageNumber - 1) * pageSize + "," + pageSize : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.postgresql) ? " select groupname,username,tagvalue from ofgrouptag order by groupname " + pageSize + " offset " + (pageNumber - 1) * pageSize : "SELECT * FROM ( SELECT rownum as rn,groupname,username,tagvalue from ofgrouptag order by groupname)pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize));
        ArrayList<GroupTagPinYinBean> list = new ArrayList<GroupTagPinYinBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                GroupTagPinYinBean g = new GroupTagPinYinBean();
                g.setGroupname(rs.getString("groupname"));
                g.setUsername(rs.getString("username"));
                g.setTagvalue(rs.getString("tagvalue"));
                list.add(g);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroupTagPinYinBeanList ,error :{},e :{},i:{}", new Object[]{e.getMessage(), e, i});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }

    private String getSearchName(String tagValue) {
        try {
            String str = ChineseToPinyinUtil.toPinyinAndFirst((String)tagValue);
            Log.info("tagvalue = {},str= :{} ", (Object)tagValue, (Object)str);
            return tagValue + "^" + str;
        }
        catch (Exception e) {
            Log.error("---------- :{} ,e :{} ,e :{}", new Object[]{tagValue, e.getMessage(), e});
            return tagValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListGroupTagPinYinBean(List<GroupTagPinYinBean> list) {
        PreparedStatement pstmt;
        Connection con;
        block5: {
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                int i = 0;
                pstmt = con.prepareStatement(" update ofgroupTag set searchTagValue = ? where groupname = ? and username = ? and tagValue = ? ");
                for (GroupTagPinYinBean g : list) {
                    ++i;
                    String tagValue = g.getTagvalue();
                    pstmt.setString(1, this.getSearchName(tagValue));
                    pstmt.setString(2, g.getGroupname());
                    pstmt.setString(3, g.getUsername());
                    pstmt.setString(4, tagValue);
                    pstmt.addBatch();
                    if (i % 100 != 0) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    i = 0;
                }
                if (i <= 0) break block5;
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (SQLException e) {
                try {
                    Log.error("updateListGroupTagPinYinBean ,error :{},e :{} ,list :{}", new Object[]{e.getMessage(), e, list});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GroupTagPinYinBean> getGroupTagPinYinBeanList() {
        ArrayList<GroupTagPinYinBean> list = new ArrayList<GroupTagPinYinBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select groupname,username,tagvalue from ofgrouptag ");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                GroupTagPinYinBean g = new GroupTagPinYinBean();
                g.setGroupname(rs.getString("groupname"));
                g.setUsername(rs.getString("username"));
                g.setTagvalue(rs.getString("tagvalue"));
                list.add(g);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getGroupTagPinYinBeanList ,error :{},e :{}", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getGroupTagCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block4: {
            int n;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select count(1) as groupTagCount from ofgroupTag ");
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt("groupTagCount");
            }
            catch (SQLException e) {
                try {
                    Log.error("getGroupTagCount ,error :{},e :{}", (Object)e.getMessage(), (Object)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return n;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return 0;
    }
}

