/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.util.pinyinutil;

import com.weaver.util.pinyin.ChineseToPinyinUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.plugin.util.pinyinutil.GroupTagToPinYinThread;
import org.jivesoftware.openfire.plugin.util.pinyinutil.UserNamePinYinBean;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserNameToPinYinThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(GroupTagToPinYinThread.class);

    @Override
    public void run() {
        int userCount = this.getUserCount();
        if (userCount <= 1000) {
            List<UserNamePinYinBean> list = this.getUserNamePinYinBeanList();
            this.updateListUserNamePinYinBean(list);
        } else {
            int num = userCount / 1000;
            for (int i = 0; i <= num; ++i) {
                List<UserNamePinYinBean> list = this.getUserNamePinYinBeanList(i);
                this.updateListUserNamePinYinBean(list);
            }
        }
        JiveGlobals.setProperty((String)"UserNameToPinyin", (String)"false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UserNamePinYinBean> getUserNamePinYinBeanList(int i) {
        int pageSize = 1000;
        int pageNumber = i + 1;
        String sql = "  select username,name from ofuser  ";
        sql = DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.sqlserver) ? "select * from  (select ROW_NUMBER() OVER(ORDER BY username DESC) AS rn,username,name from ofuser) a  where a.rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.mysql) ? " select username,name from ofuser order by username limit " + (pageNumber - 1) * pageSize + "," + pageSize : (DbConnectionManager.getDatabaseType().equals((Object)DbConnectionManager.DatabaseType.postgresql) ? " select username,name from ofuser order by username " + pageSize + " offset " + (pageNumber - 1) * pageSize : "SELECT * FROM ( SELECT rownum as rn,username,name from ofuser order by username)pageTable WHERE rn BETWEEN " + ((pageNumber - 1) * pageSize + 1) + " AND " + pageNumber * pageSize));
        ArrayList<UserNamePinYinBean> list = new ArrayList<UserNamePinYinBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserNamePinYinBean g = new UserNamePinYinBean();
                g.setName(rs.getString("name"));
                g.setUsername(rs.getString("username"));
                list.add(g);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUserNamePinYinBeanList ,error :{},e :{},i:{}", new Object[]{e.getMessage(), e, i});
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }

    private String getSearchName(String name) {
        try {
            String fullName = ChineseToPinyinUtil.getName((String)name);
            String chineseName = ChineseToPinyinUtil.getChineseName((String)name);
            String pinyName = ChineseToPinyinUtil.toPinyinAndFirst((String)chineseName);
            Log.info("name :{},fullName:{},chineseName :{} ", new Object[]{name, fullName, chineseName});
            if (chineseName == null || chineseName.isEmpty()) {
                return fullName;
            }
            return fullName + "^" + pinyName;
        }
        catch (Exception e) {
            Log.error("++++ :name :{} ,e :{} ,e :{} ", new Object[]{name, e.getMessage(), e});
            return name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListUserNamePinYinBean(List<UserNamePinYinBean> list) {
        PreparedStatement pstmt;
        Connection con;
        block5: {
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                int i = 0;
                pstmt = con.prepareStatement(" update ofuser set searchname = ? where username = ? ");
                for (UserNamePinYinBean g : list) {
                    String name = g.getName();
                    pstmt.setString(1, this.getSearchName(name));
                    pstmt.setString(2, g.getUsername());
                    pstmt.addBatch();
                    if (++i % 100 != 0) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    i = 0;
                }
                if (i <= 0) break block5;
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (SQLException e) {
                try {
                    Log.error("updateListUserNamePinYinBean ,error :{},e :{} ,list :{}", new Object[]{e.getMessage(), e, list});
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((Statement)pstmt, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UserNamePinYinBean> getUserNamePinYinBeanList() {
        ArrayList<UserNamePinYinBean> list = new ArrayList<UserNamePinYinBean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(" select username,name from ofuser ");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserNamePinYinBean g = new UserNamePinYinBean();
                g.setName(rs.getString("name"));
                g.setUsername(rs.getString("username"));
                list.add(g);
            }
        }
        catch (SQLException e) {
            try {
                Log.error("getUserNamePinYinBeanList ,error :{},e :{}", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block4: {
            int n;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement("select count(1) as userCount from ofuser ");
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt("userCount");
            }
            catch (SQLException e) {
                try {
                    Log.error("getUserCount ,error :{},e :{}", (Object)e.getMessage(), (Object)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return n;
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return 0;
    }
}

