/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management;

import java.util.concurrent.atomic.AtomicReference;
import org.softee.management.annotation.ManagedAttribute;
import org.softee.management.annotation.ManagedOperation;

public class ServiceMBean {
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    @ManagedAttribute
    public String getState() {
        return this.state.toString();
    }

    @ManagedOperation
    public void start() {
        if (!this.state.compareAndSet(State.NEW, State.STARTING)) {
            throw new IllegalStateException("Unable to start service with state " + this.state);
        }
    }

    @ManagedOperation
    public void run() {
        switch (this.state.get()) {
            case STARTING: 
            case PAUSED: 
            case STOPPED: 
            case FAILED: {
                this.state.set(State.RUNNING);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to run service with state " + this.state);
            }
        }
    }

    @ManagedOperation
    public void pause() {
        if (!this.state.compareAndSet(State.RUNNING, State.PAUSED)) {
            throw new IllegalStateException("Unable to pause service with state " + this.state);
        }
    }

    @ManagedOperation
    public void resume() {
        if (!this.state.compareAndSet(State.PAUSED, State.RUNNING)) {
            throw new IllegalStateException("Unable to resume service with state " + this.state);
        }
    }

    @ManagedOperation
    public void stop() {
        if (!this.state.compareAndSet(State.PAUSED, State.STOPPED) && !this.state.compareAndSet(State.RUNNING, State.STOPPED)) {
            throw new IllegalStateException("Unable to resume service with state " + this.state);
        }
    }

    @ManagedOperation
    public void terminate() {
        if (this.state.get() == State.TERMINATED) {
            throw new IllegalStateException("Unable to terminate service with state " + this.state);
        }
        this.state.set(State.TERMINATED);
    }

    public static enum State {
        NEW,
        STARTING,
        RUNNING,
        PAUSED,
        STOPPED,
        FAILED,
        TERMINATED;

    }
}

