/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management.helper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.softee.management.annotation.Description;
import org.softee.management.annotation.MBean;
import org.softee.management.annotation.ManagedAttribute;
import org.softee.management.annotation.ManagedOperation;
import org.softee.management.annotation.Parameter;
import org.softee.management.exception.ManagementException;
import org.softee.management.helper.MBeanRegistrationBase;
import org.softee.util.Objects;

public class IntrospectedDynamicMBean
implements DynamicMBean,
MBeanRegistration {
    private final Object mbean;
    private final Class<?> mbeanClass;
    private final MBeanRegistration registrationDelegate;
    private final Map<String, PropertyDescriptor> propertyDescriptors;
    private final Map<String, Method> operationMethods;
    private final MBeanInfo mbeanInfo;

    public IntrospectedDynamicMBean(Object mbean) throws ManagementException {
        this.mbean = mbean;
        this.mbeanClass = mbean.getClass();
        if (!this.mbeanClass.isAnnotationPresent(MBean.class)) {
            throw new IllegalArgumentException(String.format("MBean %s is not annotated with @%s", this.mbeanClass, MBean.class.getName()));
        }
        this.registrationDelegate = (MBeanRegistration)(mbean instanceof MBeanRegistration ? mbean : new MBeanRegistrationBase());
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.mbeanClass);
            this.propertyDescriptors = IntrospectedDynamicMBean.createPropertyDescriptors(beanInfo);
            this.operationMethods = IntrospectedDynamicMBean.createOperationMethods(beanInfo);
            this.mbeanInfo = IntrospectedDynamicMBean.createMbeanInfo(this.mbeanClass, this.propertyDescriptors, this.operationMethods);
        }
        catch (javax.management.IntrospectionException e) {
            throw new ManagementException(e);
        }
        catch (IntrospectionException e) {
            throw new ManagementException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(attribute);
        if (propertyDescriptor == null) {
            throw new AttributeNotFoundException(attribute);
        }
        Method getter = propertyDescriptor.getReadMethod();
        if (getter == null) {
            throw new AttributeNotFoundException(String.format("Getter method for attribute %s of %s", attribute, this.mbeanClass));
        }
        try {
            if (!getter.isAccessible()) {
                getter.setAccessible(true);
            }
            return getter.invoke(this.mbean, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to obtain value of attribute %s of %s", attribute, this.mbeanClass));
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList attributes = new AttributeList(attributeNames.length);
        String[] stringArray = attributeNames;
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            try {
                Attribute attribute = new Attribute(attributeName, this.getAttribute(attributeName));
                attributes.add(attribute);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ++n2;
        }
        return attributes;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            throw new AttributeNotFoundException(name);
        }
        Method setter = propertyDescriptor.getWriteMethod();
        if (setter == null) {
            throw new AttributeNotFoundException(String.format("setter method for attribute %s of %s", name, this.mbeanClass));
        }
        Object value = attribute.getValue();
        try {
            if (!setter.isAccessible()) {
                setter.setAccessible(true);
            }
            setter.invoke(this.mbean, value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException(String.format("attribute %s, value = (%s)%s, expected (%s)", name, value.getClass().getName(), value, setter.getParameterTypes()[0].getName()));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, String.format("attribute %s of %s, value = (%s)%s", name, this.mbeanClass, value.getClass().getName(), value));
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e, String.format("attribute %s of %s, value = (%s)%s", name, this.mbeanClass, value.getClass().getName(), value));
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        for (Object object : attributes) {
            Attribute attribute = (Attribute)object;
            try {
                this.setAttribute(attribute);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return attributes;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Method method = this.operationMethods.get(actionName);
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.mbean, params);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static MBeanInfo createMbeanInfo(Class<?> mbeanClass, Map<String, PropertyDescriptor> propertyDescriptors, Map<String, Method> operationMethods) throws javax.management.IntrospectionException, ManagementException {
        String description = IntrospectedDynamicMBean.description(mbeanClass);
        MBeanAttributeInfo[] attributeInfo = IntrospectedDynamicMBean.createAttributeInfo(propertyDescriptors);
        MBeanConstructorInfo[] constructorInfo = IntrospectedDynamicMBean.createConstructorInfo();
        MBeanOperationInfo[] operationInfo = IntrospectedDynamicMBean.createOperationInfo(operationMethods);
        MBeanNotificationInfo[] notificationInfo = IntrospectedDynamicMBean.createNotificationInfo();
        return new MBeanInfo(mbeanClass.getName(), description, attributeInfo, constructorInfo, operationInfo, notificationInfo);
    }

    private static MBeanNotificationInfo[] createNotificationInfo() {
        return null;
    }

    private static Map<String, Method> createOperationMethods(BeanInfo beanInfo) throws ManagementException {
        Set<Method> allAccessors = IntrospectedDynamicMBean.allAccessors(beanInfo);
        HashMap<String, Method> operationMethods = new HashMap<String, Method>();
        MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
        int n = methodDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method old;
            boolean autoOperation;
            MethodDescriptor descriptor = methodDescriptorArray[n2];
            Method method = descriptor.getMethod();
            ManagedOperation operationAnnotation = method.getAnnotation(ManagedOperation.class);
            if (operationAnnotation != null && allAccessors.contains(method)) {
                throw new ManagementException(String.format("Accessor method %s is annotated as an @%s", method, ManagedOperation.class.getName()));
            }
            boolean isAutomatic = IntrospectedDynamicMBean.isAutomatic(method.getDeclaringClass(), MBean.AutomaticType.OPERATION);
            boolean bl = autoOperation = isAutomatic && IntrospectedDynamicMBean.isPublicInstance(method) && !allAccessors.contains(method);
            if ((operationAnnotation != null || autoOperation) && (old = operationMethods.put(method.getName(), method)) != null) {
                throw new ManagementException(String.format("Multiple Operation annotations for operation %s of %s", method.getName(), old.getDeclaringClass()));
            }
            ++n2;
        }
        return operationMethods;
    }

    private static boolean isPublicInstance(Method method) {
        int mod = method.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isStatic(mod);
    }

    private static Set<Method> allAccessors(BeanInfo beanInfo) {
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        HashSet<Method> accessors = new HashSet<Method>(propertyDescriptors.length * 2);
        PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            IntrospectedDynamicMBean.addNotNull(accessors, propertyDescriptor.getReadMethod());
            IntrospectedDynamicMBean.addNotNull(accessors, propertyDescriptor.getWriteMethod());
            ++n2;
        }
        return accessors;
    }

    public static <T> void addNotNull(Collection<T> collection, T element) {
        if (element != null) {
            collection.add(element);
        }
    }

    private static MBeanOperationInfo[] createOperationInfo(Map<String, Method> operationMethods) throws ManagementException {
        MBeanOperationInfo[] operationInfos = new MBeanOperationInfo[operationMethods.size()];
        int operationIndex = 0;
        for (String methodName : IntrospectedDynamicMBean.sortedKeys(operationMethods)) {
            Method method = operationMethods.get(methodName);
            ManagedOperation annotation = method.getAnnotation(ManagedOperation.class);
            MBeanParameterInfo[] signature = IntrospectedDynamicMBean.createParameterInfo(method);
            ManagedOperation.Impact impact = annotation == null ? ManagedOperation.Impact.UNKNOWN : annotation.value();
            int impactValue = impact.impactValue;
            String description = IntrospectedDynamicMBean.description(method);
            MBeanOperationInfo opInfo = new MBeanOperationInfo(method.getName(), description, signature, method.getReturnType().getName(), impactValue, null);
            operationInfos[operationIndex++] = opInfo;
        }
        return operationInfos;
    }

    private static boolean isAutomatic(Class<?> clazz, MBean.AutomaticType autoType) {
        MBean.AutomaticType[] values;
        MBean annotation = clazz.getAnnotation(MBean.class);
        if (annotation == null) {
            return false;
        }
        MBean.AutomaticType[] automaticTypeArray = values = annotation.automatic();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            MBean.AutomaticType value = automaticTypeArray[n2];
            if (value == autoType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static MBeanParameterInfo[] createParameterInfo(Method method) {
        MBeanParameterInfo[] parameters = new MBeanParameterInfo[method.getParameterTypes().length];
        int parameterIndex = 0;
        while (parameterIndex < parameters.length) {
            String pType = method.getParameterTypes()[parameterIndex].getName();
            Parameter parameter = IntrospectedDynamicMBean.getParameterAnnotation(method, parameterIndex, Parameter.class);
            Description description = IntrospectedDynamicMBean.getParameterAnnotation(method, parameterIndex, Description.class);
            String pName = parameter != null ? parameter.value() : "p" + (parameterIndex + 1);
            String pDesc = description != null ? description.value() : null;
            parameters[parameterIndex] = new MBeanParameterInfo(pName, pType, pDesc);
            ++parameterIndex;
        }
        return parameters;
    }

    private static MBeanConstructorInfo[] createConstructorInfo() {
        return null;
    }

    private static Map<String, PropertyDescriptor> createPropertyDescriptors(BeanInfo beanInfo) throws ManagementException {
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor property = propertyDescriptorArray[n2];
            ManagedAttribute getterAnnotation = IntrospectedDynamicMBean.getAnnotation(property.getReadMethod(), ManagedAttribute.class);
            ManagedAttribute setterAnnotation = IntrospectedDynamicMBean.getAnnotation(property.getWriteMethod(), ManagedAttribute.class);
            if (IntrospectedDynamicMBean.isAutomatic(property) || getterAnnotation != null || setterAnnotation != null) {
                properties.put(property.getName(), property);
            }
            ++n2;
        }
        return properties;
    }

    private static MBeanAttributeInfo[] createAttributeInfo(Map<String, PropertyDescriptor> propertyDescriptors) throws ManagementException, javax.management.IntrospectionException {
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[propertyDescriptors.size()];
        int i = 0;
        for (String propertyName : IntrospectedDynamicMBean.sortedKeys(propertyDescriptors)) {
            PropertyDescriptor property = propertyDescriptors.get(propertyName);
            boolean isAutomatic = IntrospectedDynamicMBean.isAutomatic(property);
            Method readMethod = property.getReadMethod();
            Method writeMethod = property.getWriteMethod();
            boolean readable = isAutomatic || IntrospectedDynamicMBean.getAnnotation(readMethod, ManagedAttribute.class) != null;
            boolean writable = isAutomatic || IntrospectedDynamicMBean.getAnnotation(writeMethod, ManagedAttribute.class) != null;
            Description descriptionAnnotation = IntrospectedDynamicMBean.getSingleAnnotation(property, Description.class, readMethod, writeMethod);
            String description = descriptionAnnotation != null ? descriptionAnnotation.value() : null;
            MBeanAttributeInfo info = new MBeanAttributeInfo(property.getName(), description, readable ? readMethod : null, writable ? writeMethod : null);
            infos[i++] = info;
        }
        return infos;
    }

    private static boolean isAutomatic(PropertyDescriptor property) {
        Method accessor = Objects.firstNotNull(property.getReadMethod(), property.getWriteMethod());
        boolean isAutomatic = IntrospectedDynamicMBean.isAutomatic(accessor.getDeclaringClass(), MBean.AutomaticType.ATTRIBUTE);
        return isAutomatic;
    }

    private static <T extends Annotation> T getSingleAnnotation(PropertyDescriptor property, Class<T> annotationClass, AccessibleObject ... entities) throws ManagementException {
        T result = null;
        AccessibleObject[] accessibleObjectArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            T annotation;
            AccessibleObject entity = accessibleObjectArray[n2];
            if (entity != null && (annotation = entity.getAnnotation(annotationClass)) != null) {
                if (result != null) {
                    throw new ManagementException(String.format("Multiple %s annotations found for property %s", annotationClass.getName(), property.getName()));
                }
                result = annotation;
            }
            ++n2;
        }
        return result;
    }

    private static <A extends Annotation> A getParameterAnnotation(Method method, int index, Class<A> annotationClass) {
        Annotation[] annotationArray = method.getParameterAnnotations()[index];
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationClass.isInstance(a)) {
                return (A)((Annotation)annotationClass.cast(a));
            }
            ++n2;
        }
        return null;
    }

    private static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        return element != null ? (A)element.getAnnotation(annotationClass) : null;
    }

    private static String description(AnnotatedElement element) {
        String explicitValue;
        Description annotation = element.getAnnotation(Description.class);
        String string = explicitValue = annotation != null ? annotation.value() : null;
        if (explicitValue != null && !explicitValue.isEmpty()) {
            return explicitValue;
        }
        return IntrospectedDynamicMBean.generatedDescription(element);
    }

    private static String generatedDescription(AnnotatedElement element) {
        if (element instanceof Method) {
            Method method = (Method)element;
            return String.valueOf(method.getName()) + "() of " + method.getDeclaringClass().getSimpleName();
        }
        if (element instanceof Class) {
            return "class " + ((Class)element).getName();
        }
        return element.toString();
    }

    private static List<String> sortedKeys(Map<String, ?> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        return keys;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return this.registrationDelegate.preRegister(server, name);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        this.registrationDelegate.postRegister(registrationDone);
    }

    @Override
    public void postDeregister() {
        this.registrationDelegate.postDeregister();
    }

    @Override
    public void preDeregister() throws Exception {
        this.registrationDelegate.preDeregister();
    }
}

