/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management.samples;

import java.util.concurrent.atomic.AtomicInteger;
import org.softee.management.annotation.Description;
import org.softee.management.annotation.MBean;
import org.softee.management.annotation.ManagedAttribute;
import org.softee.management.annotation.ManagedOperation;
import org.softee.management.annotation.Parameter;
import org.softee.management.helper.MBeanRegistration;

@MBean(objectName="org.softee:type=Demo,name=CountingApplication")
@Description(value="This Java application shows how to expose a Read/Write int property and two methods as an MBean")
public class CountingApplication {
    private final AtomicInteger counter = new AtomicInteger();

    public static void main(String[] args) throws Exception {
        new CountingApplication().run();
    }

    private void run() throws Exception {
        new MBeanRegistration(this).register();
        while (true) {
            System.out.println("counter = " + this.getCounter());
            this.incrementCounter(1);
            Thread.sleep(1000L);
        }
    }

    @ManagedAttribute
    @Description(value="A counter variable")
    public int getCounter() {
        return this.counter.get();
    }

    @ManagedAttribute
    public void setCounter(int counter) {
        this.counter.set(counter);
    }

    @ManagedOperation
    @Description(value="Increments the counter by the requested amount and shows the resulting value")
    public int incrementCounter(@Parameter(value="amount") @Description(value="The amount to increment the counter with") int delta) {
        return this.counter.addAndGet(delta);
    }

    @ManagedOperation
    @Description(value="Resets the counter")
    public void reset() {
        this.counter.set(0);
    }
}

