/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tearpc;

import com.aliyun.common.Common;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tearpc.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.InputStream;
import java.util.Map;

public class Client {
    public String _endpoint;
    public String _regionId;
    public String _protocol;
    public String _userAgent;
    public String _endpointRule;
    public Map<String, String> _endpointMap;
    public String _suffix;
    public Integer _readTimeout;
    public Integer _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _socks5Proxy;
    public String _socks5NetWork;
    public String _noProxy;
    public String _network;
    public String _productId;
    public Integer _maxIdleConns;
    public String _endpointType;
    public String _openPlatformEndpoint;
    public com.aliyun.credentials.Client _credential;

    public Client(Config config) throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        com.aliyun.teautil.Common.validateModel((TeaModel)config);
        if (!com.aliyun.teautil.Common.empty((String)config.accessKeyId) && !com.aliyun.teautil.Common.empty((String)config.accessKeySecret)) {
            config.type = !com.aliyun.teautil.Common.empty((String)config.securityToken) ? "sts" : "access_key";
            com.aliyun.credentials.models.Config credentialConfig = com.aliyun.credentials.models.Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("accessKeyId", (Object)config.accessKeyId), new TeaPair("type", (Object)config.type), new TeaPair("accessKeySecret", (Object)config.accessKeySecret), new TeaPair("securityToken", (Object)config.securityToken)}));
            this._credential = new com.aliyun.credentials.Client(credentialConfig);
        } else if (!com.aliyun.teautil.Common.isUnset((Object)config.credential)) {
            this._credential = config.credential;
        } else {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'accessKeyId' and 'accessKeySecret' or 'credential' can not be unset")}));
        }
        this._network = config.network;
        this._suffix = config.suffix;
        this._endpoint = config.endpoint;
        this._protocol = config.protocol;
        this._regionId = config.regionId;
        this._userAgent = config.userAgent;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = config.maxIdleConns;
        this._endpointType = config.endpointType;
        this._openPlatformEndpoint = config.openPlatformEndpoint;
    }

    public Map<String, ?> doRequest(String action, String protocol, String method, String version, String authType, Map<String, ?> query, Map<String, ?> body, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = com.aliyun.teautil.Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = "/";
                request_.query = Common.query((Map)TeaConverter.merge(Object.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("Action", (Object)action), new TeaPair("Format", (Object)"json"), new TeaPair("Timestamp", (Object)Common.getTimestamp()), new TeaPair("Version", (Object)version), new TeaPair("SignatureNonce", (Object)com.aliyun.teautil.Common.getNonce())}), query}));
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("x-acs-version", (Object)version), new TeaPair("x-acs-action", (Object)action), new TeaPair("host", (Object)this._endpoint), new TeaPair("user-agent", (Object)this.getUserAgent())});
                if (!com.aliyun.teautil.Common.isUnset(body)) {
                    Map tmp = com.aliyun.teautil.Common.anyifyMapValue((Map)Common.query(body));
                    request_.body = Tea.toReadable((String)com.aliyun.teautil.Common.toFormString((Map)tmp));
                    request_.headers.put("content-type", "application/x-www-form-urlencoded");
                }
                if (!com.aliyun.teautil.Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this.getAccessKeyId();
                    String accessKeySecret = this.getAccessKeySecret();
                    String securityToken = this.getSecurityToken();
                    if (!com.aliyun.teautil.Common.empty((String)securityToken)) {
                        request_.query.put("SecurityToken", securityToken);
                    }
                    request_.query.put("SignatureMethod", "HMAC-SHA1");
                    request_.query.put("SignatureVersion", "1.0");
                    request_.query.put("AccessKeyId", accessKeyId);
                    Map signedParam = TeaConverter.merge(String.class, (Map[])new Map[]{request_.query, Common.query(body)});
                    request_.query.put("Signature", Common.getSignatureV1((Map)signedParam, (String)request_.method, (String)accessKeySecret));
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                Object obj = com.aliyun.teautil.Common.readAsJSON((InputStream)response_.body);
                Map res = com.aliyun.teautil.Common.assertAsMap((Object)obj);
                if (com.aliyun.teautil.Common.is4xx((Number)response_.statusCode) || com.aliyun.teautil.Common.is5xx((Number)response_.statusCode)) {
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(res.get("Code"), res.get("code")) + "")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(res.get("Message"), res.get("message")) + " request id: " + Client.defaultAny(res.get("RequestId"), res.get("requestId")) + "")), new TeaPair("data", (Object)res)}));
                }
                return res;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public String getUserAgent() throws Exception {
        String userAgent = com.aliyun.teautil.Common.getUserAgent((String)this._userAgent);
        return userAgent;
    }

    public String getAccessKeyId() throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)this._credential)) {
            return "";
        }
        String accessKeyId = this._credential.getAccessKeyId();
        return accessKeyId;
    }

    public String getAccessKeySecret() throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)this._credential)) {
            return "";
        }
        String secret = this._credential.getAccessKeySecret();
        return secret;
    }

    public String getSecurityToken() throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)this._credential)) {
            return "";
        }
        String token = this._credential.getSecurityToken();
        return token;
    }

    public void checkConfig(Config config) throws Exception {
        if (com.aliyun.teautil.Common.empty((String)this._endpointRule) && com.aliyun.teautil.Common.empty((String)config.endpoint)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.endpoint' can not be empty")}));
        }
    }

    public static Object defaultAny(Object inputValue, Object defaultValue) throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)inputValue)) {
            return defaultValue;
        }
        return inputValue;
    }
}

