/*
 * Decompiled with CFR 0.152.
 */
package nsp;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import nsp.support.common.AbsNSPClient;
import nsp.support.common.NSPException;
import nsp.support.common.NSPResponse;
import nsp.support.common.Utils;

public class NSPClient
extends AbsNSPClient {
    public static final String JSON_RPC = "json-rpc";
    public static final String FMT_JSON = "JSON";
    private String accessToken = "";

    public NSPClient(String accessToken) {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        this.accessToken = accessToken;
    }

    public Object getInterfaceInstance(String service, Class interfaceClass) throws NSPException {
        return this.getInterfaceInstance(service, interfaceClass, JSON_RPC, null);
    }

    public Object getInterfaceInstance(String service, Class interfaceClass, String formatType, Map<String, Object> attributes) throws NSPException {
        String format = formatType;
        if (null == service || "".equals(service)) {
            return null;
        }
        Object f = null;
        if (null == format || "".equals(format)) {
            format = JSON_RPC;
        }
        HWInvokeMethodProxy handler = new HWInvokeMethodProxy(this, service, formatType, attributes);
        try {
            Class<?> proxyClass = Proxy.getProxyClass(interfaceClass.getClassLoader(), interfaceClass);
            f = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
        }
        catch (Exception e) {
            throw new NSPException(1, "", e);
        }
        return f;
    }

    @Override
    protected NSPResponse callService(String service, Map<String, Object> params, Map<String, Object> attributes) throws NSPException {
        HashMap<String, String> ps = new HashMap<String, String>();
        if (Utils.isEmptyString(this.accessToken)) {
            throw new NSPException(1, "Access_token is empty.");
        }
        ps.put("access_token", this.accessToken);
        if (Utils.isEmptyString(service)) {
            throw new NSPException(1, "Service name is empty.");
        }
        ps.put("nsp_svc", service);
        try {
            if (null != attributes && 0 != attributes.size()) {
                ps.put("nsp_ctx", JSON.toJSONString(attributes));
            }
        }
        catch (Exception e) {
            throw new NSPException(1, "Parameter json-serialize failed." + e.getMessage());
        }
        try {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                if (v instanceof String) {
                    ps.put(k, (String)v);
                    continue;
                }
                ps.put(k, JSON.toJSONString((Object)v));
            }
        }
        catch (Exception e) {
            throw new NSPException(1, "Parameter json-serialize failed.", e);
        }
        ps.put("nsp_fmt", FMT_JSON);
        ps.put("nsp_ts", String.valueOf(TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS)));
        String data = this.getPostData(ps);
        NSPResponse response = this.request(this.apiUrl, data, null, hostApi);
        if (response == null) {
            throw new NSPException(1, "Server No Response");
        }
        return response;
    }

    @Deprecated
    public NSPResponse call(String service, Map<String, String> params) throws NSPException {
        params.put("access_token", this.accessToken);
        params.put("nsp_svc", service);
        params.put("nsp_fmt", FMT_JSON);
        params.put("nsp_ts", String.valueOf(TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS)));
        String data = this.getPostData(params);
        NSPResponse response = this.request(this.apiUrl, data, null, hostApi);
        if (response == null) {
            throw new NSPException(1, "Server No Response");
        }
        return response;
    }

    @Override
    protected NSPResponse callJSONRPCService(String service, Object[] params, Map<String, Object> attributes) throws NSPException {
        HashMap<String, String> ps = new HashMap<String, String>();
        if (Utils.isEmptyString(this.accessToken)) {
            throw new NSPException(1, "Access_token is empty.");
        }
        ps.put("access_token", this.accessToken);
        if (Utils.isEmptyString(service)) {
            throw new NSPException(1, "Service name is empty.");
        }
        ps.put("nsp_svc", service);
        try {
            if (null != attributes && 0 != attributes.size()) {
                ps.put("nsp_ctx", JSON.toJSONString(attributes));
            }
        }
        catch (Exception e) {
            throw new NSPException(1, "Parameter json-serialize failed.", e);
        }
        try {
            ps.put("nsp_params", JSON.toJSONString((Object)params));
        }
        catch (Exception e) {
            throw new NSPException(1, "Parameter json-serialize failed.", e);
        }
        ps.put("nsp_fmt", JSON_RPC);
        ps.put("nsp_ts", String.valueOf(TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS)));
        String data = this.getPostData(ps);
        NSPResponse response = this.request(this.apiUrl, data, null, hostApi);
        if (response == null) {
            throw new NSPException(1, "Server No Response");
        }
        return response;
    }

    private static class HWInvokeMethodProxy
    implements InvocationHandler {
        private String serviceName = null;
        private String format = null;
        private NSPClient client = null;
        private Map<String, Object> attributes = null;

        public HWInvokeMethodProxy(NSPClient client, String serviceName, String fmt, Map<String, Object> attributes) {
            this.client = client;
            this.serviceName = serviceName;
            this.format = fmt;
            this.attributes = attributes;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws NSPException {
            return this.client.call(this.serviceName + "." + method.getName(), args, method.getGenericReturnType(), this.attributes, null);
        }
    }
}

