/*
 * Decompiled with CFR 0.152.
 */
package nsp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.Map;
import nsp.support.common.AbsNSPClient;
import nsp.support.common.AccessToken;
import nsp.support.common.CastUtils;
import nsp.support.common.NSPException;
import nsp.support.common.NSPResponse;

public class OAuth2Client
extends AbsNSPClient {
    public OAuth2Client() {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    public AccessToken getAccessToken(String grantType, String clientId, String clientSecret) throws NSPException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", grantType);
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        String data = this.getPostData(params);
        NSPResponse response = this.request(this.tokenUrl, data, null, hostAuth);
        if (response == null) {
            throw new NSPException(1, "Server No Response");
        }
        try {
            return (AccessToken)JSON.parseObject((byte[])response.getContent(), AccessToken.class, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            String error = ", Result code: " + response.getCode() + ", result message: " + CastUtils.newString(response.getContent());
            throw new NSPException(1, error, e);
        }
    }

    @Override
    protected NSPResponse callService(String service, Map<String, Object> params, Map<String, Object> attributes) throws NSPException {
        return null;
    }

    @Override
    protected NSPResponse callJSONRPCService(String service, Object[] params, Map<String, Object> attributes) throws NSPException {
        return null;
    }
}

