/*
 * Decompiled with CFR 0.152.
 */
package nsp.support.common;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import nsp.support.common.SerializeException;
import nsp.support.common.TypeUtils;

public class CastUtils {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public static <T> T cast(Object val, Type type) {
        Class<?> clazz = val.getClass();
        if (clazz == byte[].class) {
            return CastUtils.cast((byte[])val, type);
        }
        if (clazz == String.class) {
            return CastUtils.cast((String)val, type);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return CastUtils.cast((Number)val, type);
        }
        Class<?> destClazz = TypeUtils.getClass(type);
        if (destClazz.isArray() || GenericArrayType.class.isAssignableFrom(destClazz)) {
            Object[] a = (Object[])val;
            return (T)a;
        }
        if (clazz.isArray() && Collection.class.isAssignableFrom(destClazz)) {
            Object[] a = (Object[])val;
            Collection<?> c = TypeUtils.createCollection(Collection.class, a.length);
            for (Object t : a) {
                c.add(t);
            }
            return (T)c;
        }
        return null;
    }

    public static <T> T cast(byte[] val, Type type) {
        if (type == byte[].class) {
            return (T)val;
        }
        if (type == String.class) {
            return (T)CastUtils.newString(val);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)Integer.valueOf(CastUtils.newString(val));
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)Long.valueOf(CastUtils.newString(val));
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(CastUtils.newString(val));
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(CastUtils.newString(val));
        }
        if (type == Byte[].class) {
            Byte[] r = new Byte[val.length];
            for (int i = 0; i < val.length; ++i) {
                r[i] = val[i];
            }
            return (T)r;
        }
        throw new SerializeException("unsupported type:" + type);
    }

    public static <T> T cast(String val, Type type) {
        if (type == String.class) {
            return (T)val;
        }
        if (type == byte[].class) {
            return (T)CastUtils.getBytes(val);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)Integer.valueOf(val);
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)Long.valueOf(val);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(val);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(val);
        }
        if (type == Byte[].class) {
            byte[] bytes = CastUtils.getBytes(val);
            Byte[] r = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                r[i] = bytes[i];
            }
            return (T)r;
        }
        throw new SerializeException("unsupported type:" + type);
    }

    public static <T> T cast(Number n, Type type) {
        if (type == String.class) {
            return (T)String.valueOf(n);
        }
        if (type == byte[].class) {
            return (T)CastUtils.getBytes(String.valueOf(n));
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)Integer.valueOf(n.intValue());
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)Long.valueOf(n.longValue());
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(n.doubleValue());
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(n.floatValue());
        }
        if (type == Byte[].class) {
            byte[] bytes = CastUtils.getBytes(String.valueOf(n));
            Byte[] r = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                r[i] = bytes[i];
            }
            return (T)r;
        }
        throw new SerializeException("unsupported type:" + type);
    }

    public static String newString(byte[] bytes) {
        return bytes == null ? null : new String(bytes, CHARSET_UTF8);
    }

    public static byte[] getBytes(String str) {
        if (str == null) {
            return null;
        }
        return str.getBytes(CHARSET_UTF8);
    }
}

