/*
 * Decompiled with CFR 0.152.
 */
package nsp.support.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeUtils {
    private static final Map<String, Method> METHODS = new ConcurrentHashMap<String, Method>();

    public static void register(String name, Type type) {
        Method[] methods;
        Class<?> clazz = TypeUtils.getClass(type);
        for (Method m : methods = clazz.getDeclaredMethods()) {
            METHODS.put(name + "." + m.getName(), m);
        }
    }

    public static Method getMethod(String service) {
        return METHODS.get(service);
    }

    public static Type[] getParameterTypes(String service) {
        Method m = METHODS.get(service);
        if (m == null) {
            return null;
        }
        return m.getGenericParameterTypes();
    }

    public static Class<?> getClass(Type type) {
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return GenericArrayType.class;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static <T> T newInstance(Class<?> clazz, Object fatherObj) {
        try {
            int dollarIndex = clazz.getName().indexOf("$");
            if (null == fatherObj) {
                String cString = clazz.getName();
                if (-1 == dollarIndex) {
                    return (T)clazz.newInstance();
                }
                String outClassName = cString.substring(0, dollarIndex);
                Class<?> clazz2 = Class.forName(outClassName);
                Object out = clazz2.newInstance();
                Constructor c = TypeUtils.getAccessConstrutor(clazz);
                return c.newInstance(out);
            }
            if (clazz.getDeclaredConstructors().length > 0 && -1 != dollarIndex) {
                Constructor c = TypeUtils.getAccessConstrutor(clazz);
                return c.newInstance(fatherObj);
            }
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("create instance error:" + clazz, e);
        }
    }

    private static Constructor getAccessConstrutor(Class<?> clazz) {
        Constructor<?> c = clazz.getDeclaredConstructors()[0];
        c.setAccessible(true);
        return c;
    }

    public static void set(Field field, Object obj, Object val) {
        try {
            field.set(obj, val);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("set val error:" + field.getName(), e);
        }
    }

    public static Map<String, Field> getFields(Type type) {
        TreeMap<String, Field> fields = new TreeMap<String, Field>();
        for (Class<?> cls = TypeUtils.getClass(type); cls != null; cls = cls.getSuperclass()) {
            Field[] fs = cls.getDeclaredFields();
            for (int i = 0; i < fs.length; ++i) {
                Field field = fs[i];
                int mod = fs[i].getModifiers();
                if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
                field.setAccessible(true);
                if (fields.get(field.getName()) != null || field.getName().startsWith("this$")) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields;
    }

    public static Collection<?> createCollection(Class<?> clazz, int size) {
        if (clazz.isInterface()) {
            if (clazz == Set.class) {
                return new HashSet(size);
            }
            if (clazz == List.class || clazz == Collection.class) {
                return new ArrayList(size);
            }
            throw new UnsupportedOperationException("unknow interface:" + clazz);
        }
        if (clazz == AbstractCollection.class) {
            return new ArrayList(size);
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet();
        }
        if (clazz.isAssignableFrom(LinkedHashSet.class)) {
            return new LinkedHashSet();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("unknow class: " + clazz.getName(), e);
        }
    }

    public static Map<Object, Object> createMap(Type type, int size) {
        if (type == Map.class) {
            return new LinkedHashMap<Object, Object>();
        }
        if (type == HashMap.class) {
            return new HashMap<Object, Object>();
        }
        if (type == Properties.class) {
            return new Properties();
        }
        if (type == Hashtable.class) {
            return new Hashtable<Object, Object>();
        }
        if (type == IdentityHashMap.class) {
            return new IdentityHashMap<Object, Object>();
        }
        if (type == SortedMap.class || type == TreeMap.class) {
            return new TreeMap<Object, Object>();
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<Object, Object>();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap<Object, Object>();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return TypeUtils.createMap(parameterizedType.getRawType(), size);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isInterface()) {
                throw new UnsupportedOperationException("unsupport type " + type);
            }
            try {
                return (Map)clazz.newInstance();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("unsupport type " + type, e);
            }
        }
        throw new UnsupportedOperationException("unsupport type " + type);
    }
}

