/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.sdk.weixin.cp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.weaver.sdk.weixin.cp.api.WxCpCheckinService;
import com.weaver.sdk.weixin.cp.api.bean.WxCpCheckinData;
import com.weaver.sdk.weixin.cp.api.bean.WxCpPunchCorrection;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpCheckinServiceImpl
implements WxCpCheckinService {
    private WxCpService mainService;
    Logger logger = LoggerFactory.getLogger(WxCpCheckinServiceImpl.class);

    public WxCpCheckinServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public List<WxCpCheckinData> getCheckInData(int openCheckinDataType, long startTime, long endTime, List<String> userIdList) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/checkin/getcheckindata";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("opencheckindatatype", (Number)openCheckinDataType);
        jsonObject.addProperty("starttime", (Number)startTime);
        jsonObject.addProperty("endtime", (Number)endTime);
        JsonArray _userIdList = new JsonArray();
        for (String userId : userIdList) {
            _userIdList.add(userId);
        }
        jsonObject.add("useridlist", (JsonElement)_userIdList);
        this.logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u8003\u52e4\u6253\u5361\u6570\u636e==\u8bf7\u6c42url\uff1a" + url + "\u8bf7\u6c42\u53c2\u6570\uff1a" + jsonObject.toString());
        String responseContent = this.mainService.post(url, jsonObject.toString());
        this.logger.info("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u8003\u52e4\u6253\u5361\u6570\u636e\uff0c\u8fd4\u56de\u503c\uff1a" + responseContent);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("checkindata").toString(), new TypeToken<List<WxCpCheckinData>>(){}.getType());
    }

    @Override
    public void getCheckInOption() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/checkin/getcheckinoption";
        throw new UnsupportedOperationException();
    }

    @Override
    public void punchCorrection(WxCpPunchCorrection correction) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/checkin/punch_correction";
        this.mainService.post(url, correction.toJson());
    }
}

