/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.sdk.weixin.cp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.weaver.sdk.weixin.cp.api.WxCpExternalContactService;
import com.weaver.sdk.weixin.cp.api.bean.WxCpChatGroup;
import com.weaver.sdk.weixin.cp.api.bean.WxCpUserExternalContactRemark;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUserExternalContactInfo;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpExternalContactServiceImpl
implements WxCpExternalContactService {
    private WxCpService mainService;

    public WxCpExternalContactServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public String[] getFollowUserList() throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get_follow_user_list";
        String responseContent = this.mainService.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (String[])WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("follow_user"), new TypeToken<String[]>(){}.getType());
    }

    @Override
    public String[] list(String userId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/list?userid=" + userId;
        String responseContent = this.mainService.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (String[])WxCpGsonBuilder.create().fromJson(tmpJsonElement.getAsJsonObject().get("external_userid"), new TypeToken<String[]>(){}.getType());
    }

    @Override
    public WxCpUserExternalContactInfo get(String externalUserId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/get?external_userid=" + externalUserId;
        String responseContent = this.mainService.get(url, null);
        return WxCpUserExternalContactInfo.fromJson(responseContent);
    }

    @Override
    public Map<String, Object> batchGet(String userId, String cursor, int limit) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/batch/get_by_user";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        jsonObject.addProperty("cursor", cursor);
        jsonObject.addProperty("limit", (Number)limit);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonObject json = tmpJsonElement.getAsJsonObject();
        HashMap<String, Object> result = new HashMap<String, Object>();
        List list = (List)WxCpGsonBuilder.create().fromJson(json.get("external_contact_list"), new TypeToken<List<WxCpUserExternalContactInfo>>(){}.getType());
        result.put("list", list);
        result.put("nextCursor", GsonHelper.getAsString((JsonElement)json.get("next_cursor")));
        return result;
    }

    @Override
    public void remark(WxCpUserExternalContactRemark remark) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/remark";
        this.mainService.post(url, remark.toJson());
    }

    @Override
    public WxCpChatGroup getGroupChat(String chatId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/externalcontact/groupchat/get";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("chat_id", chatId);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonObject groupJson = tmpJsonElement.getAsJsonObject().get("group_chat").getAsJsonObject();
        WxCpChatGroup group = new WxCpChatGroup();
        group.setId(GsonHelper.getAsString((JsonElement)groupJson.get("chat_id")));
        group.setName(GsonHelper.getAsString((JsonElement)groupJson.get("name")));
        group.setOwner(GsonHelper.getAsString((JsonElement)groupJson.get("owner")));
        group.setCreateTime(new Date(GsonHelper.getAsLong((JsonElement)groupJson.get("create_time")) * 1000L));
        group.setNotice(GsonHelper.getAsString((JsonElement)groupJson.get("notice")));
        ArrayList<WxCpChatGroup.Member> members = new ArrayList<WxCpChatGroup.Member>();
        for (JsonElement memberJE : groupJson.get("member_list").getAsJsonArray()) {
            JsonObject memberJO = memberJE.getAsJsonObject();
            WxCpChatGroup.Member member = new WxCpChatGroup.Member();
            member.setUserId(GsonHelper.getAsString((JsonElement)memberJO.get("userid")));
            member.setType(GsonHelper.getAsInteger((JsonElement)memberJO.get("type")));
            member.setJoinTime(new Date(GsonHelper.getAsLong((JsonElement)memberJO.get("join_time")) * 1000L));
            member.setJoinScene(GsonHelper.getAsInteger((JsonElement)memberJO.get("join_scene")));
            members.add(member);
        }
        group.setMembers(members);
        return group;
    }
}

