/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.sdk.weixin.cp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.weaver.sdk.weixin.cp.api.WxCpMsgAuditService;
import com.weaver.sdk.weixin.cp.api.bean.WxCpChatGroup;
import java.util.ArrayList;
import java.util.Date;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.api.WxCpService;

public class WxCpMsgAuditServiceImpl
implements WxCpMsgAuditService {
    private WxCpService mainService;

    public WxCpMsgAuditServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public WxCpChatGroup getGroupChat(String roomId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/msgaudit/groupchat/get";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("roomid", roomId);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonObject groupJson = tmpJsonElement.getAsJsonObject();
        WxCpChatGroup group = new WxCpChatGroup();
        group.setId(roomId);
        group.setName(GsonHelper.getAsString((JsonElement)groupJson.get("roomname")));
        group.setOwner(GsonHelper.getAsString((JsonElement)groupJson.get("creator")));
        group.setCreateTime(new Date(GsonHelper.getAsLong((JsonElement)groupJson.get("room_create_time")) * 1000L));
        group.setNotice(GsonHelper.getAsString((JsonElement)groupJson.get("notice")));
        ArrayList<WxCpChatGroup.Member> members = new ArrayList<WxCpChatGroup.Member>();
        for (JsonElement memberJE : groupJson.get("members").getAsJsonArray()) {
            JsonObject memberJO = memberJE.getAsJsonObject();
            WxCpChatGroup.Member member = new WxCpChatGroup.Member();
            member.setUserId(GsonHelper.getAsString((JsonElement)memberJO.get("memberid")));
            member.setJoinTime(new Date(GsonHelper.getAsLong((JsonElement)memberJO.get("jointime")) * 1000L));
            members.add(member);
        }
        group.setMembers(members);
        return group;
    }
}

