/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpCalendarService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpCalendar;
import me.chanjar.weixin.cp.bean.WxCpSchedule;

public class WxCpCalendarServiceImpl
implements WxCpCalendarService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private WxCpService mainService;

    public WxCpCalendarServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public String addCalendar(WxCpCalendar wxCpCalendar) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/oa/calendar/add";
        String result = this.mainService.post(url, wxCpCalendar.toJson());
        JsonObject jsonObject = JSON_PARSER.parse(result).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)result));
        }
        return jsonObject.get("cal_id").getAsString();
    }

    @Override
    public String addSchedule(WxCpSchedule wxCpSchedule) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/add";
        String result = this.mainService.post(url, wxCpSchedule.toJson());
        JsonObject jsonObject = JSON_PARSER.parse(result).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)result));
        }
        return jsonObject.get("schedule_id").getAsString();
    }

    @Override
    public String updateSchedule(WxCpSchedule wxCpSchedule) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/update";
        String result = this.mainService.post(url, wxCpSchedule.toJson());
        JsonObject jsonObject = JSON_PARSER.parse(result).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)result));
        }
        return jsonObject.get("errmsg").getAsString();
    }

    @Override
    public String deleteSchedule(String scheduleId) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("schedule_id", scheduleId);
        String url = "https://qyapi.weixin.qq.com/cgi-bin/oa/schedule/del";
        String result = this.mainService.post(url, o.toString());
        JsonObject jsonObject = JSON_PARSER.parse(result).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)result));
        }
        return jsonObject.get("errmsg").getAsString();
    }
}

