/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import me.chanjar.weixin.common.bean.WxCardApiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.cp.api.WxCpCardService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;

public class WxCpCardServiceImpl
implements WxCpCardService {
    protected final Object globalCardApiTicketRefreshLock = new Object();
    private WxCpService mainService;

    public WxCpCardServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public String getCardApiTicket() throws WxErrorException {
        return this.getCardApiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCardApiTicket(boolean forceRefresh) throws WxErrorException {
        WxCpConfigStorage wxCpConfigStorage = this.mainService.getWxCpConfigStorage();
        if (wxCpConfigStorage.isCardApiTicketExpired() || StringUtils.isBlank((CharSequence)wxCpConfigStorage.getAccessToken())) {
            Object object = this.globalCardApiTicketRefreshLock;
            synchronized (object) {
                if (wxCpConfigStorage.isCardApiTicketExpired()) {
                    String responseContent = this.mainService.get("https://qyapi.weixin.qq.com/cgi-bin/ticket/get?type=wx_card", null);
                    JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                    JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                    String cardApiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    wxCpConfigStorage.updateCardApiTicket(cardApiTicket, expiresInSeconds);
                }
            }
        }
        return wxCpConfigStorage.getCardApiTicket();
    }

    @Override
    public WxCardApiSignature createCardApiSignature() throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String cardApiTicket = this.getCardApiTicket();
        String signature = SHA1.gen((String[])new String[]{cardApiTicket, this.mainService.getWxCpConfigStorage().getCorpId(), timestamp + "", noncestr, "INVOICE"});
        WxCardApiSignature cardApiSignature = new WxCardApiSignature();
        cardApiSignature.setTimestamp(Long.valueOf(timestamp));
        cardApiSignature.setNonceStr(noncestr);
        cardApiSignature.setSignature(signature);
        cardApiSignature.setCardType("INVOICE");
        cardApiSignature.setAppId(this.mainService.getWxCpConfigStorage().getCorpId());
        return cardApiSignature;
    }
}

