/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URLEncoder;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.http.WxCustomParamUtil;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUserDetail;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpOAuth2ServiceImpl
implements WxCpOAuth2Service {
    private static final Logger logger = LoggerFactory.getLogger(WxCpOAuth2ServiceImpl.class);
    private WxCpService mainService;

    public WxCpOAuth2ServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }

    @Override
    public String buildAuthorizationUrl(String state) {
        return this.buildAuthorizationUrl(this.mainService.getWxCpConfigStorage().getOauth2redirectUri(), state);
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state) {
        return this.buildAuthorizationUrl(redirectUri, state, "snsapi_base");
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state, String scope) {
        if ("1".equals(WxCustomParamUtil.casType)) {
            StringBuilder url = new StringBuilder(WxCustomParamUtil.casUrl + "/open/oauth2/wechat-login-url?");
            url.append("clientId=").append(WxCustomParamUtil.clientId);
            url.append("&callback=").append(URIUtil.encodeURIComponent((String)redirectUri));
            url.append("&state=");
            url.append("&redirect=true");
            return url.toString();
        }
        if ("1".equals(WxCustomParamUtil.FRNYJTType)) {
            StringBuilder url = new StringBuilder(this.mainService.getWxCpConfigStorage().getApiUrlPrefix() + "/sso/authz/oauth/authorize?");
            url.append("client_id=").append("02e823b074ca49449483797804545e8e");
            url.append("&response_type=code");
            url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectUri));
            url.append("&approval_prompt=auto");
            logger.info("\u83b7\u53d6code\u7684URL\u7684\u503c\u4e3a=============" + url);
            return url.toString();
        }
        String oauth2Uri = this.mainService.getWxCpConfigStorage().getOauth2Uri();
        if (StringUtils.isNotBlank((CharSequence)oauth2Uri)) {
            oauth2Uri = oauth2Uri.replace("&amp;", "&").replace("#appid#", this.mainService.getWxCpConfigStorage().getCorpId()).replace("#redirect_uri#", URIUtil.encodeURIComponent((String)redirectUri)).replace("#agentid#", StringUtils.defaultIfBlank((CharSequence)this.mainService.getWxCpConfigStorage().getWxAgentIdStr(), (CharSequence)(this.mainService.getWxCpConfigStorage().getAgentId() + ""))).replace("#scope#", scope);
            if (state != null) {
                oauth2Uri = oauth2Uri.replace("#state#", state);
            }
            return oauth2Uri;
        }
        StringBuilder url = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize?");
        url.append("appid=").append(this.mainService.getWxCpConfigStorage().getCorpId());
        url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectUri));
        url.append("&response_type=code");
        url.append("&scope=").append(scope);
        url.append("&agentid=").append(this.mainService.getWxCpConfigStorage().getAgentId());
        if (state != null) {
            url.append("&state=").append(state);
        }
        url.append("#wechat_redirect");
        return url.toString();
    }

    @Override
    public String[] getUserInfo(String code) throws WxErrorException {
        return this.getUserInfo(this.mainService.getWxCpConfigStorage().getAgentId(), code);
    }

    @Override
    public String[] getUserInfo(Integer agentId, String code) throws WxErrorException {
        String url = null;
        String responseText = null;
        JsonElement je = null;
        JsonObject jo = null;
        if ("1".equals(WxCustomParamUtil.casType)) {
            url = String.format(WxCustomParamUtil.casUrlInfo + "/open/oauth2/user-info?code=%s", code);
            responseText = this.mainService.get(url, null);
            logger.info("\u83b7\u53d6\u5230\u7684\u4eba\u5458\u6570\u636e\u662f==================" + new Gson().toJson((Object)responseText));
            je = new JsonParser().parse(responseText);
            jo = je.getAsJsonObject();
            return new String[]{GsonHelper.getString((JsonObject)jo, (String)"userId"), GsonHelper.getString((JsonObject)jo, (String)"deviceId"), GsonHelper.getString((JsonObject)jo, (String)"openId"), GsonHelper.getString((JsonObject)jo, (String)"gender"), GsonHelper.getString((JsonObject)jo, (String)"email"), GsonHelper.getString((JsonObject)jo, (String)"name"), GsonHelper.getString((JsonObject)jo, (String)"mobile")};
        }
        if ("1".equals(this.mainService.getWxCpConfigStorage().getWxApiType())) {
            url = String.format("https://qyapi.weixin.qq.com/cgi-bin/getuserinfo?code=%s&agentid=%d", code, agentId);
        } else if ("2".equals(this.mainService.getWxCpConfigStorage().getWxApiType())) {
            url = String.format("https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?code=%s", code);
        } else {
            if ("1".equals(WxCustomParamUtil.FRNYJTType)) {
                StringBuilder urlFRNYJ = new StringBuilder(this.mainService.getWxCpConfigStorage().getApiUrlPrefix() + "/sso/authz/oauth/token?");
                urlFRNYJ.append("grant_type=authorization_code");
                urlFRNYJ.append("&code=").append(code);
                urlFRNYJ.append("&client_id=").append(WxCustomParamUtil.FRNYJTClientID);
                urlFRNYJ.append("&client_secret=").append(WxCustomParamUtil.FRNYJTClientSecret);
                String encode = null;
                try {
                    encode = URLEncoder.encode(WxCustomParamUtil.FRNYJTRedirectUri, "UTF-8");
                }
                catch (Exception e) {
                    logger.error("FRNYJTRedirectUri\u7f16\u7801\u5931\u8d25", (Throwable)e);
                }
                urlFRNYJ.append("&redirect_uri=").append(encode);
                responseText = this.mainService.post(urlFRNYJ.toString(), null);
                je = new JsonParser().parse(responseText);
                jo = je.getAsJsonObject();
                String accessToken = jo.get("access_token").getAsString();
                url = String.format(this.mainService.getWxCpConfigStorage().getApiUrlPrefix() + "/sso/api/oauth/v20/userinfo?access_token=%s", accessToken);
                responseText = this.mainService.post(url, null);
                je = new JsonParser().parse(responseText);
                jo = je.getAsJsonObject();
                return new String[]{GsonHelper.getString((JsonObject)jo, (String)"uid"), GsonHelper.getString((JsonObject)jo, (String)"realname"), GsonHelper.getString((JsonObject)jo, (String)"username")};
            }
            url = String.format("https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?code=%s&agentid=%d", code, agentId);
        }
        responseText = this.mainService.get(url, null);
        je = new JsonParser().parse(responseText);
        jo = je.getAsJsonObject();
        return new String[]{GsonHelper.getString((JsonObject)jo, (String)"UserId"), GsonHelper.getString((JsonObject)jo, (String)"DeviceId"), GsonHelper.getString((JsonObject)jo, (String)"OpenId"), GsonHelper.getString((JsonObject)jo, (String)"user_ticket"), GsonHelper.getString((JsonObject)jo, (String)"expires_in"), GsonHelper.getString((JsonObject)jo, (String)"external_userid")};
    }

    @Override
    public WxCpUserDetail getUserDetail(String userTicket) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserdetail";
        JsonObject param = new JsonObject();
        param.addProperty("user_ticket", userTicket);
        String responseText = this.mainService.post(url, param.toString());
        return (WxCpUserDetail)WxCpGsonBuilder.create().fromJson(responseText, WxCpUserDetail.class);
    }
}

