/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.weaver.sdk.weixin.cp.api.WxCpCheckinService;
import com.weaver.sdk.weixin.cp.api.WxCpExternalContactService;
import com.weaver.sdk.weixin.cp.api.WxCpMsgAuditService;
import com.weaver.sdk.weixin.cp.api.impl.WxCpCheckinServiceImpl;
import com.weaver.sdk.weixin.cp.api.impl.WxCpExternalContactServiceImpl;
import com.weaver.sdk.weixin.cp.api.impl.WxCpMsgAuditServiceImpl;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSession;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.WxCustomParamUtil;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import me.chanjar.weixin.cp.api.WxCpAgentService;
import me.chanjar.weixin.cp.api.WxCpCalendarService;
import me.chanjar.weixin.cp.api.WxCpCardService;
import me.chanjar.weixin.cp.api.WxCpChatService;
import me.chanjar.weixin.cp.api.WxCpDepartmentService;
import me.chanjar.weixin.cp.api.WxCpMediaService;
import me.chanjar.weixin.cp.api.WxCpMenuService;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.WxCpTagService;
import me.chanjar.weixin.cp.api.WxCpTaskCardService;
import me.chanjar.weixin.cp.api.WxCpUserService;
import me.chanjar.weixin.cp.api.impl.WxCpAgentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpCalendarServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpCardServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpChatServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpDepartmentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMediaServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMenuServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOAuth2ServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpTagServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpTaskCardServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpUserServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpMessage;
import me.chanjar.weixin.cp.bean.WxCpMessageForConnect;
import me.chanjar.weixin.cp.bean.WxCpMessageSendResult;
import me.chanjar.weixin.cp.bean.WxCpMessageSendResultForConnect;
import me.chanjar.weixin.cp.bean.WxCpWorkBench;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WxCpServiceAbstractImpl<H, P>
implements WxCpService,
RequestHttp<H, P> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxCpUserService userService = new WxCpUserServiceImpl(this);
    private WxCpChatService chatService = new WxCpChatServiceImpl(this);
    private WxCpDepartmentService departmentService = new WxCpDepartmentServiceImpl(this);
    private WxCpMediaService mediaService = new WxCpMediaServiceImpl(this);
    private WxCpMenuService menuService = new WxCpMenuServiceImpl(this);
    private WxCpOAuth2Service oauth2Service = new WxCpOAuth2ServiceImpl(this);
    private WxCpTagService tagService = new WxCpTagServiceImpl(this);
    private WxCpAgentService agentService = new WxCpAgentServiceImpl(this);
    private WxCpCheckinService checkInService = new WxCpCheckinServiceImpl(this);
    private WxCpCardService cardService = new WxCpCardServiceImpl(this);
    private WxCpExternalContactService externalContactService = new WxCpExternalContactServiceImpl(this);
    private WxCpMsgAuditService msgAuditService = new WxCpMsgAuditServiceImpl(this);
    private WxCpTaskCardService taskCardService = new WxCpTaskCardServiceImpl(this);
    private WxCpCalendarService calendarService = new WxCpCalendarServiceImpl(this);
    protected final Object globalAccessTokenRefreshLock = new Object();
    protected final Object globalJsapiTicketRefreshLock = new Object();
    protected final Object globalAgentJsapiTicketRefreshLock = new Object();
    protected WxCpConfigStorage configStorage;
    protected WxSessionManager sessionManager = new StandardSessionManager();
    protected File tmpDirFile;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String msgSignature, String timestamp, String nonce, String data) {
        try {
            return SHA1.gen((String[])new String[]{this.configStorage.getToken(), timestamp, nonce, data}).equals(msgSignature);
        }
        catch (Exception e) {
            this.log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (this.configStorage.isJsapiTicketExpired() || StringUtils.isBlank((CharSequence)this.configStorage.getAccessToken()) || forceRefresh) {
            Object object = this.globalJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isJsapiTicketExpired()) {
                    String url = this.configStorage.getApiUrlPrefix() + "/cgi-bin/get_jsapi_ticket";
                    String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, null);
                    JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                    JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                    String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    this.configStorage.updateJsapiTicket(jsapiTicket, expiresInSeconds);
                }
            }
        }
        return this.configStorage.getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        if ("1".equals(this.configStorage.getWxApiType())) {
            try {
                String ticketUrl = this.configStorage.getApiUrlPrefix() + "/cgi-bin/request/get_jsapi_ticket?url=" + URLEncoder.encode(url, "UTF-8");
                String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), ticketUrl, null);
                JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                String timestamp = tmpJsonObject.get("timestamp").getAsString();
                String nonceStr = tmpJsonObject.get("noncestr").getAsString();
                String signature = tmpJsonObject.get("signature").getAsString();
                WxJsapiSignature jsapiSignature = new WxJsapiSignature();
                jsapiSignature.setTimestamp(Long.parseLong(timestamp));
                jsapiSignature.setNonceStr(nonceStr);
                jsapiSignature.setUrl(url);
                jsapiSignature.setSignature(signature);
                jsapiSignature.setAppId(this.configStorage.getCorpId());
                return jsapiSignature;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        } else if ("2".equals(this.configStorage.getWxApiType())) {
            try {
                String ticketUrl = this.configStorage.getApiUrlPrefix() + "/ebchina/get_jsapi_ticket?url=" + URLEncoder.encode(url, "UTF-8");
                String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), ticketUrl, null);
                JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                String timestamp = tmpJsonObject.get("timestamp").getAsString();
                String nonceStr = tmpJsonObject.get("nonceStr").getAsString();
                String signature = tmpJsonObject.get("signature").getAsString();
                WxJsapiSignature jsapiSignature = new WxJsapiSignature();
                jsapiSignature.setTimestamp(Long.parseLong(timestamp));
                jsapiSignature.setNonceStr(nonceStr);
                jsapiSignature.setUrl(url);
                jsapiSignature.setSignature(signature);
                jsapiSignature.setAppId(this.configStorage.getCorpId());
                return jsapiSignature;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setAppId(this.configStorage.getCorpId());
        return jsapiSignature;
    }

    @Override
    public String getAgentJsapiTicket() throws WxErrorException {
        return this.getAgentJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAgentJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (this.configStorage.isAgentJsapiTicketExpired() || StringUtils.isBlank((CharSequence)this.configStorage.getAccessToken()) || forceRefresh) {
            Object object = this.globalAgentJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAgentJsapiTicketExpired()) {
                    String url = this.configStorage.getApiUrlPrefix() + "/cgi-bin/ticket/get?type=agent_config";
                    String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, null);
                    JsonObject jsonObject = new JsonParser().parse(responseContent).getAsJsonObject();
                    this.configStorage.updateAgentJsapiTicket(jsonObject.get("ticket").getAsString(), jsonObject.get("expires_in").getAsInt());
                }
            }
        }
        return this.configStorage.getAgentJsapiTicket();
    }

    @Override
    public WxJsapiSignature createAgentJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getAgentJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setAppId(this.configStorage.getCorpId());
        return jsapiSignature;
    }

    @Override
    public void setWorkBench(WxCpWorkBench wxCpWorkBench) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/agent/set_workbench_data";
        this.post(url, wxCpWorkBench.toJson());
    }

    @Override
    public String setWorkBenchForCreate(String workBench) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/agent/set_workbench_template";
        String responseContent = this.post(url, workBench);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("errmsg").getAsString();
    }

    @Override
    public void updateTempCardMsg(String params) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/update_template_card";
        this.post(url, params);
    }

    @Override
    public WxCpMessageSendResult messageSend(WxCpMessage message) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send";
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.getWxCpConfigStorage().getAgentId());
        }
        return WxCpMessageSendResult.fromJson(this.post(url, message.toJson()));
    }

    @Override
    public String messageSendFRNYJT(JsonObject jsonObject) throws WxErrorException {
        String url = this.configStorage.getApiUrlPrefix() + "/cgi/open/external/todo/msg/send";
        String response = this.post(url, jsonObject.toString());
        return response;
    }

    @Override
    public String FRNYWXTodoSend(JsonObject jsonObject) throws WxErrorException {
        String url = this.configStorage.getApiUrlPrefix() + "/cgi/open/external/todo/list/add";
        String post = this.post(url, jsonObject.toString());
        return post;
    }

    @Override
    public String updateFRNYWXTodo(String params) throws WxErrorException {
        String url = this.configStorage.getApiUrlPrefix() + "/cgi/open/external/todo/list/flow";
        HttpPut httpPut = new HttpPut(url);
        if (params != null) {
            StringEntity entity = new StringEntity(params, Consts.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        httpPut.setHeader("Content-Type", "application/json");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String accessToken = this.getAccessToken(false);
        httpPut.setHeader("Authorization", accessToken);
        httpPut.setHeader("Content-Type", "application/json");
        try {
            String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)httpClient.execute((HttpUriRequest)httpPut));
            return responseContent;
        }
        catch (Exception e) {
            return "0";
        }
    }

    @Override
    public void messageRecall(String msgId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/recall";
        JsonObject params = new JsonObject();
        if (this.configStorage.getApiUrlPrefix() != null && !this.configStorage.getApiUrlPrefix().contains("qyapi.weixin.qq.com")) {
            if (StringUtils.isNotBlank((CharSequence)WxCustomParamUtil.urlType) && "0".equals(WxCustomParamUtil.urlType)) {
                url = "https://qyapi.weixin.qq.com/cgi-bin/message/recall";
                params.addProperty("msgid", msgId);
            } else {
                url = "https://qyapi.weixin.qq.com/cgi-bin/message/revoke";
                params.addProperty("jobid", msgId);
            }
        } else {
            params.addProperty("msgid", msgId);
        }
        this.post(url, params.toString());
    }

    @Override
    public WxCpMessageSendResultForConnect messageSendForConnect(WxCpMessageForConnect message) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/linkedcorp/message/send";
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.getWxCpConfigStorage().getAgentId());
        }
        return WxCpMessageSendResultForConnect.fromJson(this.post(url, message.toJson()));
    }

    @Override
    public String[] getCallbackIp() throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/getcallbackip";
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonArray jsonArray = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ips = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            ips[i] = jsonArray.get(i).getAsString();
        }
        return ips;
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        String corpSecret = this.configStorage.getCorpSecret();
        if ("1".equals(WxCustomParamUtil.casType) && uri.contains("user-info")) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                WxError error = e.getError();
                this.log.info("\u8bf7\u6c42\u51fa\u73b0\u4e86\u5f02\u5e38=====" + error);
            }
        }
        if (this.configStorage.getSecretOrTokenError("corpid:" + this.configStorage.getCorpId() + "_secret:" + corpSecret) > 0) {
            this.log.error("\u4f01\u4e1a\u3010" + this.configStorage.getCorpId() + "\u3011\u7684Secret\u3010" + corpSecret + "\u3011\u9519\u8bef\uff0c\u7981\u6b62\u8c03\u7528\u63a5\u53e3");
            throw new RuntimeException("Secret\u9519\u8bef\uff0c\u7981\u6b62\u8c03\u7528\u63a5\u53e3");
        }
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                String accessToken = this.configStorage.getAccessToken();
                if (this.configStorage.getSecretOrTokenError("accessToken:" + accessToken) > 0) {
                    this.log.error("Token\u3010" + accessToken + "\u3011\u9519\u8bef\uff0c\u7981\u6b62\u8c03\u7528\u63a5\u53e3");
                    throw new RuntimeException("Token\u9519\u8bef\uff0c\u7981\u6b62\u8c03\u7528\u63a5\u53e3");
                }
                WxError error = e.getError();
                if (retryTimes + 1 > this.maxRetryTimes) {
                    this.configStorage.setSecretOrTokenError("accessToken:" + accessToken);
                    this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (error.getErrorCode() == 40001 && uri.indexOf("/cgi-bin/get_jsapi_ticket") == -1) {
                    this.configStorage.setSecretOrTokenError("corpid:" + this.configStorage.getCorpId() + "_secret:" + corpSecret);
                    throw e;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if ("1".equals(WxCustomParamUtil.casType) && uri.contains("user-info")) {
            try {
                Object result = executor.execute(uri, data);
                this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uri, dataForLog, result});
                return (T)result;
            }
            catch (IOException e) {
                this.log.info("CAS\u63a5\u53e3\u8bf7\u6c42\u4e0d\u901a\u6216\u62a5\u9519\uff0c\u65e0\u4eba\u5458\u4fe1\u606f\u8fd4\u56de==========" + e);
                return null;
            }
        }
        if (uri.contains("access_token=") && !"1".equals(WxCustomParamUtil.FRNYJTType)) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String uriWithAccessToken = uri;
        if (!uri.contains("access_token=") && !uri.contains("authorization_code")) {
            String accessToken = this.getAccessToken(false);
            uriWithAccessToken = uri.contains("cgi/open/external/todo") ? uri + (uri.contains("?") ? "&" : "?") + "token=" + accessToken : uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        }
        try {
            Object result = executor.execute(uriWithAccessToken, data);
            this.log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40014) {
                this.configStorage.expireAccessToken();
                return this.execute(executor, uri, data);
            }
            if (error.getErrorCode() == 48009) {
                this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                error.setErrorMsg("\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u5bc6\u94a5\u6743\u9650\u53d8\u66f4\u89e3\u51b3\u65b9\u6848\u53c2\u89c1: https://yq.weaver.com.cn/eb/qa/view/#/question/8e43609bffb64a919d0ef9863f5eaaa6?");
                error.setErrorMsgEn("");
                throw new WxErrorException(error, (Throwable)e);
            }
            if (error.getErrorCode() != 0) {
                this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setWxCpConfigStorage(WxCpConfigStorage wxConfigProvider) {
        this.configStorage = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxSession getSession(String id) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id);
    }

    @Override
    public WxSession getSession(String id, boolean create) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id, create);
    }

    @Override
    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public String replaceParty(String mediaId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/replaceparty";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(url, jsonObject.toString());
    }

    @Override
    public String replaceUser(String mediaId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/replaceuser";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(url, jsonObject.toString());
    }

    @Override
    public String getTaskResult(String joinId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/getresult?jobid=" + joinId;
        return this.get(url, null);
    }

    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public WxCpUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxCpChatService getChatService() {
        return this.chatService;
    }

    @Override
    public WxCpDepartmentService getDepartmentService() {
        return this.departmentService;
    }

    @Override
    public WxCpMediaService getMediaService() {
        return this.mediaService;
    }

    @Override
    public WxCpMenuService getMenuService() {
        return this.menuService;
    }

    @Override
    public WxCpOAuth2Service getOauth2Service() {
        return this.oauth2Service;
    }

    @Override
    public WxCpTagService getTagService() {
        return this.tagService;
    }

    @Override
    public WxCpAgentService getAgentService() {
        return this.agentService;
    }

    @Override
    public WxCpCalendarService getCalendarService() {
        return this.calendarService;
    }

    @Override
    public WxCpCheckinService getCheckInService() {
        return this.checkInService;
    }

    @Override
    public WxCpCardService getCardService() {
        return this.cardService;
    }

    @Override
    public WxCpExternalContactService getExternalContactService() {
        return this.externalContactService;
    }

    @Override
    public WxCpMsgAuditService getMsgAuditService() {
        return this.msgAuditService;
    }

    @Override
    public WxCpTaskCardService getTaskCardService() {
        return this.taskCardService;
    }

    @Override
    public RequestHttp<?, ?> getRequestHttp() {
        return this;
    }

    @Override
    public void setUserService(WxCpUserService userService) {
        this.userService = userService;
    }

    @Override
    public void setChatService(WxCpChatService chatService) {
        this.chatService = chatService;
    }

    @Override
    public void setDepartmentService(WxCpDepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @Override
    public void setMediaService(WxCpMediaService mediaService) {
        this.mediaService = mediaService;
    }

    @Override
    public void setMenuService(WxCpMenuService menuService) {
        this.menuService = menuService;
    }

    @Override
    public void setOauth2Service(WxCpOAuth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    @Override
    public void setTagService(WxCpTagService tagService) {
        this.tagService = tagService;
    }

    @Override
    public void setAgentService(WxCpAgentService agentService) {
        this.agentService = agentService;
    }

    @Override
    public void setCheckInService(WxCpCheckinService checkInService) {
        this.checkInService = checkInService;
    }

    @Override
    public void setCardService(WxCpCardService cardService) {
        this.cardService = cardService;
    }

    @Override
    public void setExternalContactService(WxCpExternalContactService externalContactService) {
        this.externalContactService = externalContactService;
    }

    @Override
    public void setMsgAuditService(WxCpMsgAuditService msgAuditService) {
        this.msgAuditService = msgAuditService;
    }

    @Override
    public void setTaskCardService(WxCpTaskCardService taskCardService) {
        this.taskCardService = taskCardService;
    }
}

