/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.weaver.sdk.weixin.cp.api.impl.WeaverWxCpServiceAbstractImpl;
import java.io.IOException;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.WxAuthUtil;
import me.chanjar.weixin.common.util.http.WxCustomParamUtil;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class WxCpServiceApacheHttpClientImpl
extends WeaverWxCpServiceAbstractImpl<CloseableHttpClient, HttpHost> {
    protected CloseableHttpClient httpClient;
    protected HttpHost httpProxy;

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.APACHE_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (this.configStorage.isAccessTokenExpired() || StringUtils.isBlank((CharSequence)this.configStorage.getAccessToken()) || forceRefresh) {
            Object object = this.globalAccessTokenRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAccessTokenExpired() || StringUtils.isBlank((CharSequence)this.configStorage.getAccessToken()) || forceRefresh) {
                    String url = this.configStorage.getApiUrlPrefix() + "/cgi-bin/gettoken?corpid=" + this.configStorage.getCorpId() + "&corpsecret=" + this.configStorage.getCorpSecret();
                    if ("1".equals(WxCustomParamUtil.FRNYJTType)) {
                        url = this.configStorage.getApiUrlPrefix() + "/cgi/open/external/token?client_id=" + this.configStorage.getAgentId() + "&client_secret=" + this.configStorage.getCorpSecret();
                        HttpGet httpGet = new HttpGet(url);
                        WxAuthUtil.setGetHeader((HttpGet)httpGet);
                        try {
                            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
                            String resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                            this.log.info("\u83b7\u53d6token\u7684\u8fd4\u56de\u503c\u4e3a=======" + new Gson().toJson((Object)resultContent));
                            JsonParser jp = new JsonParser();
                            JsonElement parse = jp.parse(resultContent);
                            JsonElement tokenElement = parse.getAsJsonObject().get("token");
                            this.configStorage.updateAccessToken(tokenElement.getAsString(), Long.valueOf(System.currentTimeMillis() + 3600000L).intValue());
                            return this.configStorage.getAccessToken();
                        }
                        catch (Exception e) {
                            this.log.info("\u83b7\u53d6token\u4fe1\u606f\u5f02\u5e38\u4e86");
                        }
                    }
                    if ("2".equals(this.configStorage.getWxApiType())) {
                        url = this.configStorage.getApiUrlPrefix() + "/gettoken?agentid=" + this.configStorage.getWxAgentIdStr() + "&secret=" + this.configStorage.getCorpSecret();
                    }
                    if (this.configStorage.getApiUrlPrefix().equals(WxCustomParamUtil.isVankeType)) {
                        int index = this.configStorage.getCorpSecret().lastIndexOf("-");
                        String vankAppId = this.configStorage.getCorpSecret().substring(index + 1);
                        String vankSecret = this.configStorage.getCorpSecret().substring(0, index);
                        url = this.configStorage.getApiUrlPrefix() + "/token/get-token?appId=" + vankAppId + "&secret=" + vankSecret;
                    }
                    try {
                        HttpGet httpGet = new HttpGet(url);
                        if (this.httpProxy != null) {
                            RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
                            httpGet.setConfig(config);
                        }
                        WxAuthUtil.setGetHeader((HttpGet)httpGet);
                        String resultContent = null;
                        try (CloseableHttpClient httpclient = this.getRequestHttpClient();
                             CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                            resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                            this.log.info("\u8bf7\u6c42token,\u83b7\u53d6\u7684\u8fd4\u56de\u503c\u662f==========" + resultContent);
                        }
                        finally {
                            httpGet.releaseConnection();
                        }
                        if (this.configStorage.getApiUrlPrefix().equals(WxCustomParamUtil.isVankeType)) {
                            JsonParser jp = new JsonParser();
                            JsonElement parse = jp.parse(resultContent);
                            if (0 == Integer.valueOf(parse.getAsJsonObject().get("errcode").toString())) {
                                JsonElement token = parse.getAsJsonObject().get("data").getAsJsonObject().get("token");
                                this.log.info("\u83b7\u53d6\u5230\u7684token\u4e3a:{},\u8f6c\u6362\u540e\u7684token\u4e3a:{}", (Object)token, (Object)token.getAsString());
                                JsonElement expiresIn = parse.getAsJsonObject().get("data").getAsJsonObject().get("expiresIn");
                                this.configStorage.updateAccessToken(token.getAsString(), Integer.valueOf(expiresIn.getAsString()));
                            } else {
                                this.log.info("\u83b7\u53d6token\u5931\u8d25,\u9519\u8bef\u7801:{},\u62a5\u9519\u8be6\u7ec6\u4fe1\u606f:{}", (Object)parse.getAsJsonObject().get("errcode"), (Object)parse.getAsJsonObject().get("errmsg"));
                            }
                        } else {
                            WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
                            if (error.getErrorCode() != 0) {
                                throw new WxErrorException(error);
                            }
                            WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                            this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        ApacheHttpClientBuilder apacheHttpClientBuilder = this.configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(this.configStorage.getHttpProxyHost()).httpProxyPort(this.configStorage.getHttpProxyPort()).httpProxyUsername(this.configStorage.getHttpProxyUsername()).httpProxyPassword(this.configStorage.getHttpProxyPassword());
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

