/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.weaver.sdk.weixin.cp.api.impl.WeaverWxCpServiceAbstractImpl;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.JoddHttp;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;

public class WxCpServiceJoddHttpImpl
extends WeaverWxCpServiceAbstractImpl<HttpConnectionProvider, ProxyInfo> {
    protected HttpConnectionProvider httpClient;
    protected ProxyInfo httpProxy;

    public HttpConnectionProvider getRequestHttpClient() {
        return this.httpClient;
    }

    public ProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.JODD_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (this.configStorage.isAccessTokenExpired() || StringUtils.isBlank((CharSequence)this.configStorage.getAccessToken()) || forceRefresh) {
            Object object = this.globalAccessTokenRefreshLock;
            synchronized (object) {
                if (this.configStorage.isAccessTokenExpired() || StringUtils.isBlank((CharSequence)this.configStorage.getAccessToken()) || forceRefresh) {
                    String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?&corpid=" + this.configStorage.getCorpId() + "&corpsecret=" + this.configStorage.getCorpSecret();
                    HttpRequest request = HttpRequest.get((String)url);
                    if (this.httpProxy != null) {
                        this.httpClient.useProxy(this.httpProxy);
                    }
                    request.withConnectionProvider(this.httpClient);
                    HttpResponse response = request.send();
                    String resultContent = response.bodyText();
                    WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
                    if (error.getErrorCode() != 0) {
                        throw new WxErrorException(error);
                    }
                    WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                    this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
                }
            }
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort(), this.configStorage.getHttpProxyUsername(), this.configStorage.getHttpProxyPassword());
        }
        this.httpClient = JoddHttp.httpConnectionProvider;
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

