/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.cp.bean.WxCpMessage;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.taskcard.TaskCardButton;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardButton;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardHorizontalContent;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardJumpList;
import org.apache.commons.lang3.StringUtils;

public class WxCpMessageGsonAdapter
implements JsonSerializer<WxCpMessage> {
    public JsonElement serialize(WxCpMessage message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject buttonJson;
        JsonArray buttonJsonArray;
        JsonObject titleAndDesc;
        JsonArray mainTitle;
        JsonObject templateCard;
        JsonObject articleJson;
        JsonArray articleJsonArray;
        JsonObject newsJsonObject;
        JsonObject image;
        JsonObject text;
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("agentid", (Number)message.getAgentId());
        if (StringUtils.isNotBlank((CharSequence)message.getToUser())) {
            messageJson.addProperty("touser", message.getToUser());
        }
        messageJson.addProperty("msgtype", message.getMsgType());
        if (StringUtils.isNotBlank((CharSequence)message.getToParty())) {
            messageJson.addProperty("toparty", message.getToParty());
        }
        if (StringUtils.isNotBlank((CharSequence)message.getToTag())) {
            messageJson.addProperty("totag", message.getToTag());
        }
        if ("text".equals(message.getMsgType())) {
            if ("1".equals(message.getApiType())) {
                messageJson.addProperty("description", message.getContent());
            } else {
                text = new JsonObject();
                text.addProperty("content", message.getContent());
                messageJson.add("text", (JsonElement)text);
            }
        }
        if ("textcard".equals(message.getMsgType())) {
            if ("1".equals(message.getApiType())) {
                messageJson.addProperty("title", message.getTitle());
                messageJson.addProperty("description", message.getDescription());
                messageJson.addProperty("url", message.getUrl());
                messageJson.addProperty("btntxt", message.getBtnTxt());
            } else {
                text = new JsonObject();
                text.addProperty("title", message.getTitle());
                text.addProperty("description", message.getDescription());
                text.addProperty("url", message.getUrl());
                text.addProperty("btntxt", message.getBtnTxt());
                messageJson.add("textcard", (JsonElement)text);
            }
        }
        if ("image".equals(message.getMsgType())) {
            image = new JsonObject();
            image.addProperty("media_id", message.getMediaId());
            messageJson.add("image", (JsonElement)image);
        }
        if ("file".equals(message.getMsgType())) {
            image = new JsonObject();
            image.addProperty("media_id", message.getMediaId());
            messageJson.add("file", (JsonElement)image);
        }
        if ("voice".equals(message.getMsgType())) {
            JsonObject voice = new JsonObject();
            voice.addProperty("media_id", message.getMediaId());
            messageJson.add("voice", (JsonElement)voice);
        }
        if (StringUtils.isNotBlank((CharSequence)message.getSafe())) {
            messageJson.addProperty("safe", message.getSafe());
        }
        if ("video".equals(message.getMsgType())) {
            JsonObject video = new JsonObject();
            video.addProperty("media_id", message.getMediaId());
            video.addProperty("thumb_media_id", message.getThumbMediaId());
            video.addProperty("title", message.getTitle());
            video.addProperty("description", message.getDescription());
            messageJson.add("video", (JsonElement)video);
        }
        if ("news".equals(message.getMsgType())) {
            newsJsonObject = new JsonObject();
            articleJsonArray = new JsonArray();
            if ("1".equals(message.getApiType())) {
                for (NewArticle newArticle : message.getArticles()) {
                    articleJson = new JsonObject();
                    articleJson.addProperty("title", newArticle.getTitle());
                    articleJson.addProperty("description", newArticle.getDescription());
                    articleJson.addProperty("url", newArticle.getUrl());
                    articleJson.addProperty("picUrl", newArticle.getPicUrl());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                messageJson.add("article", (JsonElement)articleJsonArray);
            } else {
                for (NewArticle newArticle : message.getArticles()) {
                    articleJson = new JsonObject();
                    articleJson.addProperty("title", newArticle.getTitle());
                    articleJson.addProperty("description", newArticle.getDescription());
                    articleJson.addProperty("url", newArticle.getUrl());
                    articleJson.addProperty("picurl", newArticle.getPicUrl());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
            }
        }
        if ("mpnews".equals(message.getMsgType())) {
            newsJsonObject = new JsonObject();
            if (message.getMediaId() != null) {
                newsJsonObject.addProperty("media_id", message.getMediaId());
            } else {
                articleJsonArray = new JsonArray();
                for (MpnewsArticle mpnewsArticle : message.getMpnewsArticles()) {
                    articleJson = new JsonObject();
                    articleJson.addProperty("title", mpnewsArticle.getTitle());
                    articleJson.addProperty("thumb_media_id", mpnewsArticle.getThumbMediaId());
                    articleJson.addProperty("author", mpnewsArticle.getAuthor());
                    articleJson.addProperty("content_source_url", mpnewsArticle.getContentSourceUrl());
                    articleJson.addProperty("content", mpnewsArticle.getContent());
                    articleJson.addProperty("digest", mpnewsArticle.getDigest());
                    articleJson.addProperty("show_cover_pic", mpnewsArticle.getShowCoverPic());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
            }
            messageJson.add("mpnews", (JsonElement)newsJsonObject);
        }
        if ("template_card".equals(message.getMsgType()) && "button_interaction".equals(message.getCardType())) {
            if ("5".equals(message.getApiType())) {
                messageJson.addProperty("msgtype", "template_card_msg");
            }
            templateCard = new JsonObject();
            templateCard.addProperty("card_type", message.getCardType());
            mainTitle = new JsonArray();
            titleAndDesc = new JsonObject();
            titleAndDesc.addProperty("title", message.getMainTitle().get("title"));
            titleAndDesc.addProperty("desc", message.getMainTitle().get("desc"));
            mainTitle.add((JsonElement)titleAndDesc);
            templateCard.add("main_title", (JsonElement)titleAndDesc);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", message.getCardAction().get("type"));
            jsonObject.addProperty("url", message.getCardAction().get("url"));
            templateCard.add("card_action", (JsonElement)jsonObject);
            templateCard.addProperty("sub_title_text", message.getSubTitleText());
            templateCard.addProperty("task_id", message.getTaskId());
            JsonArray btnArray = new JsonArray();
            for (TemplateCardButton button : message.getButtons()) {
                this.templateBtn2Json(btnArray, button);
            }
            templateCard.add("button_list", (JsonElement)btnArray);
            String templateCardKey = "5".equals(message.getApiType()) ? "template_card_msg" : "template_card";
            messageJson.add(templateCardKey, (JsonElement)templateCard);
        }
        if ("template_card".equals(message.getMsgType()) && "text_notice".equals(message.getCardType())) {
            templateCard = new JsonObject();
            templateCard.addProperty("card_type", message.getCardType());
            mainTitle = new JsonArray();
            titleAndDesc = new JsonObject();
            titleAndDesc.addProperty("title", message.getMainTitle().get("title"));
            titleAndDesc.addProperty("desc", message.getMainTitle().get("desc"));
            mainTitle.add((JsonElement)titleAndDesc);
            templateCard.add("main_title", (JsonElement)titleAndDesc);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", message.getCardAction().get("type"));
            jsonObject.addProperty("url", message.getCardAction().get("url"));
            templateCard.add("card_action", (JsonElement)jsonObject);
            if (message.getEmphasis_content() != null) {
                JsonObject emphasisContent = new JsonObject();
                emphasisContent.addProperty("title", message.getEmphasis_content().get("title"));
                emphasisContent.addProperty("desc", message.getEmphasis_content().get("desc"));
                templateCard.add("emphasis_content", (JsonElement)emphasisContent);
            }
            if (StringUtils.isNotBlank((CharSequence)message.getSubTitleText())) {
                templateCard.addProperty("sub_title_text", message.getSubTitleText());
            }
            templateCard.addProperty("task_id", message.getTaskId());
            JsonArray jlArray = new JsonArray();
            for (TemplateCardJumpList jumpList : message.getJump_list()) {
                this.templateTextNotice(jlArray, jumpList);
            }
            templateCard.add("jump_list", (JsonElement)jlArray);
            messageJson.add("template_card", (JsonElement)templateCard);
        }
        if ("taskcard".equals(message.getMsgType())) {
            text = new JsonObject();
            text.addProperty("title", message.getTitle());
            text.addProperty("description", message.getDescription());
            if (StringUtils.isNotBlank((CharSequence)message.getUrl())) {
                text.addProperty("url", message.getUrl());
            }
            text.addProperty("task_id", message.getTaskId());
            buttonJsonArray = new JsonArray();
            for (TaskCardButton taskCardButton : message.getTaskButtons()) {
                buttonJson = new JsonObject();
                buttonJson.addProperty("key", taskCardButton.getKey());
                buttonJson.addProperty("name", taskCardButton.getName());
                if (StringUtils.isNotBlank((CharSequence)taskCardButton.getReplaceName())) {
                    buttonJson.addProperty("replace_name", taskCardButton.getReplaceName());
                }
                if (StringUtils.isNotBlank((CharSequence)taskCardButton.getColor())) {
                    buttonJson.addProperty("color", taskCardButton.getColor());
                }
                if (taskCardButton.getBold() != null) {
                    buttonJson.addProperty("is_bold", taskCardButton.getBold());
                }
                buttonJsonArray.add((JsonElement)buttonJson);
            }
            text.add("btn", (JsonElement)buttonJsonArray);
            messageJson.add("taskcard", (JsonElement)text);
        }
        if ("interactive_taskcard".equals(message.getMsgType())) {
            text = new JsonObject();
            text.addProperty("title", message.getTitle());
            text.addProperty("description", message.getDescription());
            if (StringUtils.isNotBlank((CharSequence)message.getUrl())) {
                text.addProperty("url", message.getUrl());
            }
            text.addProperty("task_id", message.getTaskId());
            buttonJsonArray = new JsonArray();
            for (TaskCardButton taskCardButton : message.getTaskButtons()) {
                buttonJson = new JsonObject();
                buttonJson.addProperty("key", taskCardButton.getKey());
                buttonJson.addProperty("name", taskCardButton.getName());
                if (StringUtils.isNotBlank((CharSequence)taskCardButton.getColor())) {
                    buttonJson.addProperty("color", taskCardButton.getColor());
                }
                if (taskCardButton.getBold() != null) {
                    buttonJson.addProperty("is_bold", taskCardButton.getBold());
                }
                buttonJsonArray.add((JsonElement)buttonJson);
            }
            text.add("btn", (JsonElement)buttonJsonArray);
            messageJson.add("interactive_taskcard", (JsonElement)text);
        }
        return messageJson;
    }

    private void horizontalContent2Json(JsonArray horizontalContentArray, TemplateCardHorizontalContent horizontalContent) {
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("type", (Number)horizontalContent.getType());
        contentJson.addProperty("keyname", horizontalContent.getKeyname());
        contentJson.addProperty("value", horizontalContent.getValue());
        if (StringUtils.isNotBlank((CharSequence)horizontalContent.getUrl())) {
            contentJson.addProperty("url", horizontalContent.getUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)horizontalContent.getUserid())) {
            contentJson.addProperty("userid", horizontalContent.getUserid());
        }
        horizontalContentArray.add((JsonElement)contentJson);
    }

    private void templateBtn2Json(JsonArray btnArray, TemplateCardButton templateCardButton) {
        JsonObject btnJson = new JsonObject();
        btnJson.addProperty("text", templateCardButton.getText());
        btnJson.addProperty("style", (Number)templateCardButton.getStyle());
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(templateCardButton.getType()))) {
            btnJson.addProperty("type", (Number)templateCardButton.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(templateCardButton.getKey()))) {
            btnJson.addProperty("key", templateCardButton.getKey());
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(templateCardButton.getUrl()))) {
            btnJson.addProperty("url", templateCardButton.getUrl());
        }
        btnArray.add((JsonElement)btnJson);
    }

    private void templateTextNotice(JsonArray jumpList, TemplateCardJumpList templateCardJumpList) {
        JsonObject jlJson = new JsonObject();
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(templateCardJumpList.getType()))) {
            jlJson.addProperty("type", (Number)templateCardJumpList.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(templateCardJumpList.getTitle()))) {
            jlJson.addProperty("title", templateCardJumpList.getTitle());
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(templateCardJumpList.getUrl()))) {
            jlJson.addProperty("url", templateCardJumpList.getUrl());
        }
        jumpList.add((JsonElement)jlJson);
    }
}

