/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.cp.bean.WxCpSchedule;
import me.chanjar.weixin.cp.bean.calendar.ScheduleAttendees;
import me.chanjar.weixin.cp.bean.calendar.ScheduleReminders;

public class WxCpScheduleGsonAdapter
implements JsonDeserializer<WxCpSchedule>,
JsonSerializer<WxCpSchedule> {
    private static final String SCHEDULE = "schedule";

    public WxCpSchedule deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return null;
    }

    public JsonElement serialize(WxCpSchedule wxCpSchedule, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        JsonObject o = new JsonObject();
        if (wxCpSchedule.getOrganizer() != null) {
            o.addProperty("organizer", wxCpSchedule.getOrganizer());
        }
        if (wxCpSchedule.getScheduleId() != null) {
            o.addProperty("schedule_id", wxCpSchedule.getScheduleId());
        }
        if (wxCpSchedule.getStartTime() != null) {
            o.addProperty("start_time", wxCpSchedule.getStartTime());
        }
        if (wxCpSchedule.getEndTime() != null) {
            o.addProperty("end_time", wxCpSchedule.getEndTime());
        }
        if (wxCpSchedule.getSummary() != null) {
            o.addProperty("summary", wxCpSchedule.getSummary());
        }
        if (wxCpSchedule.getDescription() != null) {
            o.addProperty("description", wxCpSchedule.getDescription());
        }
        if (wxCpSchedule.getCalId() != null) {
            o.addProperty("cal_id", wxCpSchedule.getCalId());
        }
        if (wxCpSchedule.getLocation() != null) {
            o.addProperty("location", wxCpSchedule.getLocation());
        }
        if (wxCpSchedule.getReminders() != null) {
            JsonObject json = new JsonObject();
            ScheduleReminders reminders = wxCpSchedule.getReminders();
            if (reminders.getIs_remind() != null) {
                JsonArray array;
                JsonParser parser;
                String substring;
                json.addProperty("is_remind", (Number)reminders.getIs_remind());
                json.addProperty("remind_before_event_secs", (Number)reminders.getRemind_before_event_secs());
                json.addProperty("is_repeat", (Number)reminders.getIs_repeat());
                json.addProperty("repeat_type", (Number)reminders.getRepeat_type());
                json.addProperty("repeat_until", reminders.getRepeat_until());
                json.addProperty("is_custom_repeat", (Number)reminders.getIs_custom_repeat());
                json.addProperty("repeat_interval", (Number)reminders.getRepeat_interval());
                if (reminders.getRepeat_day_of_week() != null) {
                    Integer[] repeat_day_of_week = reminders.getRepeat_day_of_week();
                    String dayOfWeek = "[";
                    for (int i = 0; i < repeat_day_of_week.length; ++i) {
                        dayOfWeek = dayOfWeek + repeat_day_of_week[i] + ",";
                    }
                    substring = dayOfWeek.substring(0, dayOfWeek.length() - 1);
                    substring = substring + "]";
                    parser = new JsonParser();
                    array = parser.parse(substring).getAsJsonArray();
                    json.add("repeat_day_of_week", (JsonElement)array);
                }
                if (reminders.getRepeat_day_of_month() != null) {
                    Integer[] repeat_day_of_month = reminders.getRepeat_day_of_month();
                    String dayOfMonth = "[";
                    for (int i = 0; i < repeat_day_of_month.length; ++i) {
                        dayOfMonth = dayOfMonth + repeat_day_of_month[i] + ",";
                    }
                    substring = dayOfMonth.substring(0, dayOfMonth.length() - 1);
                    substring = substring + "]";
                    parser = new JsonParser();
                    array = parser.parse(substring).getAsJsonArray();
                    json.add("repeat_day_of_month", (JsonElement)array);
                }
            }
            o.add("reminders", (JsonElement)json);
        }
        if (wxCpSchedule.getAttendees().size() > 0) {
            JsonArray attrsJsonArray = new JsonArray();
            for (ScheduleAttendees attr : wxCpSchedule.getAttendees()) {
                JsonObject attrJson = new JsonObject();
                attrJson.addProperty("userid", attr.getUserid());
                attrsJsonArray.add((JsonElement)attrJson);
            }
            o.add("attendees", (JsonElement)attrsJsonArray);
        }
        jsonObject.add(SCHEDULE, (JsonElement)o);
        return jsonObject;
    }
}

