/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.bean.Gender;
import me.chanjar.weixin.cp.bean.WxCpUser;
import org.apache.commons.lang3.StringUtils;

public class WxCpUserGsonAdapter
implements JsonDeserializer<WxCpUser>,
JsonSerializer<WxCpUser> {
    private static final String EXTERNAL_PROFILE = "external_profile";
    private static final String EXTERNAL_ATTR = "external_attr";

    public WxCpUser deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject asJsonObject;
        int i;
        JsonObject o = json.getAsJsonObject();
        WxCpUser user = new WxCpUser();
        if (o.get("department") != null) {
            JsonArray departJsonArray = o.get("department").getAsJsonArray();
            Long[] departIds = new Long[departJsonArray.size()];
            i = 0;
            for (JsonElement jsonElement : departJsonArray) {
                departIds[i++] = jsonElement.getAsLong();
            }
            user.setDepartIds(departIds);
        }
        if (o.get("main_department") != null) {
            user.setMainDepartId(o.get("main_department").getAsLong());
        }
        if (o.get("order") != null) {
            JsonArray orderJsonArray = o.get("order").getAsJsonArray();
            Long[] orders = new Long[orderJsonArray.size()];
            i = 0;
            for (JsonElement jsonElement : orderJsonArray) {
                orders[i++] = jsonElement.getAsLong();
            }
            user.setOrders(orders);
        }
        if (o.get("is_leader_in_dept") != null) {
            JsonArray isLeaderInDeptJsonArray = o.get("is_leader_in_dept").getAsJsonArray();
            Integer[] isLeaderInDepts = new Integer[isLeaderInDeptJsonArray.size()];
            i = 0;
            for (JsonElement jsonElement : isLeaderInDeptJsonArray) {
                isLeaderInDepts[i++] = jsonElement.getAsInt();
            }
            user.setIsLeaderInDept(isLeaderInDepts);
        }
        try {
            if (o.get("direct_leader") != null) {
                JsonArray direct_leader = o.get("direct_leader").getAsJsonArray();
                String[] directArray = new String[direct_leader.size()];
                i = 0;
                for (JsonElement jsonElement : direct_leader) {
                    directArray[i] = jsonElement.getAsString();
                }
                user.setDirect_leader(directArray);
            }
        }
        catch (Exception direct_leader) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"userid"))) {
            user.setUserId(GsonHelper.getString((JsonObject)o, (String)"userid"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"name"))) {
            user.setName(GsonHelper.getString((JsonObject)o, (String)"name"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"position"))) {
            user.setPosition(GsonHelper.getString((JsonObject)o, (String)"position"));
        }
        if (o.get("positions") != null) {
            JsonArray posJsonArray = o.get("positions").getAsJsonArray();
            String[] positions = new String[posJsonArray.size()];
            i = 0;
            for (JsonElement e : posJsonArray) {
                positions[i++] = e.getAsString();
            }
            user.setPositions(positions);
        }
        user.setMobile(GsonHelper.getString((JsonObject)o, (String)"mobile"));
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"gender"))) {
            user.setGender(Gender.fromCode(GsonHelper.getString((JsonObject)o, (String)"gender")));
        }
        user.setEmail(GsonHelper.getString((JsonObject)o, (String)"email"));
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"biz_mail"))) {
            user.setBizMail(GsonHelper.getString((JsonObject)o, (String)"biz_mail"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"avatar"))) {
            user.setAvatar(GsonHelper.getString((JsonObject)o, (String)"avatar"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"avatar_mediaid"))) {
            user.setAvatarMediaId(GsonHelper.getString((JsonObject)o, (String)"avatar_mediaid"));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(GsonHelper.getInteger((JsonObject)o, (String)"status")))) {
            user.setStatus(GsonHelper.getInteger((JsonObject)o, (String)"status"));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(GsonHelper.getInteger((JsonObject)o, (String)"enable")))) {
            user.setEnable(GsonHelper.getInteger((JsonObject)o, (String)"enable"));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(GsonHelper.getInteger((JsonObject)o, (String)"hide_mobile")))) {
            user.setHideMobile(GsonHelper.getInteger((JsonObject)o, (String)"hide_mobile"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"telephone"))) {
            user.setTelephone(GsonHelper.getString((JsonObject)o, (String)"telephone"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"qr_code"))) {
            user.setQrCode(GsonHelper.getString((JsonObject)o, (String)"qr_code"));
        }
        if (StringUtils.isNotBlank((CharSequence)String.valueOf(GsonHelper.getBoolean((JsonObject)o, (String)"to_invite")))) {
            user.setToInvite(GsonHelper.getBoolean((JsonObject)o, (String)"to_invite"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"address"))) {
            user.setAddress(GsonHelper.getString((JsonObject)o, (String)"address"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"alias"))) {
            user.setEnglishName(GsonHelper.getString((JsonObject)o, (String)"alias"));
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"english_name"))) {
            user.setEnglishName(GsonHelper.getString((JsonObject)o, (String)"english_name"));
        }
        if (GsonHelper.isNotNull((JsonElement)o.get("extattr"))) {
            JsonArray attrJsonElements = o.get("extattr").getAsJsonObject().get("attrs").getAsJsonArray();
            for (JsonElement attrJsonElement : attrJsonElements) {
                WxCpUser.Attr attr = new WxCpUser.Attr(GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"name"), GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"value"));
                user.getExtAttrs().add(attr);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)GsonHelper.getString((JsonObject)o, (String)"external_position"))) {
            user.setExternalPosition(GsonHelper.getString((JsonObject)o, (String)"external_position"));
        }
        if (GsonHelper.isNotNull((JsonElement)o.get(EXTERNAL_PROFILE)) && (asJsonObject = o.get(EXTERNAL_PROFILE).getAsJsonObject()) != null && asJsonObject.has(EXTERNAL_ATTR)) {
            JsonArray attrJsonElements = asJsonObject.get(EXTERNAL_ATTR).getAsJsonArray();
            for (JsonElement element : attrJsonElements) {
                Integer type = GsonHelper.getInteger((JsonObject)element.getAsJsonObject(), (String)"type");
                String name = GsonHelper.getString((JsonObject)element.getAsJsonObject(), (String)"name");
                switch (type) {
                    case 0: {
                        user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).value(GsonHelper.getString((JsonObject)element.getAsJsonObject().get("text").getAsJsonObject(), (String)"value")).build());
                        break;
                    }
                    case 1: {
                        JsonObject web = element.getAsJsonObject().get("web").getAsJsonObject();
                        user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).url(GsonHelper.getString((JsonObject)web, (String)"url")).title(GsonHelper.getString((JsonObject)web, (String)"title")).build());
                        break;
                    }
                    case 2: {
                        JsonObject miniprogram = element.getAsJsonObject().get("miniprogram").getAsJsonObject();
                        user.getExternalAttrs().add(WxCpUser.ExternalAttribute.builder().type(type).name(name).appid(GsonHelper.getString((JsonObject)miniprogram, (String)"appid")).pagePath(GsonHelper.getString((JsonObject)miniprogram, (String)"pagepath")).title(GsonHelper.getString((JsonObject)miniprogram, (String)"title")).build());
                        break;
                    }
                }
            }
        }
        return user;
    }

    public JsonElement serialize(WxCpUser user, Type typeOfSrc, JsonSerializationContext context) {
        Object attrsJson;
        JsonArray attrsJsonArray;
        JsonArray jsonArray;
        JsonObject o = new JsonObject();
        if (user.getUserId() != null) {
            o.addProperty("userid", user.getUserId());
        }
        if (user.getName() != null) {
            o.addProperty("name", user.getName());
        }
        if (user.getDepartIds() != null) {
            jsonArray = new JsonArray();
            for (Long departId : user.getDepartIds()) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)departId));
            }
            o.add("department", (JsonElement)jsonArray);
        }
        if (user.getOrders() != null) {
            jsonArray = new JsonArray();
            for (Long order : user.getOrders()) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)order));
            }
            o.add("order", (JsonElement)jsonArray);
        }
        if (user.getPosition() != null) {
            o.addProperty("position", user.getPosition());
        }
        if (user.getPositions() != null) {
            jsonArray = new JsonArray();
            for (String pos : user.getPositions()) {
                jsonArray.add((JsonElement)new JsonPrimitive(pos));
            }
            o.add("positions", (JsonElement)jsonArray);
        }
        if (user.getMobile() != null) {
            o.addProperty("mobile", user.getMobile());
        }
        if (user.getGender() != null) {
            o.addProperty("gender", user.getGender().getCode());
        }
        if (user.getEmail() != null) {
            o.addProperty("email", user.getEmail());
        }
        if (user.getBizMail() != null) {
            o.addProperty("biz_mail", user.getBizMail());
        }
        if (user.getAvatar() != null) {
            o.addProperty("avatar", user.getAvatar());
        }
        if (user.getAvatarMediaId() != null) {
            o.addProperty("avatar_mediaid", user.getAvatarMediaId());
        }
        if (user.getStatus() != null) {
            o.addProperty("status", (Number)user.getStatus());
        }
        if (user.getEnable() != null) {
            o.addProperty("enable", (Number)user.getEnable());
        }
        if (user.getIsLeaderInDept() != null) {
            jsonArray = new JsonArray();
            for (Integer isLeaderInDept : user.getIsLeaderInDept()) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)isLeaderInDept));
            }
            o.add("is_leader_in_dept", (JsonElement)jsonArray);
        }
        if (user.getDirect_leader() != null) {
            jsonArray = new JsonArray();
            for (String direct_leader : user.getDirect_leader()) {
                if (!StringUtils.isNotBlank((CharSequence)direct_leader)) continue;
                jsonArray.add((JsonElement)new JsonPrimitive(direct_leader));
            }
            o.add("direct_leader", (JsonElement)jsonArray);
        }
        if (user.getHideMobile() != null) {
            o.addProperty("hide_mobile", (Number)user.getHideMobile());
        }
        if (user.getEnglishName() != null) {
            o.addProperty("alias", user.getEnglishName());
            o.addProperty("english_name", user.getEnglishName());
        }
        if (user.getTelephone() != null) {
            o.addProperty("telephone", user.getTelephone());
        }
        if (user.getQrCode() != null) {
            o.addProperty("qr_code", user.getQrCode());
        }
        if (user.getToInvite() != null) {
            o.addProperty("to_invite", user.getToInvite());
        }
        if (user.getAddress() != null) {
            o.addProperty("address", user.getAddress());
        }
        if (user.getExtAttrs().size() > 0) {
            attrsJsonArray = new JsonArray();
            for (WxCpUser.Attr attr : user.getExtAttrs()) {
                JsonObject attrJson = new JsonObject();
                attrJson.addProperty("name", attr.getName());
                attrJson.addProperty("value", attr.getValue());
                attrsJsonArray.add((JsonElement)attrJson);
            }
            attrsJson = new JsonObject();
            attrsJson.add("attrs", (JsonElement)attrsJsonArray);
            o.add("extattr", (JsonElement)attrsJson);
        }
        if (user.getExternalPosition() != null) {
            o.addProperty("external_position", user.getExternalPosition());
        }
        if (user.getExternalAttrs().size() > 0) {
            attrsJsonArray = new JsonArray();
            for (WxCpUser.ExternalAttribute attr : user.getExternalAttrs()) {
                JsonObject attrJson = new JsonObject();
                attrJson.addProperty("type", (Number)attr.getType());
                attrJson.addProperty("name", attr.getName());
                switch (attr.getType()) {
                    case 0: {
                        JsonObject text = new JsonObject();
                        text.addProperty("value", attr.getValue());
                        attrJson.add("text", (JsonElement)text);
                        break;
                    }
                    case 1: {
                        JsonObject web = new JsonObject();
                        web.addProperty("url", attr.getUrl());
                        web.addProperty("title", attr.getTitle());
                        attrJson.add("web", (JsonElement)web);
                        break;
                    }
                    case 2: {
                        JsonObject miniprogram = new JsonObject();
                        miniprogram.addProperty("appid", attr.getAppid());
                        miniprogram.addProperty("pagepath", attr.getPagePath());
                        miniprogram.addProperty("title", attr.getTitle());
                        attrJson.add("miniprogram", (JsonElement)miniprogram);
                        break;
                    }
                }
                attrsJsonArray.add((JsonElement)attrJson);
            }
            attrsJson = new JsonObject();
            attrsJson.add(EXTERNAL_ATTR, (JsonElement)attrsJsonArray);
            o.add(EXTERNAL_PROFILE, (JsonElement)attrsJson);
        }
        return o;
    }
}

