/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.xml;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import me.chanjar.weixin.cp.bean.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutImageMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutNewsMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutTaskCardMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutTextMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutVideoMessage;
import me.chanjar.weixin.cp.bean.WxCpXmlOutVoiceMessage;

public class XStreamTransformer {
    protected static final Map<Class, XStream> CLASS_2_XSTREAM_INSTANCE = XStreamTransformer.configXStreamInstance();

    public static <T> T fromXml(Class<T> clazz, String xml) {
        Object object = CLASS_2_XSTREAM_INSTANCE.get(clazz).fromXML(xml);
        return (T)object;
    }

    public static <T> T fromXml(Class<T> clazz, InputStream is) {
        Object object = CLASS_2_XSTREAM_INSTANCE.get(clazz).fromXML(is);
        return (T)object;
    }

    public static void register(Class clz, XStream xStream) {
        CLASS_2_XSTREAM_INSTANCE.put(clz, xStream);
    }

    public static <T> String toXml(Class<T> clazz, T object) {
        return CLASS_2_XSTREAM_INSTANCE.get(clazz).toXML(object);
    }

    private static Map<Class, XStream> configXStreamInstance() {
        HashMap<Class, XStream> map = new HashMap<Class, XStream>();
        map.put(WxCpXmlMessage.class, XStreamTransformer.configWxCpXmlMessage());
        map.put(WxCpXmlOutNewsMessage.class, XStreamTransformer.configWxCpXmlOutNewsMessage());
        map.put(WxCpXmlOutTextMessage.class, XStreamTransformer.configWxCpXmlOutTextMessage());
        map.put(WxCpXmlOutImageMessage.class, XStreamTransformer.configWxCpXmlOutImageMessage());
        map.put(WxCpXmlOutVideoMessage.class, XStreamTransformer.configWxCpXmlOutVideoMessage());
        map.put(WxCpXmlOutVoiceMessage.class, XStreamTransformer.configWxCpXmlOutVoiceMessage());
        map.put(WxCpXmlOutTaskCardMessage.class, XStreamTransformer.configWxCpXmlOutTaskCardMessage());
        return map;
    }

    private static XStream configWxCpXmlMessage() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxCpXmlMessage.class);
        xstream.processAnnotations(WxCpXmlMessage.ScanCodeInfo.class);
        xstream.processAnnotations(WxCpXmlMessage.SendPicsInfo.class);
        xstream.processAnnotations(WxCpXmlMessage.SendPicsInfo.Item.class);
        xstream.processAnnotations(WxCpXmlMessage.SendLocationInfo.class);
        return xstream;
    }

    private static XStream configWxCpXmlOutImageMessage() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxCpXmlOutMessage.class);
        xstream.processAnnotations(WxCpXmlOutImageMessage.class);
        return xstream;
    }

    private static XStream configWxCpXmlOutNewsMessage() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxCpXmlOutMessage.class);
        xstream.processAnnotations(WxCpXmlOutNewsMessage.class);
        xstream.processAnnotations(WxCpXmlOutNewsMessage.Item.class);
        return xstream;
    }

    private static XStream configWxCpXmlOutTextMessage() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxCpXmlOutMessage.class);
        xstream.processAnnotations(WxCpXmlOutTextMessage.class);
        return xstream;
    }

    private static XStream configWxCpXmlOutVideoMessage() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxCpXmlOutMessage.class);
        xstream.processAnnotations(WxCpXmlOutVideoMessage.class);
        xstream.processAnnotations(WxCpXmlOutVideoMessage.Video.class);
        return xstream;
    }

    private static XStream configWxCpXmlOutVoiceMessage() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxCpXmlOutMessage.class);
        xstream.processAnnotations(WxCpXmlOutVoiceMessage.class);
        return xstream;
    }

    private static XStream configWxCpXmlOutTaskCardMessage() {
        XStream xstream = XStreamInitializer.getInstance();
        xstream.processAnnotations(WxCpXmlOutMessage.class);
        xstream.processAnnotations(WxCpXmlOutTaskCardMessage.class);
        return xstream;
    }
}

