/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel.context.statement;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.ParamsData;
import com.huawei.gauss.exception.ExceptionUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ParamAlignHelper {
    private ParamAlignHelper() {
    }

    public static final void alignData(ParamsData.Param[] params, ParamsData.ParamInfo[] paramInfos, int paramCount) throws SQLException {
        for (int i = 0; i < paramCount; ++i) {
            ParamsData.ParamInfo info = paramInfos[i];
            ParamsData.Param p = params[i];
            Boolean isLob = p.dataType.equals((Object)FieldType.CLOB) || p.dataType.equals((Object)FieldType.BLOB) || p.dataType.equals((Object)FieldType.IMAGE);
            if (!info.needAlign || isLob.booleanValue()) continue;
            ParamAlignHelper.alignData(p, info.alignType);
        }
    }

    private static void alignData(ParamsData.Param param, FieldType toType) throws SQLException {
        if (param.dataType.equals((Object)toType) || param.value == null) {
            param.dataType = toType;
            return;
        }
        switch (param.dataType) {
            case STRING: {
                ParamAlignHelper.alignDataFromString(param, toType);
                break;
            }
            case INTEGER: {
                ParamAlignHelper.alignDataFromInt(param, toType);
                break;
            }
            case BIGINT: {
                ParamAlignHelper.alignDataFromBigInt(param, toType);
                break;
            }
            case REAL: {
                ParamAlignHelper.alignDataFromReal(param, toType);
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                ParamAlignHelper.alignDataFromNumeric(param, toType);
                break;
            }
            case TIME: 
            case DATE_NOTIME: 
            case DATE: 
            case UTC: 
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: {
                ParamAlignHelper.alignDataFromDate(param, toType);
                break;
            }
            case UNKNOWN: 
            case BLOB: 
            case CLOB: 
            case IMAGE: {
                return;
            }
            default: {
                throw ParamAlignHelper.throwException(param.dataType, toType);
            }
        }
        param.dataType = toType;
    }

    private static void alignDataFromDate(ParamsData.Param param, FieldType toType) throws SQLException {
        Date v = (Date)param.value;
        switch (toType) {
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: {
                param.value = new Timestamp(v.getTime());
                break;
            }
            case STRING: {
                if (param.dataType == FieldType.TIMESTAMP) {
                    param.value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(v);
                    break;
                }
                param.value = String.valueOf(v);
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(param.dataType, toType);
            }
        }
    }

    private static void alignDataFromNumeric(ParamsData.Param param, FieldType toType) throws SQLException {
        switch (toType) {
            case STRING: 
            case NUMERIC: 
            case DECIMAL: {
                param.value = param.value.toString();
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(param.dataType, toType);
            }
        }
    }

    private static void alignDataFromReal(ParamsData.Param param, FieldType toType) throws SQLException {
        Double v = (Double)param.value;
        switch (toType) {
            case NUMERIC: 
            case DECIMAL: {
                param.value = BigDecimal.valueOf(v).toString();
                break;
            }
            case STRING: {
                param.value = String.valueOf(v);
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(param.dataType, toType);
            }
        }
    }

    private static void alignDataFromBigInt(ParamsData.Param param, FieldType toType) throws SQLException {
        Long v = (Long)param.value;
        switch (toType) {
            case REAL: {
                param.value = v.doubleValue();
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                param.value = BigDecimal.valueOf(v).toString();
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: {
                param.value = new Timestamp(v);
                break;
            }
            case STRING: {
                param.value = String.valueOf(v);
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(param.dataType, toType);
            }
        }
    }

    private static void alignDataFromInt(ParamsData.Param param, FieldType toType) throws SQLException {
        Integer v = (Integer)param.value;
        switch (toType) {
            case BIGINT: {
                param.value = v.longValue();
                break;
            }
            case REAL: {
                param.value = (double)v.intValue();
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                param.value = BigDecimal.valueOf(v.longValue()).toString();
                break;
            }
            case STRING: {
                param.value = String.valueOf(v);
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(param.dataType, toType);
            }
        }
    }

    private static void alignDataFromString(ParamsData.Param param, FieldType toType) throws SQLException {
        switch (toType) {
            case UNKNOWN: 
            case VARCHAR: {
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(param.dataType, toType);
            }
        }
    }

    public static final void alignType(ParamsData.ParamInfo info, FieldType toType) throws SQLException {
        switch (info.alignType) {
            case STRING: 
            case CHAR: {
                ParamAlignHelper.alignFromString(info, toType);
                break;
            }
            case INTEGER: {
                ParamAlignHelper.alignFromInteger(info, toType);
                break;
            }
            case BIGINT: {
                ParamAlignHelper.alignFromBigint(info, toType);
                break;
            }
            case REAL: {
                ParamAlignHelper.alignFromReal(info, toType);
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                ParamAlignHelper.alignFromNumeric(info, toType);
                break;
            }
            case TIME: 
            case DATE_NOTIME: 
            case DATE: 
            case UTC: 
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: {
                ParamAlignHelper.alignToTimestamp(info, toType);
                break;
            }
            case CLOB: {
                info.alignType = FieldType.STRING;
                break;
            }
            case BLOB: 
            case IMAGE: {
                info.alignType = FieldType.BINARY;
                break;
            }
            case UNKNOWN: 
            case VARCHAR: {
                info.alignType = toType;
                break;
            }
            case BINARY: {
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(info.alignType, toType);
            }
        }
        info.needAlign = true;
    }

    private static void alignToTimestamp(ParamsData.ParamInfo info, FieldType toType) throws SQLException {
        switch (toType) {
            case TIME: 
            case DATE_NOTIME: 
            case DATE: 
            case UTC: 
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: 
            case UNKNOWN: 
            case VARCHAR: {
                info.alignType = FieldType.TIMESTAMP;
                break;
            }
            case STRING: 
            case CHAR: {
                info.alignType = FieldType.STRING;
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(info.alignType, toType);
            }
        }
    }

    private static void alignFromNumeric(ParamsData.ParamInfo info, FieldType toType) throws SQLException {
        switch (toType) {
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case NUMERIC: 
            case DECIMAL: 
            case UNKNOWN: 
            case VARCHAR: {
                break;
            }
            case STRING: 
            case CHAR: {
                info.alignType = FieldType.STRING;
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(info.alignType, toType);
            }
        }
    }

    private static void alignFromReal(ParamsData.ParamInfo info, FieldType toType) throws SQLException {
        switch (toType) {
            case BIGINT: 
            case NUMERIC: 
            case DECIMAL: {
                info.alignType = FieldType.NUMERIC;
                break;
            }
            case STRING: 
            case CHAR: {
                info.alignType = FieldType.STRING;
                break;
            }
            case INTEGER: 
            case REAL: 
            case UNKNOWN: 
            case VARCHAR: {
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(info.alignType, toType);
            }
        }
    }

    private static void alignFromBigint(ParamsData.ParamInfo info, FieldType toType) throws SQLException {
        switch (toType) {
            case REAL: 
            case NUMERIC: 
            case DECIMAL: {
                info.alignType = FieldType.NUMERIC;
                break;
            }
            case STRING: 
            case CHAR: {
                info.alignType = FieldType.STRING;
                break;
            }
            case INTEGER: 
            case BIGINT: 
            case UNKNOWN: 
            case VARCHAR: {
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(info.alignType, toType);
            }
        }
    }

    private static void alignFromInteger(ParamsData.ParamInfo info, FieldType toType) throws SQLException {
        switch (toType) {
            case BIGINT: 
            case REAL: 
            case NUMERIC: 
            case DECIMAL: {
                info.alignType = toType;
                break;
            }
            case STRING: 
            case CHAR: {
                info.alignType = FieldType.STRING;
                break;
            }
            case INTEGER: 
            case UNKNOWN: 
            case VARCHAR: {
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(info.alignType, toType);
            }
        }
    }

    private static void alignFromString(ParamsData.ParamInfo info, FieldType toType) throws SQLException {
        switch (toType) {
            case INTEGER: 
            case BIGINT: 
            case REAL: 
            case NUMERIC: 
            case DECIMAL: 
            case TIME: 
            case DATE_NOTIME: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_TZ_FAKE: 
            case TIMESTAMP_LTZ: 
            case CHAR: 
            case TIMESTAMP_TZ: {
                info.alignType = FieldType.STRING;
                break;
            }
            case STRING: 
            case UNKNOWN: 
            case CLOB: 
            case VARCHAR: {
                break;
            }
            default: {
                throw ParamAlignHelper.throwException(info.alignType, toType);
            }
        }
    }

    private static SQLException throwException(FieldType fromType, FieldType toType) {
        return ExceptionUtil.illegalJDBCArgumentException("Align type failed, from type is [" + fromType.getName() + "], to type is [" + toType.getName() + "].");
    }
}

