/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel.context.statement;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.ParamAlignHelper;
import com.huawei.gauss.channel.context.statement.ParamsData;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.util.BytesUtil;
import com.huawei.gauss.util.TimeUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class ParamsDataProcessor
extends BytesUtil {
    final ParamsData paramsData;
    int currentIndex;
    ByteArrayOutputStream encodeCache = new ByteArrayOutputStream();
    byte[] lastEncodeParamData;
    ParamsData.ParamData headData;
    byte[] typeList;
    boolean isFirstRow;
    byte[] flagsList;
    int usedBufferLen;

    protected ParamsDataProcessor(ParamsData paramsData) {
        this.paramsData = paramsData;
        this.headData = paramsData.paramsCache.size() > 0 ? paramsData.paramsCache.get(0) : null;
        this.isFirstRow = true;
        this.typeList = null;
        this.flagsList = null;
    }

    public void setUsedBufferLen(int usedBufferLen) {
        this.usedBufferLen = usedBufferLen;
    }

    public void addTypelistToEncodeData() {
        if (this.isEnd()) {
            return;
        }
        int size = this.lastEncodeParamData.length;
        byte[] newEncodeParamData = new byte[size += this.typeList.length];
        System.arraycopy(this.typeList, 0, newEncodeParamData, 0, this.typeList.length);
        System.arraycopy(this.lastEncodeParamData, 0, newEncodeParamData, this.typeList.length, this.lastEncodeParamData.length);
        this.lastEncodeParamData = newEncodeParamData;
    }

    public void reBindData() throws SQLException {
        for (ParamsData.ParamData data : this.paramsData.paramsCache) {
            ParamAlignHelper.alignData(data.params, this.paramsData.paramInfos, this.paramsData.paramCount);
        }
    }

    public boolean encodeOneRowV6(ParamsData.ParamData param) throws SQLException {
        for (int i = 0; i < param.params.length; ++i) {
            if (this.headData.params[i].dataType == param.params[i].dataType) continue;
            this.headData = param;
            return false;
        }
        try {
            for (ParamsData.Param p : param.params) {
                this.encodeOneParamV6(p);
            }
            byte[] tempBA = this.encodeCache.toByteArray();
            int totalSize = this.encodeCache.size();
            byte[] totalSizeBA = ParamsDataProcessor.getBytes(totalSize += 4, this.paramsData.isBigEndianess);
            this.lastEncodeParamData = new byte[tempBA.length + 4];
            System.arraycopy(tempBA, 0, this.lastEncodeParamData, 4, tempBA.length);
            System.arraycopy(totalSizeBA, 0, this.lastEncodeParamData, 0, 4);
            ++this.paramsData.position;
            this.encodeCache.reset();
            ++this.currentIndex;
        }
        catch (SQLException exception) {
            throw exception;
        }
        catch (Exception e) {
            throw ExceptionUtil.illegalJDBCArgumentException("Param encode failed.", e);
        }
        return true;
    }

    public boolean hasNextParam() throws SQLException {
        if (this.currentIndex >= this.paramsData.paramsCache.size() || this.headData == null) {
            return false;
        }
        ParamsData.ParamData param = this.paramsData.paramsCache.get(this.currentIndex);
        if (this.paramsData.callVersion < 7) {
            return this.encodeOneRowV6(param);
        }
        return this.encodeOneRowV7(param);
    }

    public boolean encodeOneRowV7(ParamsData.ParamData param) throws SQLException {
        int paramCount = BytesUtil.align4BytesLength(param.params.length);
        if (this.isFirstRow) {
            this.typeList = new byte[paramCount];
        }
        for (int i = 0; i < param.params.length; ++i) {
            if (this.headData.params[i].dataType != param.params[i].dataType) {
                this.headData = param;
                this.resetTypeList();
                return false;
            }
            if (!this.isFirstRow) continue;
            this.typeList[i] = this.headData.params[i].dataType == FieldType.TIME ? 7 : (byte)this.headData.params[i].dataType.getGaussType();
        }
        try {
            this.flagsList = new byte[paramCount];
            for (int index = 0; index < param.params.length; ++index) {
                ParamsData.Param p = param.params[index];
                int isNull = p.value == null ? 1 : 0;
                this.flagsList[index] = (byte)(isNull |= p.inOutType);
                this.encodeOneParamV7(p);
            }
            byte[] tempBA = this.encodeCache.toByteArray();
            int totalSize = this.encodeCache.size();
            byte[] totalSizeBA = ParamsDataProcessor.getBytes(totalSize += 4 + paramCount, this.paramsData.isBigEndianess);
            int usedLength = 0;
            if (this.isFirstRow) {
                this.lastEncodeParamData = new byte[totalSize + paramCount];
                System.arraycopy(this.typeList, 0, this.lastEncodeParamData, 0, paramCount);
                usedLength += paramCount;
                this.isFirstRow = false;
            } else {
                this.lastEncodeParamData = new byte[totalSize];
            }
            System.arraycopy(totalSizeBA, 0, this.lastEncodeParamData, usedLength, 4);
            System.arraycopy(this.flagsList, 0, this.lastEncodeParamData, usedLength += 4, paramCount);
            System.arraycopy(tempBA, 0, this.lastEncodeParamData, usedLength += paramCount, tempBA.length);
            ++this.paramsData.position;
            this.encodeCache.reset();
            ++this.currentIndex;
        }
        catch (SQLException exception) {
            throw exception;
        }
        catch (Exception e) {
            throw ExceptionUtil.illegalJDBCArgumentException("Param encode failed.", e);
        }
        return true;
    }

    public List<AbstractGaussLob> getAllLob() {
        ArrayList<AbstractGaussLob> allLobs = new ArrayList<AbstractGaussLob>();
        for (ParamsData.ParamData paramData : this.paramsData.paramsCache) {
            int bindPos = 0;
            for (ParamsData.Param p : paramData.params) {
                ++bindPos;
                if (!FieldType.CLOB.equals((Object)p.dataType) && !FieldType.BLOB.equals((Object)p.dataType) && !FieldType.IMAGE.equals((Object)p.dataType) || p.value == null) continue;
                AbstractGaussLob lob = (AbstractGaussLob)p.value;
                lob.setBindPos(bindPos);
                allLobs.add(lob);
            }
        }
        return allLobs;
    }

    protected void encodeOneParamV6(ParamsData.Param param) throws IOException, SQLException {
        FieldType type = param.dataType;
        byte[] value = BytesUtil.EMPTY;
        int totalSize = 4;
        int gsType = type.getGaussType();
        if (param.value != null) {
            switch (type) {
                case INTEGER: {
                    value = ParamsDataProcessor.getBytes((Integer)param.value, this.paramsData.isBigEndianess);
                    totalSize += 4;
                    break;
                }
                case BIGINT: {
                    value = ParamsDataProcessor.getBytes((Long)param.value, this.paramsData.isBigEndianess);
                    totalSize += 8;
                    break;
                }
                case REAL: {
                    value = ParamsDataProcessor.getBytes((Double)param.value);
                    totalSize += 8;
                    break;
                }
                case TIME: {
                    String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Time)param.value);
                    long v = TimeUtil.encodeDate(str, FieldType.TIME, param.calendar);
                    value = ParamsDataProcessor.getBytes(v, this.paramsData.isBigEndianess);
                    totalSize += 8;
                    gsType = 7;
                    break;
                }
                case DATE: {
                    String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)param.value);
                    long v = TimeUtil.encodeDate(str, FieldType.DATE, param.calendar);
                    value = ParamsDataProcessor.getBytes(v, this.paramsData.isBigEndianess);
                    totalSize += 8;
                    break;
                }
                case TIMESTAMP: 
                case TIMESTAMP_TZ_FAKE: 
                case TIMESTAMP_LTZ: {
                    String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format((Timestamp)param.value);
                    long v = TimeUtil.encodeDate(str, FieldType.TIMESTAMP, param.calendar);
                    value = ParamsDataProcessor.getBytes(v, this.paramsData.isBigEndianess);
                    totalSize += 8;
                    break;
                }
                case NUMERIC: 
                case DECIMAL: 
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    value = ParamsDataProcessor.getBytes((String)param.value, this.paramsData.getCharset());
                    totalSize += 4 + BytesUtil.align4BytesLength(value.length);
                    break;
                }
                case VARBINARY: 
                case BINARY: 
                case RAW: {
                    value = (byte[])param.value;
                    totalSize += 4 + BytesUtil.align4BytesLength(value.length);
                    break;
                }
                case BLOB: 
                case CLOB: 
                case IMAGE: {
                    value = ((AbstractGaussLob)param.value).getLobVar(this.paramsData.isBigEndianess);
                    totalSize += value.length;
                    break;
                }
                default: {
                    throw ExceptionUtil.illegalJDBCArgumentException("Type is illegal, type is [" + type.getName() + ".");
                }
            }
        }
        this.encodeCache.write(ParamsDataProcessor.getBytes((short)totalSize, this.paramsData.isBigEndianess));
        this.encodeCache.write(gsType);
        int isNull = param.value == null ? 1 : 0;
        this.encodeCache.write(isNull |= param.inOutType);
        if (param.value != null) {
            switch (type) {
                case NUMERIC: 
                case CHAR: 
                case VARCHAR: 
                case STRING: 
                case VARBINARY: 
                case BINARY: 
                case RAW: {
                    this.encodeCache.write(ParamsDataProcessor.getBytes(value.length, this.paramsData.isBigEndianess));
                    this.encodeCache.write(ParamsDataProcessor.align4BytesArray(value));
                    break;
                }
                default: {
                    this.encodeCache.write(value);
                }
            }
        }
    }

    protected void encodeOneParamV7(ParamsData.Param param) throws IOException, SQLException {
        FieldType type = param.dataType;
        byte[] value = BytesUtil.EMPTY;
        if (param.value != null) {
            switch (type) {
                case INTEGER: {
                    value = ParamsDataProcessor.getBytes((Integer)param.value, this.paramsData.isBigEndianess);
                    break;
                }
                case BIGINT: {
                    value = ParamsDataProcessor.getBytes((Long)param.value, this.paramsData.isBigEndianess);
                    break;
                }
                case REAL: {
                    value = ParamsDataProcessor.getBytes((Double)param.value);
                    break;
                }
                case TIME: {
                    String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Time)param.value);
                    long v = TimeUtil.encodeDate(str, FieldType.TIME, param.calendar);
                    value = ParamsDataProcessor.getBytes(v, this.paramsData.isBigEndianess);
                    break;
                }
                case DATE: {
                    String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)param.value);
                    long v = TimeUtil.encodeDate(str, FieldType.DATE, param.calendar);
                    value = ParamsDataProcessor.getBytes(v, this.paramsData.isBigEndianess);
                    break;
                }
                case TIMESTAMP: 
                case TIMESTAMP_TZ_FAKE: 
                case TIMESTAMP_LTZ: {
                    String str = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format((Timestamp)param.value);
                    int timeUs = ((Timestamp)param.value).getNanos() / 1000 % 1000;
                    long v = TimeUtil.encodeDate(str, FieldType.TIMESTAMP, param.calendar);
                    value = ParamsDataProcessor.getBytes(v + (long)timeUs, this.paramsData.isBigEndianess);
                    break;
                }
                case NUMERIC: 
                case DECIMAL: 
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    value = ParamsDataProcessor.getBytes((String)param.value, this.paramsData.getCharset());
                    break;
                }
                case VARBINARY: 
                case BINARY: 
                case RAW: {
                    value = (byte[])param.value;
                    break;
                }
                case BLOB: 
                case CLOB: 
                case IMAGE: {
                    value = ((AbstractGaussLob)param.value).getLobVar(this.paramsData.isBigEndianess);
                    break;
                }
                default: {
                    throw ExceptionUtil.illegalJDBCArgumentException("Type is illegal, type is [" + type.getName() + ".");
                }
            }
        }
        if (param.value != null) {
            switch (type) {
                case NUMERIC: 
                case CHAR: 
                case VARCHAR: 
                case STRING: 
                case VARBINARY: 
                case BINARY: 
                case RAW: {
                    this.encodeCache.write(ParamsDataProcessor.getBytes(value.length, this.paramsData.isBigEndianess));
                    this.encodeCache.write(ParamsDataProcessor.align4BytesArray(value));
                    break;
                }
                default: {
                    this.encodeCache.write(value);
                }
            }
        }
    }

    public byte[] getParamEncodeValue() {
        return this.lastEncodeParamData;
    }

    public void reset() {
        this.lastEncodeParamData = null;
    }

    public void resetTypeList() {
        this.typeList = null;
        this.isFirstRow = true;
    }

    public boolean isEnd() {
        return this.lastEncodeParamData == null;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }
}

