/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.cluster;

import com.huawei.gauss.cluster.ClusterNodeImp;
import com.huawei.gauss.cluster.api.GaussCluster;
import com.huawei.gauss.cluster.api.GaussClusterNode;
import com.huawei.gauss.cluster.api.GaussNodeComparator;
import com.huawei.gauss.cluster.check.CheckConnectionPool;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussSubDriverAbstract;
import com.huawei.gauss.jdbc.inner.UrlType;
import com.huawei.gauss.util.IOUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractClusterInfo
implements GaussCluster {
    private static final int ERR_TABLE_OR_VIEW_NOT_EXIST = 843;
    protected final Map<String, GaussClusterNode> cnNodes = new ConcurrentHashMap<String, GaussClusterNode>(10);
    protected String clusterUrls;
    protected GaussNodeComparator nodeComparator;
    protected final Random random = new Random();

    public AbstractClusterInfo(String clusterUrls) {
        this.clusterUrls = clusterUrls;
        this.initCmp();
    }

    protected abstract void initCmp();

    @Override
    public void refreshNodesStatus() {
    }

    @Override
    public List<GaussClusterNode> getUsefulNodeListSorted() {
        ArrayList<GaussClusterNode> usefulNodes = new ArrayList<GaussClusterNode>();
        for (Map.Entry<String, GaussClusterNode> entry : this.cnNodes.entrySet()) {
            GaussClusterNode node = entry.getValue();
            if (node.isOk()) {
                usefulNodes.add(node);
            }
            Collections.sort(usefulNodes, this.nodeComparator);
        }
        return usefulNodes;
    }

    @Override
    public List<GaussClusterNode> getUsefulNodeList(Properties prop) {
        ArrayList<GaussClusterNode> usefulNodes = new ArrayList<GaussClusterNode>();
        for (Map.Entry<String, GaussClusterNode> entry : this.cnNodes.entrySet()) {
            GaussClusterNode node = entry.getValue();
            CheckConnectionPool.registeGaussNodeConnInfo(entry.getKey(), prop);
            if (!node.isOk()) continue;
            usefulNodes.add(node);
        }
        return usefulNodes;
    }

    @Override
    public List<GaussClusterNode> getUsefulNodesSortedAfterExclude(List<String> excludedUrls) {
        ArrayList<GaussClusterNode> usefulNodes = new ArrayList<GaussClusterNode>();
        for (Map.Entry<String, GaussClusterNode> entry : this.cnNodes.entrySet()) {
            if (excludedUrls.contains(entry.getKey())) continue;
            GaussClusterNode node = entry.getValue();
            if (node.isOk()) {
                usefulNodes.add(node);
            }
            Collections.sort(usefulNodes, this.nodeComparator);
        }
        return usefulNodes;
    }

    @Override
    public GaussClusterNode getNode(String nodeIpAndPort) {
        return this.cnNodes.get(nodeIpAndPort);
    }

    private int findTopEqualRatioNodeCount(List<GaussClusterNode> sortedNodes) {
        int num = 1;
        float firstIdle = sortedNodes.get(0).getEstablishedCount();
        for (int i = 1; i < sortedNodes.size(); ++i) {
            if (firstIdle != (float)sortedNodes.get(i).getEstablishedCount()) continue;
            ++num;
        }
        return num;
    }

    protected synchronized GaussClusterNode getGaussNodeInfo(List<String> excludedUrls) throws SQLException {
        List<GaussClusterNode> usefulNodes = null;
        usefulNodes = excludedUrls == null ? this.getUsefulNodeListSorted() : this.getUsefulNodesSortedAfterExclude(excludedUrls);
        if (usefulNodes.size() > 0) {
            int seed = this.findTopEqualRatioNodeCount(usefulNodes);
            int randomIndex = this.random.nextInt(seed);
            GaussClusterNode gaussNode = usefulNodes.get(randomIndex);
            gaussNode.increaseConnCount();
            return gaussNode;
        }
        throw ExceptionUtil.createClusterException("There is no useful Zenith Node, url is [" + this.clusterUrls + "].", "08006", 303);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GaussConnectionImpl getConnection(GaussSubDriverAbstract driver, Properties props, UrlType urlType, List<String> excludedUrls) throws SQLException {
        List<GaussClusterNode> usefulNodes = this.getUsefulNodeList(props);
        SQLException exception = null;
        GaussConnectionImpl conn = null;
        PreparedStatement pStatement = null;
        ResultSet rSet = null;
        boolean isPrimary = false;
        int tryTimes = usefulNodes.size();
        while (tryTimes-- > 0) {
            GaussClusterNode gsNodeInfo = this.getGaussNodeInfo(excludedUrls);
            try {
                if (urlType == UrlType.ETCD) {
                    conn = gsNodeInfo.createConnection(driver, props);
                } else if (urlType == UrlType.RWSEPARATION) {
                    String rwSeparation = props.getProperty("dnReadWriteSeparation", "false");
                    boolean isRWSeparation = Boolean.valueOf(rwSeparation);
                    if (isRWSeparation) {
                        conn = gsNodeInfo.createConnection(driver, props);
                        isPrimary = true;
                    } else {
                        conn = gsNodeInfo.createConnection(driver, props);
                        isPrimary = this.checkIsPrimary(conn, rSet, pStatement, gsNodeInfo);
                    }
                } else {
                    conn = gsNodeInfo.createConnection(driver, props);
                    isPrimary = this.checkIsPrimary(conn, rSet, pStatement, gsNodeInfo);
                }
            }
            catch (SQLException e) {
                this.postProcessConn(gsNodeInfo, conn);
                conn = null;
                exception = e;
                ExceptionUtil.handleUnThrowException("get connection from one node failed", e);
                if (e.getErrorCode() == 843) {
                    throw e;
                }
            }
            finally {
                if (urlType != UrlType.ETCD) {
                    IOUtils.closeResultsetQuietly(rSet);
                    IOUtils.closeStatementQuietly(pStatement);
                    if (!isPrimary) {
                        this.postProcessConn(gsNodeInfo, conn);
                        conn = null;
                    }
                }
            }
            if (conn != null) {
                return conn;
            }
            if (excludedUrls == null) {
                excludedUrls = new ArrayList<String>();
            }
            excludedUrls.add(gsNodeInfo.getIpAndPort());
        }
        StringBuilder err = new StringBuilder();
        if (usefulNodes.size() == 0) {
            err.append("There is no useful Zenith Node,");
            err.append(" url is [").append(this.clusterUrls).append("].");
            throw ExceptionUtil.createClusterException(err.toString(), "08006", 303);
        }
        err.append("Can not create connection from Zenith cluster");
        err.append(",maybe user or password is invalid ,please check.");
        err.append(" URL is [").append(this.clusterUrls).append("].");
        throw ExceptionUtil.createClusterException(err.toString(), "08006", 303, exception);
    }

    protected abstract void buildNodes() throws SQLException;

    protected GaussClusterNode buildNodeByIpPort(String ipPort) throws SQLException {
        ClusterNodeImp tmpNode = new ClusterNodeImp(ipPort.trim());
        tmpNode.setOriginalUrl(this.clusterUrls);
        return tmpNode;
    }

    private boolean checkIsPrimary(GaussConnectionImpl conn, ResultSet rSet, PreparedStatement pStatement, GaussClusterNode gsNodeInfo) throws SQLException {
        pStatement = conn.prepareStatement("SELECT DATABASE_ROLE FROM DB_NODE_INFO");
        rSet = pStatement.executeQuery();
        return rSet.next() && "PRIMARY".compareTo(rSet.getString(1)) == 0;
    }

    private void postProcessConn(GaussClusterNode gsNodeInfo, GaussConnectionImpl conn) {
        if (conn != null) {
            gsNodeInfo.decreaseConnCount();
            IOUtils.closeConnectionQuietly(conn);
        }
    }
}

