/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.cluster.imp;

import com.huawei.gauss.cluster.AbstractClusterInfo;
import com.huawei.gauss.cluster.api.GaussCluster;
import com.huawei.gauss.cluster.api.GaussClusterNode;
import com.huawei.gauss.cluster.api.GaussNodeComparator;
import com.huawei.gauss.exception.ClusterException;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.util.FormatTransfer;
import java.sql.SQLException;

public class GaussClusterInfoCn
extends AbstractClusterInfo
implements GaussCluster {
    public GaussClusterInfoCn(String clusterUrls) throws ClusterException {
        super(clusterUrls);
        try {
            this.buildNodes();
        }
        catch (SQLException e) {
            throw ExceptionUtil.processClusterException("build node for CN cluster failed, url:" + clusterUrls, e);
        }
    }

    @Override
    public void detect() {
        for (GaussClusterNode gcn : this.cnNodes.values()) {
            gcn.checkOk();
        }
    }

    public String toString() {
        return "GaussClusterInfoCn:GaussNods{" + System.lineSeparator() + FormatTransfer.map2String(this.cnNodes) + '}';
    }

    @Override
    protected void buildNodes() throws SQLException {
        String[] ipPorts;
        for (String ipPort : ipPorts = this.clusterUrls.split(",")) {
            this.cnNodes.put(ipPort, this.buildNodeByIpPort(ipPort));
        }
    }

    @Override
    protected void initCmp() {
        this.nodeComparator = new GaussNodeComparatorCn();
    }

    public static class GaussNodeComparatorCn
    implements GaussNodeComparator {
        @Override
        public int compare(GaussClusterNode o1, GaussClusterNode o2) {
            boolean status2;
            boolean status = o1.isOk();
            if (status != (status2 = o2.isOk())) {
                return status ? -1 : 1;
            }
            return this.compareBase(o1, o2);
        }
    }
}

