/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.datasource;

import com.huawei.gauss.datasource.GSObjectFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

public abstract class GSDataSourceBase
implements Referenceable,
CommonDataSource {
    public static final int DEFAULT_PROT = 1611;
    public static final String URL_PRE = "jdbc:zenith:@";
    private PrintWriter logger;
    private String serverName = "localhost";
    private String databaseName;
    private String userName;
    private String passwd;
    private int portNum = 1611;
    private boolean explicitUrl = false;
    private String url = null;

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.passwd);
    }

    public Connection getConnection(String userName, String passwd) throws SQLException {
        String url = this.getUrl();
        try {
            Connection gsConn = DriverManager.getConnection(url, userName, passwd);
            if (this.logger != null) {
                this.logger.println("Created a non-pooled connection for " + url);
            }
            return gsConn;
        }
        catch (SQLException e) {
            if (this.logger != null) {
                this.logger.println("Failed to create a non-pooled connection for " + url + ": " + e);
            }
            throw e;
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName == null || serverName.equals("") ? "localhost" : serverName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public abstract String getDescription();

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String password) {
        this.passwd = password;
    }

    public int getPortNum() {
        return this.portNum;
    }

    public void setPortNum(int port) {
        this.portNum = port;
    }

    public String getURL() {
        return this.getUrl();
    }

    public String getUrl() {
        if (!this.explicitUrl) {
            StringBuffer sb = new StringBuffer(100);
            sb.append(URL_PRE);
            sb.append(this.serverName);
            sb.append(":").append(this.portNum);
            return sb.toString();
        }
        return this.url;
    }

    public void setURL(String driverUrl) {
        this.setUrl(driverUrl);
    }

    public void setUrl(String driverUrl) {
        this.url = driverUrl;
        this.explicitUrl = true;
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), GSObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = this.createReference();
        ref.add(new StringRefAddr("serverName", this.serverName));
        if (this.portNum != 0) {
            ref.add(new StringRefAddr("port", Integer.toString(this.portNum)));
        }
        ref.add(new StringRefAddr("databaseName", this.databaseName));
        if (this.userName != null) {
            ref.add(new StringRefAddr("user", this.userName));
        }
        if (this.passwd != null) {
            ref.add(new StringRefAddr("password", this.passwd));
        }
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("explicitUrl", String.valueOf(this.explicitUrl)));
        return ref;
    }

    public void initializeFrom(GSDataSourceBase source) {
        this.serverName = source.serverName;
        this.databaseName = source.databaseName;
        this.userName = source.userName;
        this.passwd = source.passwd;
        this.portNum = source.portNum;
        this.url = source.url;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int i) throws SQLException {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("don't support getParentLogger");
    }

    static {
        try {
            Class.forName("com.huawei.gauss.jdbc.ZenithDriver");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("BaseDataSource is unable to load com.huawei.gauss.jdbc.ZenithDriver. Please check if you have proper Zenith JDBC Driver jar on the classpath", e);
        }
    }
}

