/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.datasource;

import com.huawei.gauss.datasource.GSConnectionPoolDataSource;
import com.huawei.gauss.datasource.GSDataSourceBase;
import com.huawei.gauss.datasource.GSPoolingDataSource;
import com.huawei.gauss.datasource.GSSimpleDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class GSObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference refTemp = (Reference)object;
        String className = refTemp.getClassName();
        if (className.equals("com.huawei.gauss.datasource.GSSimpleDataSource")) {
            return this.loadGSSimpleDataSource(refTemp);
        }
        if (className.equals("com.huawei.gauss.datasource.GSConnectionPoolDataSource")) {
            return this.loadGSConnectionPool(refTemp);
        }
        if (className.equals("com.huawei.gauss.datasource.GSPoolingDataSource")) {
            return this.loadGSPoolingDataSource(refTemp);
        }
        return null;
    }

    private Object loadGSPoolingDataSource(Reference reference) {
        String maxConnNum;
        String dataSourceName = this.getProperty(reference, "dataSourceName");
        if (dataSourceName == null) {
            return null;
        }
        GSPoolingDataSource gaussPoolingDataSource = GSPoolingDataSource.getDataSource(dataSourceName);
        if (gaussPoolingDataSource != null) {
            return gaussPoolingDataSource;
        }
        gaussPoolingDataSource = new GSPoolingDataSource();
        gaussPoolingDataSource.setDataSourceName(dataSourceName);
        this.loadGSBaseDataSource(gaussPoolingDataSource, reference);
        String minConnNum = this.getProperty(reference, "initialConnections");
        if (minConnNum != null) {
            gaussPoolingDataSource.setInitialConnections(Integer.parseInt(minConnNum));
        }
        if ((maxConnNum = this.getProperty(reference, "maxConnections")) != null) {
            gaussPoolingDataSource.setMaxConnections(Integer.parseInt(maxConnNum));
        }
        return gaussPoolingDataSource;
    }

    private Object loadGSSimpleDataSource(Reference reference) {
        GSSimpleDataSource ds = new GSSimpleDataSource();
        return this.loadGSBaseDataSource(ds, reference);
    }

    private Object loadGSConnectionPool(Reference reference) {
        GSConnectionPoolDataSource cp = new GSConnectionPoolDataSource();
        return this.loadGSBaseDataSource(cp, reference);
    }

    protected Object loadGSBaseDataSource(GSDataSourceBase dataSource, Reference reference) {
        dataSource.setDatabaseName(this.getProperty(reference, "databaseName"));
        dataSource.setPasswd(this.getProperty(reference, "password"));
        String port = this.getProperty(reference, "portNumber");
        if (port != null) {
            dataSource.setPortNum(Integer.parseInt(port));
        }
        dataSource.setServerName(this.getProperty(reference, "serverName"));
        dataSource.setUserName(this.getProperty(reference, "user"));
        String isExplicitUrl = this.getProperty(reference, "explicitUrl");
        if (isExplicitUrl != null && Boolean.valueOf(isExplicitUrl).booleanValue()) {
            dataSource.setUrl(this.getProperty(reference, "url"));
        }
        return dataSource;
    }

    protected String getProperty(Reference reference, String stringName) {
        RefAddr addrRef = reference.get(stringName);
        if (addrRef == null) {
            return null;
        }
        return (String)addrRef.getContent();
    }
}

