/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.datasource;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussCallableStatement;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussPrepareStatement;
import com.huawei.gauss.jdbc.GaussStatement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class GSPooledConnection
implements PooledConnection {
    private static final int[] FATAL_ERRS = new int[]{302, 303, 304, 305, 306, 312, 313, 321, 322, 327, 328, 329, 330, 331};
    private final List<ConnectionEventListener> listeners = new LinkedList<ConnectionEventListener>();
    private Connection gsConn;
    private GaussConnectionHandler logicConnHandle;
    private final boolean autoCommit;
    private final boolean isXA;

    public GSPooledConnection(Connection con, boolean autoCommit, boolean isXA) {
        this.gsConn = con;
        this.autoCommit = autoCommit;
        this.isXA = isXA;
    }

    public GSPooledConnection(Connection gsConn, boolean autoCommit) {
        this(gsConn, autoCommit, false);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    @Override
    public void close() throws SQLException {
        if (this.gsConn == null) {
            return;
        }
        if (this.logicConnHandle != null) {
            this.logicConnHandle.close();
            if (!this.gsConn.isClosed() && !this.gsConn.getAutoCommit()) {
                try {
                    this.gsConn.rollback();
                }
                catch (SQLException ignored) {
                    ExceptionUtil.handleUnThrowException("Exception occur when rollback", ignored);
                }
            }
        }
        try {
            this.gsConn.close();
        }
        catch (SQLException ignored) {
            ExceptionUtil.handleUnThrowException("Exception occur when close connection", ignored);
        }
        finally {
            this.gsConn = null;
        }
    }

    private void restWrappedConnection() throws SQLException {
        if (!this.gsConn.getAutoCommit()) {
            try {
                this.gsConn.rollback();
            }
            catch (SQLException ignored) {
                ExceptionUtil.handleUnThrowException("Exception occur when rollback", ignored);
            }
        }
        this.gsConn.clearWarnings();
    }

    @Override
    public Connection getConnection() throws SQLException {
        GaussConnectionHandler connHandler;
        if (this.gsConn == null) {
            SQLException sqlException = new SQLException("This PooledConnection has already been closed.");
            this.notifyConnectionFatalError(sqlException);
            throw sqlException;
        }
        try {
            if (this.logicConnHandle != null) {
                this.logicConnHandle.close();
                this.restWrappedConnection();
            }
            if (!this.isXA) {
                this.gsConn.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException sqlException) {
            this.notifyConnectionFatalError(sqlException);
            throw (SQLException)sqlException.fillInStackTrace();
        }
        this.logicConnHandle = connHandler = new GaussConnectionHandler(this.gsConn);
        Connection proxyCon = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{GaussConnection.class}, (InvocationHandler)connHandler);
        this.logicConnHandle.setProxy(proxyCon);
        return proxyCon;
    }

    void notifyConnectionClosed() {
        ConnectionEventListener[] tmp = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        if (tmp.length > 0) {
            ConnectionEvent evt = this.createConnectionEvent(null);
            for (ConnectionEventListener listener : tmp) {
                listener.connectionClosed(evt);
            }
        }
    }

    void notifyConnectionFatalError(SQLException e) {
        ConnectionEventListener[] tmp = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        if (tmp.length > 0) {
            ConnectionEvent evt = this.createConnectionEvent(e);
            for (ConnectionEventListener listener : tmp) {
                listener.connectionErrorOccurred(evt);
            }
        }
    }

    protected ConnectionEvent createConnectionEvent(SQLException e) {
        return new ConnectionEvent(this, e);
    }

    private static boolean isFatalGSErr(int errCode) {
        for (int fatalClass : FATAL_ERRS) {
            if (errCode != fatalClass) continue;
            return true;
        }
        return false;
    }

    private void handleConnError(SQLException excetion) {
        if (!GSPooledConnection.isFatalGSErr(excetion.getErrorCode())) {
            return;
        }
        this.notifyConnectionFatalError(excetion);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    private class GaussStatementHandler
    implements InvocationHandler {
        private GaussConnectionHandler connHandler;
        private Statement gaussStatememt;

        GaussStatementHandler(GaussConnectionHandler connHandler, Statement statement) {
            this.connHandler = connHandler;
            this.gaussStatememt = statement;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("toString")) {
                    return "PooledStatement wrapping physicalStatement " + this.gaussStatememt;
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                return method.invoke((Object)this.gaussStatememt, args);
            }
            if (methodName.equals("isClosed")) {
                return this.gaussStatememt == null || this.gaussStatememt.isClosed();
            }
            if (methodName.equals("close")) {
                if (this.gaussStatememt == null || this.gaussStatememt.isClosed()) {
                    return null;
                }
                this.connHandler = null;
                this.gaussStatememt.close();
                this.gaussStatememt = null;
                return null;
            }
            if (this.gaussStatememt == null || this.gaussStatememt.isClosed()) {
                throw new SQLException("The statement has been closed.");
            }
            if (methodName.equals("getConnection")) {
                return this.connHandler.getProxy();
            }
            try {
                return method.invoke((Object)this.gaussStatememt, args);
            }
            catch (InvocationTargetException exception) {
                Throwable targetException = exception.getTargetException();
                if (targetException instanceof SQLException) {
                    GSPooledConnection.this.handleConnError((SQLException)targetException);
                }
                throw targetException;
            }
        }
    }

    private class GaussConnectionHandler
    implements InvocationHandler {
        private Connection gsConn;
        private Connection proxy;
        private boolean isAutomaticClose = false;

        GaussConnectionHandler(Connection gsConn) {
            this.gsConn = gsConn;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                return this.processObject(method, methodName, args);
            }
            if (methodName.equals("isClosed")) {
                return this.gsConn == null || this.gsConn.isClosed();
            }
            if (methodName.equals("close")) {
                if (this.gsConn == null) {
                    return null;
                }
                this.closeFunction();
                return null;
            }
            try {
                this.checkConnectionStatus();
                if (methodName.equals("createStatement")) {
                    Statement st = (Statement)method.invoke((Object)this.gsConn, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{GaussStatement.class}, (InvocationHandler)new GaussStatementHandler(this, st));
                }
                if (methodName.equals("prepareCall")) {
                    Statement st = (Statement)method.invoke((Object)this.gsConn, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{GaussCallableStatement.class}, (InvocationHandler)new GaussStatementHandler(this, st));
                }
                if (methodName.equals("prepareStatement")) {
                    Statement st = (Statement)method.invoke((Object)this.gsConn, args);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{GaussPrepareStatement.class}, (InvocationHandler)new GaussStatementHandler(this, st));
                }
                return method.invoke((Object)this.gsConn, args);
            }
            catch (InvocationTargetException exception) {
                Throwable temp = exception.getTargetException();
                if (temp instanceof SQLException) {
                    GSPooledConnection.this.handleConnError((SQLException)temp);
                }
                throw temp;
            }
        }

        Connection getProxy() {
            return this.proxy;
        }

        void setProxy(Connection proxy) {
            this.proxy = proxy;
        }

        public void close() {
            if (this.gsConn != null) {
                this.isAutomaticClose = true;
            }
            this.gsConn = null;
            this.proxy = null;
        }

        private Object processObject(Method method, String methodName, Object[] args) throws Throwable {
            Object result;
            if (methodName.equals("equals")) {
                result = this.proxy == args[0];
            } else if (methodName.equals("hashCode")) {
                result = System.identityHashCode(this.proxy);
            } else if (methodName.equals("toString")) {
                result = "Pooled connection wrapping physical connection " + this.gsConn;
            } else {
                try {
                    result = method.invoke((Object)this.gsConn, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return result;
        }

        private void closeFunction() throws SQLException {
            SQLException ex = null;
            if (!this.gsConn.isClosed()) {
                if (!GSPooledConnection.this.isXA && !this.gsConn.getAutoCommit()) {
                    try {
                        this.gsConn.rollback();
                    }
                    catch (SQLException e) {
                        ex = e;
                    }
                }
                this.gsConn.clearWarnings();
            }
            this.gsConn = null;
            this.proxy = null;
            GSPooledConnection.this.logicConnHandle = null;
            GSPooledConnection.this.notifyConnectionClosed();
            if (ex != null) {
                throw ex;
            }
        }

        private void checkConnectionStatus() throws SQLException {
            if (this.gsConn == null || this.gsConn.isClosed()) {
                throw new SQLException(this.isAutomaticClose ? "Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed." : "Connection has been closed.");
            }
        }
    }
}

