/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.datasource;

import com.huawei.gauss.datasource.GSConnectionPoolDataSource;
import com.huawei.gauss.datasource.GSDataSourceBase;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.inner.GaussDatabaseMetaDataImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class GSPoolingDataSource
extends GSDataSourceBase
implements DataSource {
    protected static final ConcurrentMap<String, GSPoolingDataSource> DATASOURCES = new ConcurrentHashMap<String, GSPoolingDataSource>();
    protected String dsName;
    private int initialConnNum = 0;
    private int maxConnNum = 0;
    private List<PooledConnection> idleList = new LinkedList<PooledConnection>();
    private List<PooledConnection> usedList = new LinkedList<PooledConnection>();
    private boolean isInitialized = false;
    private final Object connPoolLock = new Object();
    private GSConnectionPoolDataSource gaussConnPoolDatasource;
    private ConnectionEventListener connEventListener = new ConnectionEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(ConnectionEvent connEvent) {
            ((PooledConnection)connEvent.getSource()).removeConnectionEventListener(this);
            Object object = GSPoolingDataSource.this.connPoolLock;
            synchronized (object) {
                if (GSPoolingDataSource.this.idleList == null) {
                    return;
                }
                if (GSPoolingDataSource.this.usedList.remove(connEvent.getSource())) {
                    GSPoolingDataSource.this.idleList.add((PooledConnection)connEvent.getSource());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionErrorOccurred(ConnectionEvent connEvent) {
            ((PooledConnection)connEvent.getSource()).removeConnectionEventListener(this);
            Object object = GSPoolingDataSource.this.connPoolLock;
            synchronized (object) {
                if (GSPoolingDataSource.this.idleList == null) {
                    return;
                }
                GSPoolingDataSource.this.usedList.remove(connEvent.getSource());
            }
        }
    };

    public static GSPoolingDataSource getDataSource(String name) {
        return (GSPoolingDataSource)DATASOURCES.get(name);
    }

    @Override
    public String getDescription() {
        return "Pooling DataSource '" + this.dsName + " from Zenith-JDBC " + GaussDatabaseMetaDataImpl.getVersionString();
    }

    @Override
    public void setServerName(String dsServerName) {
        this.checkState();
        super.setServerName(dsServerName);
    }

    @Override
    public void setDatabaseName(String dbName) {
        this.checkState();
        super.setDatabaseName(dbName);
    }

    @Override
    public void setUserName(String userName) {
        this.checkState();
        super.setUserName(userName);
    }

    @Override
    public void setPasswd(String passwd) {
        this.checkState();
        super.setPasswd(passwd);
    }

    @Override
    public void setPortNum(int port) {
        this.checkState();
        super.setPortNum(port);
    }

    public int getInitialConnections() {
        return this.initialConnNum;
    }

    public void setInitialConnections(int iniConnNum) {
        this.checkState();
        this.initialConnNum = iniConnNum;
    }

    public int getMaxConnections() {
        return this.maxConnNum;
    }

    public void setMaxConnections(int maxConnectionNum) {
        this.checkState();
        this.maxConnNum = maxConnectionNum;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setDataSourceName(String dataSourceName) {
        GSPoolingDataSource ds;
        this.checkState();
        if (this.dsName != null && dataSourceName != null && dataSourceName.equals(this.dsName)) {
            return;
        }
        GSPoolingDataSource gSPoolingDataSource = ds = dataSourceName == null ? null : DATASOURCES.putIfAbsent(dataSourceName, this);
        if (ds != null) {
            throw new IllegalArgumentException("DataSource with name '" + dataSourceName + "' already exists!");
        }
        if (this.dsName != null) {
            DATASOURCES.remove(this.dsName);
        }
        this.dsName = dataSourceName;
    }

    private void checkState() {
        if (this.checkInitialized()) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDS() throws SQLException {
        Object object = this.connPoolLock;
        synchronized (object) {
            this.gaussConnPoolDatasource = this.createConnectionPool();
            this.gaussConnPoolDatasource.initializeFrom(this);
            while (this.idleList.size() < this.initialConnNum) {
                this.idleList.add(this.gaussConnPoolDatasource.getPooledConnection());
            }
            this.isInitialized = true;
        }
    }

    protected boolean checkInitialized() {
        return this.isInitialized;
    }

    protected GSConnectionPoolDataSource createConnectionPool() {
        return new GSConnectionPoolDataSource();
    }

    @Override
    public Connection getConnection(String userName, String passwd) throws SQLException {
        if (userName == null || userName.equals(this.getUserName()) && (passwd == null && this.getPasswd() == null || passwd != null && passwd.equals(this.getPasswd()))) {
            return this.getConnection();
        }
        if (!this.checkInitialized()) {
            this.initializeDS();
        }
        return super.getConnection(userName, passwd);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.checkInitialized()) {
            this.initializeDS();
        }
        return this.getPooledConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connPoolLock;
        synchronized (object) {
            if (this.idleList == null) {
                return;
            }
            PooledConnection poolConn = null;
            while (!this.idleList.isEmpty()) {
                poolConn = this.idleList.remove(0);
                try {
                    poolConn.close();
                }
                catch (SQLException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when connection close", e);
                }
            }
            this.idleList = null;
            while (!this.usedList.isEmpty()) {
                poolConn = this.usedList.remove(0);
                poolConn.removeConnectionEventListener(this.connEventListener);
                try {
                    poolConn.close();
                }
                catch (SQLException e) {
                    ExceptionUtil.handleUnThrowException("Exception occur when connection close", e);
                }
            }
            this.usedList = null;
        }
        this.removeStoredDs();
    }

    protected void removeStoredDs() {
        DATASOURCES.remove(this.dsName);
    }

    protected void addDataSource(String dataSourName) {
        DATASOURCES.put(dataSourName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection() throws SQLException {
        PooledConnection poolConn = null;
        Object object = this.connPoolLock;
        synchronized (object) {
            if (this.idleList == null) {
                throw new SQLException("DataSource has been closed.");
            }
            if (!this.idleList.isEmpty()) {
                poolConn = this.idleList.get(0);
                this.usedList.add(poolConn);
            } else if (this.maxConnNum == 0 || this.usedList.size() < this.maxConnNum) {
                poolConn = this.gaussConnPoolDatasource.getPooledConnection();
                this.usedList.add(poolConn);
            } else {
                throw new SQLException("Get connection from pool failed, because connection count has exceed the maxConnections, maxConnections=." + this.maxConnNum);
            }
        }
        poolConn.addConnectionEventListener(this.connEventListener);
        return poolConn.getConnection();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference refInstance = super.getReference();
        refInstance.add(new StringRefAddr("dataSourceName", this.dsName));
        if (this.initialConnNum > 0) {
            refInstance.add(new StringRefAddr("initialConnections", Integer.toString(this.initialConnNum)));
        }
        if (this.maxConnNum > 0) {
            refInstance.add(new StringRefAddr("maxConnections", Integer.toString(this.maxConnNum)));
        }
        return refInstance;
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceParam) throws SQLException {
        return interfaceParam.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> interfaceParam) throws SQLException {
        if (interfaceParam.isAssignableFrom(this.getClass())) {
            return interfaceParam.cast(this);
        }
        throw new SQLException("Could not unwrap to " + interfaceParam.getName());
    }
}

