/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.connection.inner;

import com.huawei.gauss.channel.CHandlerContext;
import com.huawei.gauss.channel.context.connection.CloseConnectionContext;
import com.huawei.gauss.channel.context.connection.CommitContext;
import com.huawei.gauss.channel.context.connection.DoConnectContext;
import com.huawei.gauss.channel.context.connection.RollbackContext;
import com.huawei.gauss.channel.context.connection.XAcommitContext;
import com.huawei.gauss.channel.context.connection.XAendContext;
import com.huawei.gauss.channel.context.connection.XAprepareContext;
import com.huawei.gauss.channel.context.connection.XArollbackContext;
import com.huawei.gauss.channel.context.connection.XAstartContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.connection.DefaultConnectionCHandler;
import com.huawei.gauss.handler.inner.GmdbMessageProcessHelper;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.IGaussDriver;
import com.huawei.gauss.jdbc.inner.message.gmdb.AbstractCommonResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.CommitRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.CommitResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.DynamicByteBuffer;
import com.huawei.gauss.jdbc.inner.message.gmdb.HandshakeRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.HandshakeResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.LoginRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.LoginResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.LogoutRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.RollbackRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.RollbackResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAcommitResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAcommitResquest;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAendRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAendResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAprepareRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAprepareResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.XArollbackRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.XArollbackResponse;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAstartRequest;
import com.huawei.gauss.jdbc.inner.message.gmdb.XAstartResponse;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;

public class ConnGmdbMsgProcessCHandler
extends DefaultConnectionCHandler {
    private GmdbMessageProcessHelper gmdbMessageProcessHelper;

    public ConnGmdbMsgProcessCHandler(IGaussDriver gaussDriver) {
        super(gaussDriver);
    }

    @Override
    protected void init(DoConnectContext context) {
        super.init(context);
        this.gmdbMessageProcessHelper = new GmdbMessageProcessHelper(this.configManager);
        this.gaussConnection.setGmdbMessageProcessHelper(this.gmdbMessageProcessHelper);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(DoConnectContext context) throws SQLException {
        this.init(context);
        this.gmdbMessageProcessHelper.sendloginMessage(this, context);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    @Override
    public CHandlerContext.ProcessState preExecute(CommitContext commitContext) throws SQLException {
        CommitRequest request = new CommitRequest(this.ioClient.getZenithConnectionId(), this.gaussConnection, commitContext);
        CommitResponse response = new CommitResponse(this.gaussConnection, commitContext);
        return this.gmdbMessageProcessHelper.doExecute(request, response);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(RollbackContext rollbackContext) throws SQLException {
        RollbackRequest request = new RollbackRequest(this.ioClient.getZenithConnectionId(), this.gaussConnection, rollbackContext);
        RollbackResponse response = new RollbackResponse(this.gaussConnection, rollbackContext);
        return this.gmdbMessageProcessHelper.doExecute(request, response);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(CloseConnectionContext closeConnectionContext) throws SQLException {
        LogoutRequest request = new LogoutRequest(this.gaussConnection, closeConnectionContext);
        this.gmdbMessageProcessHelper.sendCloseConnMessage(request);
        return CHandlerContext.ProcessState.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doGSQLProtocolDiag() throws SQLException {
        byte[] gsProtocal = new byte[]{-2, -36, -70, -104};
        IOClient ioClient = this.gaussConnection.getIOClient();
        DynamicByteBuffer encodeBuffer = null;
        try {
            encodeBuffer = new DynamicByteBuffer(ioClient.getByteOrder(), this.configManager.getBufferSegmentSize());
            encodeBuffer.put(gsProtocal);
            encodeBuffer.flip();
            ioClient.write(encodeBuffer);
        }
        finally {
            if (null != encodeBuffer) {
                encodeBuffer.clear();
            }
        }
        ByteBuffer protocolAck = ByteBuffer.allocate(4);
        ioClient.read(protocolAck);
        protocolAck.rewind();
        byte serverEndian = protocolAck.get();
        if (serverEndian == 1) {
            ioClient.setByteOrder(ByteOrder.BIG_ENDIAN);
            protocolAck.order(ByteOrder.BIG_ENDIAN);
        } else {
            ioClient.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            protocolAck.order(ByteOrder.LITTLE_ENDIAN);
        }
        byte serverVersion = protocolAck.get();
        ioClient.setServerVersion(serverVersion);
        if (serverVersion >= 5) {
            return protocolAck.getShort();
        }
        return 0;
    }

    private JDBCException buildServerErrorException(AbstractCommonResponse responseMsg, String sqlState) {
        JDBCException exception = ExceptionUtil.processJDBCException(responseMsg.getErrorMsg(), sqlState, responseMsg.getErrCode());
        exception.setZenithServerIp(this.ioClient.getZenithUrl());
        exception.setSessionId(this.ioClient.getSessionId());
        return exception;
    }

    public HandshakeResponse doHandshake(int sslFlag, DoConnectContext context) throws SQLException {
        HandshakeRequest handshakeReq = new HandshakeRequest(sslFlag, this.gaussConnection, context);
        HandshakeResponse handshakeAck = new HandshakeResponse(handshakeReq.getClientKey(), this.gaussConnection, context);
        int clientFlag = this.ioClient.getClientFlag();
        int serverCapabilities = this.ioClient.getServerCapabilities();
        if ((serverCapabilities & 0x200) == 0 && this.ioClient.getUseSSL()) {
            if (this.ioClient.getRequireSSL()) {
                this.forceClose();
                throw new JDBCException("Client SSL is required but server don't support it", "08001", 333);
            }
            this.ioClient.setUseSSL(false);
            clientFlag &= 0xFFFFFDFF;
        }
        clientFlag = !this.ioClient.getUseSSL() ? (clientFlag &= 0xFFFFFDFF) : (clientFlag |= 0x200);
        this.ioClient.setClientFlag(clientFlag);
        try {
            this.gmdbMessageProcessHelper.sendMessage(handshakeReq);
            if (this.ioClient.getUseSSL()) {
                ByteBuffer sslNotify = ByteBuffer.allocate(4);
                this.ioClient.read(sslNotify);
                this.ioClient.negotiateSSLConnection();
            }
            this.gmdbMessageProcessHelper.getMessage(handshakeAck);
            if (this.ioClient.getServerVersion() >= 9) {
                this.gmdbMessageProcessHelper.sendAndWaitMessage(handshakeReq.getAuthInitRequest(), handshakeAck);
            }
        }
        catch (Exception e) {
            throw new JDBCException("Login to zenith server failed.", e);
        }
        if (handshakeAck.isError()) {
            throw this.buildServerErrorException(handshakeAck, "28000");
        }
        return handshakeAck;
    }

    public void doGaussLogin(DoConnectContext context, HandshakeResponse ack) throws SQLException {
        String userName = this.gaussConnection.getClientInfo("user");
        String password = this.gaussConnection.getClientInfo("password");
        this.gaussConnection.getIOClient().setLocalUsr(userName);
        if (userName == null || password == null) {
            throw ExceptionUtil.objectIsNullException("username and password can't be null.");
        }
        LoginRequest loginRequest = new LoginRequest(userName, password, ack.getScrambleKey(), ack.getIteration(), this.gaussConnection, context);
        LoginResponse response = new LoginResponse(loginRequest, this.gaussConnection, context);
        try {
            this.gmdbMessageProcessHelper.sendAndWaitMessage(loginRequest, response);
        }
        catch (SQLException e) {
            throw new JDBCException("Login to zenith failed.", e);
        }
        if (response.isError()) {
            throw this.buildServerErrorException(response, "28000");
        }
    }

    private void forceClose() {
        try {
            this.ioClient.close();
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when ioClient close", e);
        }
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAprepareContext xaPrepareContext) throws SQLException {
        XAprepareRequest request = new XAprepareRequest(this.gaussConnection, xaPrepareContext);
        XAprepareResponse response = new XAprepareResponse(this.gaussConnection, xaPrepareContext);
        return this.gmdbMessageProcessHelper.doExecute(request, response);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAcommitContext xaCommitContext) throws SQLException {
        XAcommitResquest request = new XAcommitResquest(this.gaussConnection, xaCommitContext);
        XAcommitResponse response = new XAcommitResponse(this.gaussConnection, xaCommitContext);
        return this.gmdbMessageProcessHelper.doExecute(request, response);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XArollbackContext xaRollbackContext) throws SQLException {
        XArollbackRequest request = new XArollbackRequest(this.gaussConnection, xaRollbackContext);
        XArollbackResponse response = new XArollbackResponse(this.gaussConnection, xaRollbackContext);
        return this.gmdbMessageProcessHelper.doExecute(request, response);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAstartContext xaStartContext) throws SQLException {
        XAstartRequest request = new XAstartRequest(this.gaussConnection, xaStartContext);
        XAstartResponse response = new XAstartResponse(this.gaussConnection, xaStartContext);
        return this.gmdbMessageProcessHelper.doExecute(request, response);
    }

    @Override
    public CHandlerContext.ProcessState preExecute(XAendContext xaEndContext) throws SQLException {
        XAendRequest request = new XAendRequest(this.gaussConnection, xaEndContext);
        XAendResponse response = new XAendResponse(this.gaussConnection, xaEndContext);
        return this.gmdbMessageProcessHelper.doExecute(request, response);
    }
}

