/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.factory.impl;

import com.huawei.gauss.handler.ChannelHandler;
import com.huawei.gauss.handler.connection.inner.ConnGmdbMsgProcessCHandler;
import com.huawei.gauss.handler.connection.inner.ConnParamValidateCHandler;
import com.huawei.gauss.handler.connection.inner.ConnStmtManageCHandler;
import com.huawei.gauss.handler.factory.ChannelHandlerFactory;
import com.huawei.gauss.handler.preparestmt.inner.PrepareStmtGmdbMsgProcessCHandler;
import com.huawei.gauss.handler.resultset.inner.ResultGmdbMsgProcessCHandler;
import com.huawei.gauss.handler.statement.inner.StmtGmdbMsgProcessCHandler;
import com.huawei.gauss.handler.statement.inner.StmtParamValidateCHandler;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.IGaussDriver;
import java.util.List;

public class DefaultChannelHandlerFactory
implements ChannelHandlerFactory {
    private final IGaussDriver gaussDriver;

    public DefaultChannelHandlerFactory(IGaussDriver gaussDriver) {
        this.gaussDriver = gaussDriver;
    }

    @Override
    public List<ChannelHandler> createConnectionCHandlers(List<ChannelHandler> handlers) {
        handlers.add(new ConnParamValidateCHandler(this.gaussDriver));
        handlers.add(new ConnStmtManageCHandler(this.gaussDriver));
        handlers.add(new ConnGmdbMsgProcessCHandler(this.gaussDriver));
        return handlers;
    }

    @Override
    public List<ChannelHandler> createStatementCHandlers(List<ChannelHandler> handlers, GaussConnection gaussConnection) {
        handlers.add(new StmtParamValidateCHandler(this.gaussDriver, gaussConnection));
        handlers.add(new StmtGmdbMsgProcessCHandler(this.gaussDriver, gaussConnection));
        return handlers;
    }

    @Override
    public List<ChannelHandler> createPrepareStmtCHandlers(List<ChannelHandler> handlers, GaussConnection gaussConnection) {
        handlers.add(new PrepareStmtGmdbMsgProcessCHandler(this.gaussDriver, gaussConnection));
        return handlers;
    }

    @Override
    public List<ChannelHandler> createCallableStmtCHandlers(List<ChannelHandler> handlers, GaussConnection gaussConnection) {
        handlers.add(new PrepareStmtGmdbMsgProcessCHandler(this.gaussDriver, gaussConnection));
        return handlers;
    }

    @Override
    public List<ChannelHandler> createResultSetCHandlers(List<ChannelHandler> handlers, GaussConnection gaussConnection) {
        handlers.add(new ResultGmdbMsgProcessCHandler(gaussConnection));
        return handlers;
    }
}

