/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.handler.inner.IOClientFactory;
import com.huawei.gauss.handler.inner.IOClientImpl;
import com.huawei.gauss.jdbc.IGaussDriver;
import com.huawei.gauss.om.ConfigManager;
import java.io.IOException;
import java.net.SocketAddress;

public class IOClientFactoryImpl
implements IOClientFactory {
    private final ConfigManager configManager;

    public IOClientFactoryImpl(IGaussDriver gaussDriver) {
        this.configManager = gaussDriver.getConfigManager();
    }

    @Override
    public IOClient getIOClient(SocketAddress address) {
        return new IOClientImpl(this.configManager, address);
    }

    @Override
    public void releaseIOClient(IOClient ioClient) {
        try {
            ioClient.close();
        }
        catch (IOException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when close ioClient", e);
        }
    }
}

