/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.handler.statement;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.IGaussDriver;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class CancelTimerTask
extends TimerTask {
    protected static final AtomicInteger CANCELED_TASKES_NUM = new AtomicInteger(0);
    protected static final int NEED_PURGE_NUM = 1000;
    final IGaussDriver gaussDriver;
    final String gaussNode;
    final int sessionId;
    final int serialNumber;
    final int seqNo;
    final String usr;

    public CancelTimerTask(IGaussDriver gaussDriver, String gaussNode, int sessId, int seriNumber, int seqNum, String LocalUsr) {
        this.gaussDriver = gaussDriver;
        this.gaussNode = gaussNode;
        this.sessionId = sessId;
        this.serialNumber = seriNumber;
        this.seqNo = seqNum;
        this.usr = LocalUsr;
    }

    @Override
    public void run() {
        try {
            this.gaussDriver.cancel(this.gaussNode, this.sessionId, this.serialNumber, this.seqNo, this.usr);
        }
        catch (Throwable ignore) {
            ExceptionUtil.handleUnThrowException("Exception occur when execute timeout cancle", ignore);
        }
    }

    @Override
    public boolean cancel() {
        if (CANCELED_TASKES_NUM.incrementAndGet() >= 1000) {
            CANCELED_TASKES_NUM.set(0);
            this.gaussDriver.getCancelTimer().purge();
        }
        return super.cancel();
    }
}

