/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussResultSet;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.util.BytesUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;

public abstract class AbstractGaussLob {
    public static final int LOB_TYPE_IDX = 4;
    public static final int LOB_OUT_LINE_IDX = 8;
    public static final int SIZE_OFFSET_IN_HANDLER = 0;
    public static final int FETCH_SIZE_PER_TIME = 64512;
    public static final int LOB_LOCATOR_BUFFER_SIZE = 40;
    public static final int LOB_VAR_SIZE = 16;
    public static final int LOB_HEAD_SIZE = 12;
    public static final int HAS_NEXT_VALUE = 1;
    public static final int MAX_DATA_LENGTH = 8192;
    public static final int DIRECT_BIND_MAX_LEN = 4000;
    protected int posIndex = 1;
    protected int bindPos = 0;
    protected GaussStatement gaussStatement;
    protected GaussResultSet gaussRes;
    protected boolean hasFree;
    protected int serverOffset;
    protected boolean hasNext;
    protected int length;
    protected ByteBuffer buffer;
    protected int totalSize = 0;
    protected int lobType = 1;
    protected int entryVmid = -1;
    protected int lastVmid = -1;
    protected byte[] lobHandler = null;

    protected AbstractGaussLob() {
        this.buffer = ByteBuffer.allocate(8192);
    }

    public void resetParameter() {
        this.length = 0;
        this.entryVmid = -1;
        this.lastVmid = -1;
        this.totalSize = 0;
        this.lobHandler = null;
    }

    protected AbstractGaussLob(byte[] data, int size) {
        this.lobHandler = data;
        this.buffer = ByteBuffer.allocate(size);
        this.hasNext = true;
    }

    public void setStatement(GaussStatement gaussStatement) {
        this.gaussStatement = gaussStatement;
    }

    public byte get() throws SQLException {
        if (!this.buffer.hasRemaining() || this.serverOffset == 0) {
            if (this.hasNext) {
                this.buffer.clear();
                this.fetchDataFromServer();
                this.serverOffset += this.buffer.position();
                this.buffer.flip();
            } else {
                return -1;
            }
        }
        return this.buffer.get();
    }

    protected abstract void fetchDataFromServer() throws SQLException;

    public abstract void flushAllDataToServer() throws SQLException;

    protected abstract void flushRestBuffer(boolean var1) throws SQLException;

    protected void save(int pos, ByteBuffer data, boolean force) throws SQLException {
        try {
            this.buffer.mark();
            this.buffer.position(pos);
            int srcLimit = data.limit();
            while (data.hasRemaining()) {
                int srcRemain;
                int destRemain = this.buffer.remaining();
                int remain = destRemain > (srcRemain = data.remaining()) ? srcRemain : destRemain;
                int newLimit = data.position() + remain;
                data.limit(newLimit);
                this.buffer.put(data);
                data.limit(srcLimit);
                if (this.buffer.hasRemaining()) continue;
                this.saveDataToServer();
            }
            if (force && this.buffer.position() != 0) {
                this.saveDataToServer();
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            IOClient ioClient = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient();
            JDBCException exception = ExceptionUtil.processJDBCException("Save lob error.", "42S22", 666, e);
            exception.setZenithServerIp(ioClient.getZenithUrl());
            exception.setSessionId(ioClient.getSessionId());
            throw exception;
        }
    }

    public abstract void saveDataToServer() throws SQLException;

    protected void hasFreed() throws SQLException {
        if (this.hasFree) {
            throw ExceptionUtil.processJDBCException("Has been free.Invalid operation on closed LOB!");
        }
    }

    protected boolean tryFetchDataDirect(byte[] binaryData) throws SQLException {
        boolean hasLobData = false;
        IOClient ioClient = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient();
        if (ioClient.getCallVersion() >= 3) {
            int outLineInt = BytesUtil.toInt(this.lobHandler, 8, ioClient.isBigEndian());
            int lobLocatorType = BytesUtil.toInt(this.lobHandler, 4, ioClient.isBigEndian());
            boolean bl = hasLobData = (outLineInt & 1) == 0 && lobLocatorType == 0;
        }
        if (hasLobData) {
            System.arraycopy(this.lobHandler, 12, binaryData, 0, this.length);
        }
        return hasLobData;
    }

    public GaussStatement getStatement() {
        return this.gaussStatement;
    }

    public byte[] getSaveData(int needLen) {
        int giveLen = needLen > this.buffer.position() ? this.buffer.position() : needLen;
        byte[] data = new byte[giveLen];
        this.buffer.flip();
        this.length += data.length;
        this.serverOffset += data.length;
        this.buffer.get(data);
        byte[] leftData = BytesUtil.EMPTY;
        if (this.buffer.hasRemaining()) {
            leftData = new byte[this.buffer.remaining()];
            this.buffer.get(leftData);
        }
        this.buffer.clear();
        this.buffer.put(leftData);
        return data;
    }

    public byte[] getLobVar(boolean isBigEndianess) {
        ByteBuffer ba = ByteBuffer.allocate(16);
        if (isBigEndianess) {
            ba.order(ByteOrder.BIG_ENDIAN);
        } else {
            ba.order(ByteOrder.LITTLE_ENDIAN);
        }
        ba.put(BytesUtil.getBytes(this.totalSize, isBigEndianess));
        ba.put(BytesUtil.getBytes(this.lobType, isBigEndianess));
        ba.put(BytesUtil.getBytes(this.entryVmid, isBigEndianess));
        ba.put(BytesUtil.getBytes(this.lastVmid, isBigEndianess));
        return ba.array();
    }

    public void setResultSet(GaussResultSet resultSet) throws SQLException {
        this.gaussRes = resultSet;
        this.gaussStatement = (GaussStatement)this.gaussRes.getStatement();
    }

    public int getServerOffset() {
        return this.serverOffset;
    }

    public void setHasNext(int hasNext) {
        this.hasNext = hasNext == 1;
    }

    public ByteBuffer getReceiveBuffer() {
        return this.buffer;
    }

    protected void validatePos(int pos) throws SQLException {
        if (pos < 1) {
            JDBCException exception = ExceptionUtil.illegalJDBCArgumentException("Pos is less than 1 which is illegal, pos value is [" + pos + "].");
            throw exception;
        }
    }

    public byte[] getLobHandler() {
        return this.lobHandler;
    }

    public void setBindPos(int bindPos) {
        this.bindPos = bindPos;
    }

    public int getBindPos() {
        return this.bindPos;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getLobType() {
        return this.lobType;
    }

    public int getEntryVMID() {
        return this.entryVmid;
    }

    public int getLastVMID() {
        return this.lastVmid;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void setLobType(int lobType) {
        this.lobType = lobType;
    }

    public void setEntryVMID(int entryVmidIn) {
        this.entryVmid = entryVmidIn;
    }

    public void setLastVMID(int lastVmidIn) {
        this.lastVmid = lastVmidIn;
    }

    protected void validateOffset(int offset) throws SQLException {
        if (offset < 0) {
            JDBCException exception = ExceptionUtil.illegalJDBCArgumentException(" 'offset' should not be < 0.");
            throw exception;
        }
    }

    protected void validateLength(String str, int offset, int lengthIn) throws SQLException {
        if (lengthIn < 0) {
            JDBCException exception = ExceptionUtil.illegalJDBCArgumentException("length should not be < 0.");
            throw exception;
        }
        long temLen = (long)offset + (long)lengthIn;
        if (temLen > (long)str.length()) {
            JDBCException exception = ExceptionUtil.illegalJDBCArgumentException(" 'offset + len' should not be exceed string length. ");
            throw exception;
        }
    }
}

