/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussSubDriverAbstract;
import com.huawei.gauss.util.lang.StringUtils;
import java.sql.SQLException;
import java.util.Properties;

public interface GaussNodeInfo {
    public static final int IP_PORT_ARR_LEN = 2;

    public String getNodeIp();

    public void setNodeIp(String var1);

    public String getNodePort();

    public void setNodePort(String var1);

    public String getIpAndPort();

    public void setIpAndPort(String var1);

    public boolean isCluster();

    public void setCluster();

    public GaussConnectionImpl createConnection(GaussSubDriverAbstract var1, Properties var2) throws SQLException;

    default public String[] parseUrl(String url) throws SQLException {
        int portIndex = StringUtils.lastIndexOf(url, ":");
        int prefixIndex = StringUtils.lastIndexOf(url, "@");
        if (prefixIndex >= portIndex || portIndex == -1) {
            throw ExceptionUtil.processJDBCException("Invalid url [" + url + "].", "S1009", 503);
        }
        String[] ipAndPort = new String[]{StringUtils.substring(url, prefixIndex + 1, portIndex), StringUtils.substring(url, portIndex + 1)};
        return ipAndPort;
    }
}

