/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.jdbc.GaussClob;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.inner.GaussClobWriterImpl;
import com.huawei.gauss.jdbc.inner.GaussLobHelper;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.sql.Clob;
import java.sql.SQLException;

public class GaussClobImpl
extends AbstractGaussLob
implements GaussClob {
    CharBuffer charBuffer;
    private String charData;

    GaussClobImpl() {
        this.charData = "";
        this.charBuffer = CharBuffer.allocate(4000);
    }

    GaussClobImpl(byte[] data, int length) {
        super(data, length);
        this.charBuffer = CharBuffer.allocate(length);
        this.length = length;
        this.charData = "";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public long length() throws SQLException {
        if (this.charData != null) {
            return this.charData.length();
        }
        return 0L;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getSubString(long pos, int length) throws SQLException {
        this.validatePos((int)pos);
        if (length < 0) {
            throw ExceptionUtil.illegalJDBCArgumentException("Length is less than 0. Length value is [" + length + "].");
        }
        int adjustedStartPos = (int)pos - 1;
        int adjustedEndIndex = adjustedStartPos + length;
        if (this.charData != null) {
            if (adjustedEndIndex > this.charData.length()) {
                throw ExceptionUtil.processJDBCException("The parameters is illegal,because [pos - 1]+ [length] > the lob'length.", "42S22", 666);
            }
            return this.charData.substring(adjustedStartPos, adjustedEndIndex);
        }
        return null;
    }

    public void fetchAllDataFromServer() throws SQLException {
        this.hasFreed();
        IOClient ioClient = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient();
        CharsetDecoder decoder = ioClient.getCharset().newDecoder();
        ByteBuffer allDataBuffer = ByteBuffer.allocate(this.length);
        byte[] binaryData = new byte[this.length];
        try {
            if (this.tryFetchDataDirect(binaryData)) {
                allDataBuffer.put(binaryData);
                allDataBuffer.flip();
                this.charBuffer.put(decoder.decode(allDataBuffer).asReadOnlyBuffer());
                this.charBuffer.flip();
                return;
            }
            if (this.buffer != null) {
                while (this.hasNext) {
                    this.buffer.clear();
                    GaussLobHelper.fetchDataFromServer(this.gaussRes, this);
                    this.serverOffset += this.buffer.position();
                    this.buffer.flip();
                    allDataBuffer.put(this.buffer);
                }
                allDataBuffer.flip();
                this.charBuffer.put(decoder.decode(allDataBuffer).asReadOnlyBuffer());
                this.charBuffer.flip();
            }
        }
        catch (CharacterCodingException e) {
            throw ExceptionUtil.processJDBCException("lob get String failed, it's not" + ioClient.getCharset().name() + " stream.", "42S22", 666, e);
        }
        catch (RuntimeException exception) {
            throw ExceptionUtil.processJDBCException("lob get String failed.", "42S22", 666, exception);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Reader getCharacterStream() throws SQLException {
        if (this.charData != null) {
            return new StringReader(this.charData);
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getAsciiStream()");
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("position(String,long)");
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("position(Clob,long)");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int setString(long pos, String str) throws SQLException {
        if (str == null) {
            return 0;
        }
        this.validatePos((int)pos);
        this.hasFreed();
        this.resetParameter();
        this.charBuffer = null;
        this.buffer.clear();
        StringBuffer charBuf = new StringBuffer(this.charData);
        long innerPos = pos - 1L;
        int strLength = str.length();
        charBuf.replace((int)innerPos, (int)(innerPos + (long)strLength), str);
        this.charData = charBuf.toString();
        return strLength;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (str == null) {
            return 0;
        }
        this.validatePos((int)pos);
        this.validateOffset(offset);
        this.validateLength(str, offset, len);
        this.hasFreed();
        this.resetParameter();
        this.charBuffer = null;
        this.buffer.clear();
        StringBuffer charBuf = new StringBuffer(this.charData);
        long innerPos = pos - 1L;
        String replaceString = str.substring(offset, offset + len);
        charBuf.replace((int)innerPos, (int)(innerPos + (long)replaceString.length()), replaceString);
        this.charData = charBuf.toString();
        return len;
    }

    @Override
    public void flushAllDataToServer() throws SQLException {
        this.setChars(this.charData.toCharArray(), 0, this.charData.length());
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("setAsciiStream(long)");
    }

    public void writerFlush(GaussClobWriterImpl writer) {
        String replaceStr = writer.toString();
        StringBuilder sb = new StringBuilder(this.charData);
        sb.replace(0, replaceStr.length(), replaceStr);
        this.charData = sb.toString();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Writer setCharacterStream(long pos) throws SQLException {
        this.validatePos((int)pos);
        this.hasFreed();
        this.charBuffer = null;
        this.buffer.clear();
        GaussClobWriterImpl writer = new GaussClobWriterImpl(this);
        try {
            if (pos > (long)(this.charData.length() + 1)) {
                JDBCException exception = ExceptionUtil.illegalJDBCArgumentException("Pos is illegal, because it is large than clob length, pos value is [" + pos + "].");
                throw exception;
            }
            writer.write(this.charData.substring(0, (int)(pos - 1L)));
        }
        catch (IOException e) {
            writer.close();
            throw new SQLException("setCharacterStream build Writer failed ", e);
        }
        return writer;
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("truncate(long)");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void free() throws SQLException {
        this.hasFree = true;
        this.buffer = null;
        this.charBuffer = null;
        this.charData = null;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("getCharacterStream(long,long)");
    }

    @Override
    protected void fetchDataFromServer() throws SQLException {
        this.hasFreed();
        GaussLobHelper.fetchDataFromServer(this.gaussRes, this);
    }

    @Override
    public int setChars(char[] src, int offset, int length) throws SQLException {
        int realLen = src.length - offset;
        int writenLen = length > realLen ? realLen : length;
        int writenOffset = offset;
        int restLen = writenLen;
        if (this.charBuffer == null) {
            this.charBuffer = CharBuffer.allocate(4000);
        }
        while (restLen > 0) {
            int remaining = this.charBuffer.remaining();
            int putLen = remaining > restLen ? restLen : remaining;
            this.charBuffer.put(src, writenOffset, putLen);
            writenOffset += putLen;
            restLen -= putLen;
            if (this.charBuffer.hasRemaining()) continue;
            this.flushRestBuffer(false);
        }
        this.flushRestBuffer(true);
        return writenLen;
    }

    @Override
    protected void flushRestBuffer(boolean force) throws SQLException {
        this.charBuffer.flip();
        IOClient ioClient = ((GaussConnection)this.gaussStatement.getConnection()).getIOClient();
        ByteBuffer byteBuffer = ioClient.getCharset().encode(this.charBuffer);
        this.save(this.buffer.position(), byteBuffer, force);
        this.charBuffer.clear();
    }

    @Override
    public void saveDataToServer() throws SQLException {
        GaussLobHelper.saveDataToServer(this);
    }

    @Override
    public String getContent() throws SQLException {
        this.fetchAllDataFromServer();
        return this.charBuffer.toString();
    }

    public void getLobString() throws SQLException {
        this.fetchAllDataFromServer();
        this.charData = this.charBuffer.toString();
    }
}

