/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.cluster.GaussClusterManager;
import com.huawei.gauss.cluster.api.GaussClusterNode;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.exception.JDBCException;
import com.huawei.gauss.handler.inner.GmdbMessageProcessHelper;
import com.huawei.gauss.handler.inner.IOClient;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussInfo;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.ChannelExecutor;
import com.huawei.gauss.jdbc.inner.GaussBlobImpl;
import com.huawei.gauss.jdbc.inner.GaussClobImpl;
import com.huawei.gauss.jdbc.inner.GaussConnectionHelper;
import com.huawei.gauss.jdbc.inner.GaussDatabaseMetaDataImpl;
import com.huawei.gauss.jdbc.inner.GaussDriver;
import com.huawei.gauss.jdbc.inner.GaussInfoImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import com.huawei.gauss.util.UUIDUtil;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.io.InputStream;
import java.io.Reader;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executor;

public class GaussConnectionImpl
extends ChannelExecutor
implements GaussConnection {
    private static final UUIDUtil CONN_UUID = new UUIDUtil();
    private static final int INITIAL_MAP_SIZE = 16;
    private static final String QUERY_DB_TIME_ZONE_SQL = "SELECT DBTIMEZONE";
    private static final String ALTER_SESSION_TIME_ZONE_SQL = "ALTER SESSION SET TIME_ZONE =";
    protected final GaussDriver zenithDriver;
    protected IOClient ioClient;
    protected boolean autoCommit = true;
    protected String catalog;
    protected String schema;
    protected ThreadLocal<Properties> stmtProperties = new ThreadLocal();
    protected Properties clientProperties;
    protected Properties lastProp = new Properties();
    protected Map<String, Class<?>> typeMap = Collections.emptyMap();
    protected boolean readyOnly = false;
    protected int holdability = 2;
    protected int transactionIsolationLevel = 2;
    protected String orgUrl;
    protected GaussInfo zenithInfo = new GaussInfoImpl();
    final Set<GaussStatement> gaussStatements = Collections.synchronizedSet(new HashSet());
    private final UUIDUtil stmtUUIDUtil = new UUIDUtil();
    private SQLWarning sqlWarning;
    private GmdbMessageProcessHelper gmdbMessageProcessHelper;
    private Long connUUID;
    private boolean cnDirectRoute = false;

    public GaussConnectionImpl(GaussDriver gaussDriver, Properties connectionProperties) throws SQLException {
        this.zenithDriver = gaussDriver;
        this.checkProperties(connectionProperties);
        this.clientProperties = connectionProperties;
        String value = this.clientProperties.getProperty("useRoute");
        if (value != null) {
            this.cnDirectRoute = Boolean.parseBoolean(value);
        }
    }

    public String getOrgUrl() {
        return this.orgUrl;
    }

    public void setOrgUrl(String orgUrl) {
        this.orgUrl = orgUrl;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void close() throws SQLException {
        if (this.isClosed()) {
            if (this.ioClient != null) {
                this.ioClient = null;
                this.decreaseClusterCount();
            }
            return;
        }
        try {
            GaussConnectionHelper.close(this);
        }
        finally {
            this.decreaseClusterCount();
            this.zenithDriver.ioClientFactory.releaseIOClient(this.ioClient);
            this.ioClient = null;
        }
    }

    private void decreaseClusterCount() {
        if (this.zenithInfo.isCluster()) {
            GaussClusterNode node = null;
            try {
                node = GaussClusterManager.getInstance().getClusterInfo(this.zenithInfo.getOriginalUrl()).getNode(this.zenithInfo.getIpAndPort());
            }
            catch (SQLException e) {
                ExceptionUtil.handleUnThrowException("Exception occur when decreaseClusterCount", e);
            }
            if (node != null) {
                node.decreaseConnCount();
            }
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void commit() throws SQLException {
        this.validateOpened();
        GaussConnectionHelper.commit(this);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Blob createBlob() throws SQLException {
        this.validateOpened();
        return new GaussBlobImpl();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Clob createClob() throws SQLException {
        this.validateOpened();
        return new GaussClobImpl();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Statement createStatement() throws SQLException {
        this.validateOpened();
        return GaussConnectionHelper.createStatement(this);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateOpened();
        return GaussConnectionHelper.createStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateOpened();
        return GaussConnectionHelper.createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public void doConnect(SocketAddress gaussAddress, Properties props) throws SQLException {
        try {
            this.ioClient = this.zenithDriver.ioClientFactory.getIOClient(gaussAddress);
            this.ioClient.connect(props);
        }
        catch (SocketTimeoutException e) {
            JDBCException exception = new JDBCException("Socket connect timeout. ioClient:@" + Integer.toHexString(this.hashCode()), "08006", 305, e);
            exception.setZenithServerIp(gaussAddress.toString().substring(1));
            throw exception;
        }
        catch (Exception e) {
            JDBCException exception = ExceptionUtil.processJDBCException("Open socket failed.", "08006", 303, e);
            String ip = gaussAddress.toString();
            if (ip.startsWith("/")) {
                exception.setZenithServerIp(ip.substring(1));
            } else {
                exception.setZenithServerIp(ip);
            }
            throw exception;
        }
        GaussConnectionHelper.connect(this);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getCatalog() throws SQLException {
        if (null == this.catalog) {
            return this.schema;
        }
        return this.catalog;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Properties getClientInfo() throws SQLException {
        return this.clientProperties;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getClientInfo(String name) throws SQLException {
        return this.clientProperties.getProperty(name);
    }

    @Override
    public GaussDriver getZenithDriver() {
        return this.zenithDriver;
    }

    @Override
    public GaussInfo getZenithInfo() {
        return this.zenithInfo;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    @Override
    public IOClient getIOClient() {
        return this.ioClient;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public DatabaseMetaData getMetaData() throws SQLException {
        this.validateOpened();
        return new GaussDatabaseMetaDataImpl(this);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.schema;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolationLevel;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typeMap;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public void setSqlWarning(SQLWarning sqlWarning) {
        this.sqlWarning = sqlWarning;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isClosed() throws SQLException {
        return null == this.ioClient || !this.ioClient.isConnected();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isReadOnly() throws SQLException {
        return this.readyOnly;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.validateOpened();
        return GaussConnectionHelper.prepareCall(this, sql);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateOpened();
        return GaussConnectionHelper.prepareCall(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateOpened();
        return GaussConnectionHelper.prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateOpened();
        this.isValidSql(sql);
        return GaussConnectionHelper.prepareStatement(this, sql);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.validateOpened();
        this.isValidSql(sql);
        return GaussConnectionHelper.prepareStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateOpened();
        this.isValidSql(sql);
        return GaussConnectionHelper.prepareStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateOpened();
        this.isValidSql(sql);
        return GaussConnectionHelper.prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.validateOpened();
        this.isValidSql(sql);
        return GaussConnectionHelper.prepareStatement(this, sql, columnIndexes);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.validateOpened();
        this.isValidSql(sql);
        return GaussConnectionHelper.prepareStatement(this, sql, columnNames);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to savepoint");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void rollback() throws SQLException {
        this.validateOpened();
        GaussConnectionHelper.rollback(this);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public void rollback(Savepoint savepoint) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to savepoint");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateOpened();
        GaussConnectionHelper.setAutoCommit(this, autoCommit);
        this.autoCommit = autoCommit;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setCatalog(String catalog) throws SQLException {
        this.validateOpened();
        GaussConnectionHelper.setCatalog(this, catalog);
        this.catalog = catalog;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkProperties(properties);
            GaussConnectionHelper.setClientInfo(this, properties, null, null);
            Properties dynamicProps = new Properties();
            dynamicProps.putAll((Map<?, ?>)properties);
            this.stmtProperties.set(dynamicProps);
            this.clientProperties = properties;
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), null);
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (name == null || name.equals("rule_name") || name.equals("rule_args")) {
            throw new SQLClientInfoException("rule_name/rule_args can't be setted by this interface.", null);
        }
        GaussConnectionHelper.setClientInfo(this, null, name, value);
        Properties properties = this.stmtProperties.get();
        if (null == properties) {
            properties = new Properties();
            this.stmtProperties.set(properties);
        }
        properties.setProperty(name, value);
        this.clientProperties.setProperty(name, value);
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public void setHoldability(int holdability) throws SQLException {
        if (2 != holdability) {
            throw new SQLFeatureNotSupportedException("Not support to set holdability as" + holdability, "0A000", 513);
        }
        this.holdability = holdability;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public void setReadOnly(boolean readOnly) throws SQLException {
        GaussConnectionHelper.setReadOnly(this, readOnly);
        this.readyOnly = readOnly;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public Savepoint setSavepoint() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to savepoint");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public Savepoint setSavepoint(String name) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to savepoint");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public void setSchema(String schema) throws SQLException {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public void setTransactionIsolation(int level) throws SQLException {
        String cmd = null;
        if (2 == level) {
            cmd = "set transaction isolation level read committed";
        } else if (8 == level) {
            cmd = "set transaction isolation level serializable";
        } else {
            throw new SQLFeatureNotSupportedException("Not support to set transactionIsolation as " + level, "0A000", 513);
        }
        this.transactionIsolationLevel = level;
        try (Statement stmt = this.createStatement();){
            stmt.execute(cmd);
        }
    }

    public void closeStatement(GaussStatementImpl statement) throws SQLException {
        this.gaussStatements.remove(statement);
    }

    @Override
    public GmdbMessageProcessHelper getGmdbMessageProcessHelper() {
        return this.gmdbMessageProcessHelper;
    }

    @Override
    public void setGmdbMessageProcessHelper(GmdbMessageProcessHelper gmdbMessageProcessHelper) {
        this.gmdbMessageProcessHelper = gmdbMessageProcessHelper;
    }

    public int getSessionId() {
        return this.ioClient.getSessionId();
    }

    @Override
    public boolean isBigEndianess() {
        return this.ioClient.isBigEndian();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to Array parameter");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support feature createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to XML parameter");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to Struct parameter");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to isWrapperFor(Class<?>)");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to convert SQL");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to set TypeMap");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to unwrap class");
    }

    private void isValidSql(String sql) throws SQLException {
        if (sql == null || sql.trim().equals("")) {
            throw ExceptionUtil.illegalJDBCArgumentException("sql cannot be null or empty!");
        }
    }

    private void validateOpened() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionUtil.connectionClosedException("Connection has been closed.");
        }
    }

    @Override
    public String getConnUUID() {
        if (null == this.connUUID) {
            this.connUUID = CONN_UUID.getUUID();
        }
        return this.connUUID.toString();
    }

    @Override
    public void setSessionTZ(String tzStr) throws SQLException {
        this.validateOpened();
        if (!tzStr.matches("[+|-]+\\d+:\\d{2}")) {
            throw ExceptionUtil.illegalJDBCArgumentException("time zone format is illegal");
        }
        try (Statement st = this.createStatement();){
            st.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + tzStr + "'");
            ResultSet rs = st.executeQuery(QUERY_DB_TIME_ZONE_SQL);
            rs.next();
            this.ioClient.setServerDBTimezone(TimeZone.getTimeZone("GMT" + rs.getString(1)).getRawOffset());
        }
        this.getIOClient().setClientSessionTZ(TimeZone.getTimeZone("GMT" + tzStr).getRawOffset());
    }

    protected UUIDUtil getStmtUUIDUtil() {
        return this.stmtUUIDUtil;
    }

    protected Properties getStmtProperties() {
        Properties properties = this.stmtProperties.get();
        if (null == properties) {
            properties = new Properties();
        } else {
            this.stmtProperties.remove();
        }
        return properties;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to abort");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to setNetworkTimeout");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Not support to getNetworkTimeout");
    }

    public void saveLastRouteArgs(Properties prop) {
        Object objValue;
        this.lastProp.clear();
        Object objName = prop.get("rule_name");
        if (objName != null) {
            this.lastProp.put("rule_name", objName);
        }
        if ((objValue = prop.get("rule_args")) != null) {
            Map objMap = (Map)objValue;
            HashMap newArgs = new HashMap(16);
            for (Map.Entry entry : objMap.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                newArgs.put(key.toString(), value);
            }
            this.lastProp.put("rule_args", newArgs);
        }
    }

    public final void checkProperties(Properties prop) throws SQLException {
        Object objName = prop.get("rule_name");
        if (objName != null && !(objName instanceof String)) {
            throw new SQLException("rule_name should be String");
        }
        Object objArgs = prop.get("rule_args");
        if (objArgs != null) {
            Map.Entry entry;
            Object key;
            if (!(objArgs instanceof Map)) {
                throw new SQLException("rule_args should be Map<String, Object>");
            }
            Map mapArgs = (Map)objArgs;
            Iterator iterator = mapArgs.entrySet().iterator();
            if (iterator.hasNext() && !((key = (entry = iterator.next()).getKey()) instanceof String)) {
                throw new SQLException("rule_args key should be String");
            }
        }
    }

    private boolean isObjChanged(Object lastObj, Object nowObj) {
        if (lastObj == null && nowObj == null) {
            return false;
        }
        if (lastObj != null && nowObj != null) {
            return !lastObj.equals(nowObj);
        }
        return true;
    }

    public boolean isRouteChanged() {
        Object lastRuleName = this.lastProp.get("rule_name");
        Object nowRuleName = this.clientProperties.get("rule_name");
        if (lastRuleName != null && nowRuleName != null) {
            if (!lastRuleName.equals(nowRuleName)) {
                return true;
            }
        } else {
            return lastRuleName != null || nowRuleName != null;
        }
        Object lastObjArg = this.lastProp.get("rule_args");
        Object nowObjArg = this.clientProperties.get("rule_args");
        if (lastObjArg != null && nowObjArg != null) {
            Map lastMapArg = (Map)lastObjArg;
            Map nowMapArg = (Map)nowObjArg;
            if (lastMapArg.size() != nowMapArg.size()) {
                return true;
            }
            for (Map.Entry entry : nowMapArg.entrySet()) {
                Object nowKey = entry.getKey();
                Object nowValue = entry.getValue();
                if (!lastMapArg.containsKey(nowKey)) {
                    return true;
                }
                Object lastValue = lastMapArg.get(nowKey);
                if (!this.isObjChanged(lastValue, nowValue)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean useRoute() throws SQLException {
        return this.cnDirectRoute;
    }

    public String getRouteSQL() throws SQLException {
        this.checkProperties(this.clientProperties);
        Object objName = this.clientProperties.get("rule_name");
        if (objName == null) {
            return "ROUTE BY RULE null";
        }
        String ruleName = (String)objName;
        Map ruleMap = (Map)this.clientProperties.get("rule_args");
        StringBuilder valueStr = new StringBuilder();
        StringBuilder keyStr = new StringBuilder();
        for (Map.Entry entry : ruleMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) {
                throw new SQLException("route argument name key should be String");
            }
            keyStr.append(key);
            keyStr.append(", ");
            String tempValue = this.getRouteArgStr(value);
            this.checkInputForSecurity(tempValue);
            valueStr.append("'").append(tempValue).append("'");
            valueStr.append(", ");
        }
        if (keyStr.length() == 0) {
            throw new SQLException("no route argument found");
        }
        keyStr.delete(keyStr.length() - 2, keyStr.length());
        valueStr.delete(valueStr.length() - 2, valueStr.length());
        StringBuilder sb = new StringBuilder();
        sb.append("ROUTE BY RULE ");
        sb.append(ruleName).append(" ");
        sb.append("(").append((CharSequence)keyStr).append(")");
        sb.append(" VALUES ");
        sb.append("(").append((CharSequence)valueStr).append(")");
        return sb.toString();
    }

    private String getRouteArgStr(Object obj) throws SQLException {
        if (obj != null && (obj instanceof InputStream || obj instanceof Reader || obj instanceof Blob || obj instanceof Clob || obj instanceof byte[])) {
            throw new SQLException("route argument don't support this data type: " + obj.getClass().getName());
        }
        String str = "";
        if (obj == null) {
            str = "null";
        } else if (obj instanceof Time) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
            str = f.format((Time)obj);
        } else if (obj instanceof Date) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            str = f.format((Date)obj);
        } else {
            str = obj.toString();
        }
        return str;
    }

    private void checkInputForSecurity(String input) throws SQLException {
        char[] dangerToken;
        boolean result = true;
        for (char c : dangerToken = new char[]{'\'', ';', '(', ')'}) {
            if (input.indexOf(c) == -1) continue;
            result = false;
            break;
        }
        if (!result) {
            throw new SQLException("route argument is invalid");
        }
    }
}

