/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussDatabaseMetaData;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussOfflineResultSet;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.util.ZenithJDBCInterface;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class GaussDatabaseMetaDataImpl
implements GaussDatabaseMetaData {
    public static final int JDBC_API_MAJOR_VERSION = 4;
    public static final int JDBC_API_MINOR_VERSION = 0;
    public static final int MAX_COLUMN_NAME_LENTH = 30;
    public static final int MAX_COLUMN_INDEX = 32;
    public static final int MAX_COLUMNS_INSELECT = 1024;
    public static final int MAX_COLUMNS_INTABLE = 1024;
    public static final int MAX_SCHEMA_NAME_LENTH = 30;
    public static final int MAX_PROCEDURE_NAME_LENTH = 30;
    public static final int MAX_CATALOG_NAME_LENTH = 30;
    public static final int MAX_STATEMENT_LENTH = 65535;
    public static final int MAX_STATEMENTS = 65535;
    public static final int MAX_TABLE_NAME_LENGTH = 30;
    public static final int MAX_TABLES_INSELECT = 32;
    public static final int MAX_USER_NAME_LENGTH = 30;
    public static final int BAND_INDEX_TWO = 2;
    public static final int BAND_INDEX_THREE = 3;
    public static final int BAND_INDEX_FOUR = 4;
    public static final int GMDB_PROTOCOL_VERSION = 8;
    public static final int DRIVER_MAJOR_VERSION = 3;
    public static final int DRIVER_MINOR_VERSION = 1;
    private static final String[][] SQL_KEYWORDS_DEFINE = new String[][]{{"ADD", "ALL", "ALTER", "AND", "AS", "ASC"}, {"BETWEEN", "BIGINT", "BINARY", "BLOB", "BY"}, {"CHAR", "CHECK", "CHECKPOINT", "CLOB", "COLUMN", "COMMIT", "CREATE", "CURDATE", "CURRENT_DATE", "CURRENT_TIMESTAMP"}, {"DATABASE", "DATE", "DATETIME", "DAY", "DDS_DATASOURCE", "DECIMAL", "DELETE", "DESC", "DISTINCT", "DOUBLE", "DROP", "DUPLICATE"}, {"ELSE", "END", "EXECUTE", "EXISTS", "EXPLAIN"}, {"FETCH", "FALSE", "FLOAT", "FOR", "FROM"}, {"GROUP"}, {"HAVING"}, {"IN", "INDEX", "INSERT", "INT", "INTEGER", "INTO", "IS"}, {"LAST_INSERT_ID", "LEFT", "LIKE", "LIMIT"}, {"MONTH"}, {"NOT", "NOW", "NULL", "NULL", "NUMERIC"}, {"ON", "OR", "ORDER"}, {"PARTITION"}, {"REAL", "RIGHT", "ROLLBACK", "ROWNUM"}, {"SELECT", "SET", "SHUTDOWN", "SYSDATE", "SYSTIMESTAMP", "SYSUTC"}, {"TABLE", "TABLESPACE", "THEN", "TIMESTAMP", "TRUE", "TRUNCATE"}, {"UNION", "UPDATE", "UTC"}, {"VALUES", "VARBINARY", "VARCHAR", "VARCHAR2"}, {"WHEN", "WHERE"}, {"YEAR"}};
    private static final String SQL_KEYWORDS;
    private static final String SQL_ALL_PATTERN = "%";
    private final GaussConnectionImpl dbConnection;

    public GaussDatabaseMetaDataImpl(GaussConnectionImpl connection) {
        this.dbConnection = connection;
    }

    public static String getVersionString() {
        return "" + 'V' + 3 + 'R' + 1;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getURL() throws SQLException {
        return this.dbConnection.getOrgUrl();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getUserName() throws SQLException {
        String usrName = this.dbConnection.getClientInfo("user");
        if (usrName != null) {
            usrName = usrName.toUpperCase(Locale.ENGLISH);
        }
        return usrName;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getDatabaseProductName() throws SQLException {
        return "Zenith";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getDatabaseProductVersion() throws SQLException {
        return GaussDatabaseMetaDataImpl.getVersionString();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getDriverName() throws SQLException {
        return "Zenith JDBC Driver";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getDriverVersion() throws SQLException {
        return GaussDatabaseMetaDataImpl.getVersionString();
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getDriverMajorVersion() {
        return 3;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getDriverMinorVersion() {
        return 1;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getSQLKeywords() throws SQLException {
        return SQL_KEYWORDS;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,LCASE,LENGTH,LTRIM,REPLACE,RTRIM,SOUNDEX,SUBSTRING,UCASE";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public String getSystemFunctions() throws SQLException {
        return "USER";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getExtraNameCharacters() throws SQLException {
        return "$#";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getSchemaTerm() throws SQLException {
        return "user";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxColumnNameLength() throws SQLException {
        return 30;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxColumnsInIndex() throws SQLException {
        return 32;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxColumnsInSelect() throws SQLException {
        return 1024;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxColumnsInTable() throws SQLException {
        return 1024;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxSchemaNameLength() throws SQLException {
        return 30;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxProcedureNameLength() throws SQLException {
        return 30;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxCatalogNameLength() throws SQLException {
        return 30;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxStatementLength() throws SQLException {
        return 65535;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxStatements() throws SQLException {
        return 65535;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxTableNameLength() throws SQLException {
        return 30;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxTablesInSelect() throws SQLException {
        return 32;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getMaxUserNameLength() throws SQLException {
        return 30;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 2 || level == 8;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String[] innerTypes = types;
        if (types == null || types.length == 0) {
            innerTypes = new String[]{"TABLE", "VIEW", "DYNAMIC VIEW", "RECYCLED TABLE", "RECYCLED INDEX"};
        }
        String userName = schemaPattern == null ? SQL_ALL_PATTERN : schemaPattern;
        String tableName = tableNamePattern == null ? SQL_ALL_PATTERN : tableNamePattern;
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT NULL AS TABLE_CAT , \n k.OWNER AS TABLE_SCHEM , \n k.OBJECT_NAME AS TABLE_NAME , \n k.OBJECT_TYPE AS TABLE_TYPE , \n '' AS REMARKS , \n NULL AS TYPE_CAT , \n NULL AS TYPE_SCHEM , \n NULL AS TYPE_NAME , \n NULL AS SELF_REFERENCING_COL_NAME , \n NULL AS REF_GENERATION \n FROM ");
        if (this.dbConnection.ioClient.getCallVersion() >= 8) {
            sb.append("DB_OBJECTS  k WHERE k.OWNER LIKE ? AND k.OBJECT_NAME LIKE ? AND k.OBJECT_TYPE IN ( ");
        } else {
            sb.append("ALL_OBJECTS k WHERE k.OWNER LIKE ? AND k.OBJECT_NAME LIKE ? AND k.OBJECT_TYPE IN ( ");
        }
        for (int i = 0; i < innerTypes.length; ++i) {
            sb.append("?");
            if (i >= innerTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" )");
        String sql = sb.toString();
        PreparedStatement preparedStatement = null;
        GaussResultSetImpl result = null;
        try {
            preparedStatement = this.dbConnection.prepareStatement(sql);
            preparedStatement.setString(1, userName);
            preparedStatement.setString(2, tableName);
            for (int i = 0; i < innerTypes.length; ++i) {
                preparedStatement.setString(2 + i + 1, innerTypes[i]);
            }
            result = (GaussResultSetImpl)preparedStatement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = result.offlineResultSet();
            this.closeQuietly(result);
            this.closeQuietly(preparedStatement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(result);
            this.closeQuietly(preparedStatement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getSchemas() throws SQLException {
        GaussResultSetImpl resultSet = null;
        PreparedStatement statement = null;
        try {
            String sql = null;
            sql = this.dbConnection.ioClient.getCallVersion() >= 8 ? "SELECT USERNAME AS TABLE_SCHEM FROM DB_USERS ORDER BY TABLE_SCHEM" : "SELECT USERNAME AS TABLE_SCHEM FROM ALL_USERS ORDER BY TABLE_SCHEM";
            statement = this.dbConnection.prepareStatement(sql);
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSet();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getCatalogs() throws SQLException {
        GaussResultSetImpl resultSet = null;
        PreparedStatement statement = null;
        try {
            String sql = null;
            sql = this.dbConnection.ioClient.getCallVersion() >= 8 ? "SELECT NULL AS TABLE_CAT FROM SYS_DUMMY WHERE 1=2" : "SELECT NULL AS TABLE_CAT FROM DUAL WHERE 1=2";
            statement = this.dbConnection.prepareStatement(sql);
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSet();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getTableTypes() throws SQLException {
        GaussResultSetImpl resultSet = null;
        PreparedStatement statement = null;
        StringBuilder sql = new StringBuilder();
        if (this.dbConnection.ioClient.getCallVersion() >= 8) {
            sql.append("SELECT 'TABLE' AS TABLE_TYPE FROM SYS_DUMMY\n UNION SELECT 'VIEW' AS TABLE_TYPE FROM SYS_DUMMY \n UNION SELECT 'DYNAMIC VIEW' AS TABLE_TYPE from SYS_DUMMY \n UNION SELECT 'RECYCLED TABLE' AS TABLE_TYPE from SYS_DUMMY \n UNION SELECT 'RECYCLED INDEX' AS TABLE_TYPE from SYS_DUMMY ");
        } else {
            sql.append("SELECT 'TABLE' AS TABLE_TYPE FROM DUAL\n UNION SELECT 'VIEW' AS TABLE_TYPE FROM DUAL \n UNION SELECT 'DYNAMIC VIEW' AS TABLE_TYPE from DUAL \n UNION SELECT 'RECYCLED TABLE' AS TABLE_TYPE from DUAL \n UNION SELECT 'RECYCLED INDEX' AS TABLE_TYPE from DUAL ");
        }
        try {
            statement = this.dbConnection.prepareStatement(sql.toString());
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSet();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String userName = schemaPattern == null ? SQL_ALL_PATTERN : schemaPattern;
        String tableName = tableNamePattern == null ? SQL_ALL_PATTERN : tableNamePattern;
        String columnName = columnNamePattern == null ? SQL_ALL_PATTERN : columnNamePattern;
        PreparedStatement statement = null;
        GaussResultSetImpl resultSet = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT NULL AS TABLE_CAT, \n k.OWNER AS TABLE_SCHEM, \n k.TABLE_NAME AS TABLE_NAME, \n k.COLUMN_NAME AS COLUMN_NAME, \nDATA_TYPE, \n k.DATA_TYPE AS TYPE_NAME, \n k.DATA_LENGTH AS COLUMN_SIZE, \n 0 AS BUFFER_LENGTH, \n k.DATA_PRECISION  AS DECIMAL_DIGITS, \n k.DATA_SCALE AS NUM_PREC_RADIX , \n CASE k.NULLABLE WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE , \n '' AS REMARKS , \n '' AS COLUMN_DEF , \n 0 AS SQL_DATA_TYPE , \n 0 AS SQL_DATETIME_SUB, \n 0 AS CHAR_OCTET_LENGTH , \n k.COLUMN_ID + 1 AS ORDINAL_POSITION , \n '' AS IS_NULLABLE , \n '' AS SCOPE_CATLOG , \n '' AS SCOPE_SCHEMA , \n '' AS SCOPE_TABLE , \n NULL AS SOURCE_DATA_TYPE , \n '' AS IS_AUTOINCREMENT \n FROM ");
        if (this.dbConnection.ioClient.getCallVersion() >= 8) {
            sql.append(" DB_TAB_COLS k WHERE k.OWNER LIKE ? AND k.TABLE_NAME LIKE ? AND k.COLUMN_NAME LIKE ? ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        } else {
            sql.append(" ALL_TAB_COLS k WHERE k.OWNER LIKE ? AND k.TABLE_NAME LIKE ? AND k.COLUMN_NAME LIKE ? ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        }
        try {
            statement = this.dbConnection.prepareStatement(sql.toString());
            statement.setString(1, userName);
            statement.setString(2, tableName);
            statement.setString(3, columnName);
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSetForGetColumns();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String userName = schema == null ? SQL_ALL_PATTERN : schema;
        PreparedStatement statement = null;
        GaussResultSetImpl resultSet = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT NULL AS TABLE_CAT, \n k.OWNER AS TABLE_SCHEM, \n c.TABLE_NAME, \n c.COLUMN_NAME COLUMN_NAME, \n 1 AS KEY_SEQ, \n k.INDEX_NAME AS PK_NAME \n FROM ");
        if (this.dbConnection.ioClient.getCallVersion() >= 8) {
            sql.append("(SELECT * FROM DB_TAB_COLS WHERE TABLE_NAME= ? AND OWNER LIKE ? ) c,");
            sql.append("(SELECT * FROM DB_INDEXES WHERE IS_PRIMARY = 'Y' AND TABLE_NAME= ? AND OWNER LIKE ?) k \n");
        } else {
            sql.append("(SELECT * FROM ALL_TAB_COLS WHERE TABLE_NAME= ? AND OWNER LIKE ? ) c,");
            sql.append("(SELECT * FROM ALL_INDEXES WHERE IS_PRIMARY = 'Y' AND TABLE_NAME= ? AND OWNER LIKE ?) k \n");
        }
        sql.append(" WHERE k.TABLE_NAME = c.TABLE_NAME  \n AND k.OWNER = c.OWNER AND LOCATE(CONCAT(c.COLUMN_NAME,','), CONCAT(k.COLUMNS,',')) > 0 ORDER BY c.COLUMN_NAME ");
        try {
            statement = this.dbConnection.prepareStatement(sql.toString());
            statement.setString(1, table);
            statement.setString(2, userName);
            statement.setString(3, table);
            statement.setString(4, userName);
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSet();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        PreparedStatement statement = null;
        GaussResultSetImpl resultSet = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT NULL AS TABLE_CAT, \n i.OWNER AS TABLE_SCHEM, \n i.TABLE_NAME, \n CASE i.IS_PRIMARY || i.IS_UNIQUE WHEN 'NN' THEN 0 ELSE 1 END AS NON_UNIQUE, \n NULL AS INDEX_QUALIFIER, \n i.INDEX_NAME AS INDEX_NAME, \n 1 AS TYPE, \n c.COLUMN_POSITION AS ORDINAL_POSITION, \n c.COLUMN_NAME, \n NULL AS ASC_OR_DESC, \n         0 AS CARDINALITY, \n i.PAGES AS PAGES, \n NULL AS FILTER_CONDITION \n    FROM ");
        if (this.dbConnection.ioClient.getCallVersion() >= 8) {
            sql.append("DB_INDEXES i, DB_IND_COLUMNS c \n  WHERE i.TABLE_NAME = ?  \n");
        } else {
            sql.append("ALL_INDEXES i, ALL_IND_COLUMNS c \n  WHERE i.TABLE_NAME = ?  \n");
        }
        if (schema != null && schema.length() > 0) {
            sql.append("    AND i.OWNER = ? \n");
        }
        if (unique) {
            sql.append(" AND (i.IS_PRIMARY = 'Y' or i.IS_UNIQUE = 'Y')\n");
        }
        sql.append(" AND i.INDEX_NAME = c.INDEX_NAME \n AND i.OWNER = c.TABLE_OWNER \n     AND i.TABLE_NAME = c.TABLE_NAME \n     AND i.OWNER = c.INDEX_OWNER ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ");
        try {
            statement = this.dbConnection.prepareStatement(sql.toString());
            statement.setString(1, table);
            if (schema != null && schema.length() > 0) {
                statement.setString(2, schema);
            }
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSet();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public boolean supportsResultSetType(int type) throws SQLException {
        return 1003 == type;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Connection getConnection() throws SQLException {
        return this.dbConnection;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return 2 == holdability;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getDatabaseMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getDatabaseMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement statement = null;
        GaussResultSetImpl resultSet = null;
        int i = 1;
        int k = table != null ? i++ : 0;
        int n = schema != null && schema.length() > 0 ? i++ : 0;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT NULL AS PKTABLE_CAT, P.OWNER AS PKTABLE_SCHEM, P.TABLE_NAME AS PKTABLE_NAME,PC.COLUMN_NAME AS PKCOLUMN_NAME,  NULL AS FKTABLE_CAT, F.OWNER AS FKTABLE_SCHEM,F.TABLE_NAME AS FKTABLE_NAME,FC.COLUMN_NAME AS FKCOLUMN_NAME,FC.POSITION AS KEY_SEQ,  NULL AS UPDATE_RULE,DECODE(F.DELETE_RULE, 'DELETE CASCADE', 0, 'SET NULL', 2, 1) AS DELETE_RULE,F.CONSTRAINT_NAME AS FK_NAME,  P.CONSTRAINT_NAME AS PK_NAME,DECODE(F.DEFERRABLE,'DEFERRABLE',5,'NOT DEFERRABLE',7, 'DEFERRED', 6 ) DEFERRABILITY   FROM DB_CONS_COLUMNS PC, ALL_CONSTRAINTS P,DB_CONS_COLUMNS FC, ALL_CONSTRAINTS F WHERE 1=1 ");
        if (k != 0) {
            sql.append(" AND F.TABLE_NAME = ?");
        }
        if (n != 0) {
            sql.append(" AND F.OWNER=?");
        }
        sql.append(" AND F.CONSTRAINT_TYPE = 'R' AND P.OWNER = F.R_OWNER  AND P.CONSTRAINT_NAME = F.R_CONSTRAINT_NAME AND P.CONSTRAINT_TYPE = 'P' AND PC.OWNER = P.OWNER  AND PC.CONSTRAINT_NAME = P.CONSTRAINT_NAME AND PC.TABLE_NAME = P.TABLE_NAME AND FC.OWNER = F.OWNER  AND FC.CONSTRAINT_NAME = F.CONSTRAINT_NAME AND FC.TABLE_NAME = F.TABLE_NAME AND FC.POSITION = PC.POSITION ORDER BY PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        try {
            statement = this.dbConnection.prepareStatement(sql.toString());
            if (k != 0) {
                statement.setString(k, table);
            }
            if (n != 0) {
                statement.setString(n, schema);
            }
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSet();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public ResultSet getTypeInfo() throws SQLException {
        String dualTable = null;
        dualTable = this.dbConnection.ioClient.getCallVersion() >= 8 ? "SYS_DUMMY" : "DUAL";
        String sqlIntege = "select 'INTEGER' as TYPE_NAME, 4 as DATA_TYPE, 10 as PRECISION, '' as LITERAL_PREFIX, '' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\nfalse as CASE_SENSITIVE, 3 as SEARCHABLE, true UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, true as AUTO_INCREMENT, 'INTEGER' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlIntege = sqlIntege + dualTable;
        String sqlBigint = "select 'BIGINT' as TYPE_NAME, -5 as DATA_TYPE, 19 as PRECISION, '' as LITERAL_PREFIX, '' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\nfalse as CASE_SENSITIVE, 3 as SEARCHABLE, true UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, true as AUTO_INCREMENT, 'BIGINT' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlBigint = sqlBigint + dualTable;
        String sqlReal = "select 'REAL' as TYPE_NAME, 8 as DATA_TYPE, 17 as PRECISION, '' as LITERAL_PREFIX, '' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\nfalse as CASE_SENSITIVE, 3 as SEARCHABLE, true UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'REAL' as LOCAL_TYPE_NAME,\n-308 as MINIMUM_SCALE, 308 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlReal = sqlReal + dualTable;
        String sqlNumeric = "select 'NUMERIC' as TYPE_NAME, 2 as DATA_TYPE, 65 as PRECISION, '' as LITERAL_PREFIX, '' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\nfalse as CASE_SENSITIVE, 3 as SEARCHABLE, true UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'NUMERIC' as LOCAL_TYPE_NAME,\n-308 as MINIMUM_SCALE, 308 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlNumeric = sqlNumeric + dualTable;
        String sqlDate = "select 'DATE' as TYPE_NAME, 93 as DATA_TYPE, 0 as PRECISION, '''' as LITERAL_PREFIX, '''' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\nfalse as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'DATE' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlDate = sqlDate + dualTable;
        String sqlTimestamp = "select 'TIMESTAMP' as TYPE_NAME, 93 as DATA_TYPE, 0 as PRECISION, '''' as LITERAL_PREFIX, '''' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\nfalse as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'TIMESTAMP' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlTimestamp = sqlTimestamp + dualTable;
        String sqlVarchar = "select 'VARCHAR' as TYPE_NAME, 12 as DATA_TYPE, 65535 as PRECISION, '''' as LITERAL_PREFIX, '''' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\nfalse as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'VARCHAR' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlVarchar = sqlVarchar + dualTable;
        String sqlBinary = "select 'BINARY' as TYPE_NAME, -2 as DATA_TYPE, 255 as PRECISION, '''' as LITERAL_PREFIX, '''' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\ntrue as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'BINARY' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlBinary = sqlBinary + dualTable;
        String sqlVarbinary = "select 'VARBINARY' as TYPE_NAME, -3 as DATA_TYPE, 65535 as PRECISION, '''' as LITERAL_PREFIX, '''' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\ntrue as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'VARBINARY' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlVarbinary = sqlVarbinary + dualTable;
        String sqlBlob = "select 'BLOB' as TYPE_NAME, 2004 as DATA_TYPE, 2147483647 as PRECISION, '''' as LITERAL_PREFIX, '''' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\ntrue as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'BLOB' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlBlob = sqlBlob + dualTable;
        String sqlClob = "select 'CLOB' as TYPE_NAME, 2005 as DATA_TYPE, 2147483647 as PRECISION, '''' as LITERAL_PREFIX, '''' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\ntrue as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'CLOB' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlClob = sqlClob + dualTable;
        String sqlBoolean = "select 'BOOL' as TYPE_NAME, 16 as DATA_TYPE, 4 as PRECISION, '' as LITERAL_PREFIX, '' as LITERAL_SUFFIX, null as CREATE_PARAMS, 1 as NULLABLE,\ntrue as CASE_SENSITIVE, 3 as SEARCHABLE, false UNSIGNED_ATTRIBUTE, false as FIXED_PREC_SCALE, false as AUTO_INCREMENT, 'BOOL' as LOCAL_TYPE_NAME,\n0 as MINIMUM_SCALE, 0 as MAXIMUM_SCALE, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 10 as NUM_PREC_RADIX from ";
        sqlBoolean = sqlBoolean + dualTable;
        StringBuilder sb = new StringBuilder();
        sb.append(sqlIntege).append(" union ").append(sqlBigint).append(" union ").append(sqlReal).append(" union ").append(sqlNumeric).append(" union ").append(sqlDate).append(" union ").append(sqlTimestamp).append(" union ").append(sqlVarchar).append(" union ").append(sqlBinary).append(" union ").append(sqlVarbinary).append(" union ").append(sqlBlob).append(" union ").append(sqlClob).append(" union ").append(sqlBoolean);
        String sql = sb.toString();
        PreparedStatement statement = null;
        GaussResultSetImpl resultSet = null;
        try {
            statement = this.dbConnection.prepareStatement(sql);
            resultSet = (GaussResultSetImpl)statement.executeQuery();
            GaussOfflineResultSet gaussOfflineResultSet = resultSet.offlineResultSet();
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            return gaussOfflineResultSet;
        }
        catch (Throwable throwable) {
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
            throw throwable;
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Do not support feature getProcedures(String,String,String).");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported, unimplement method or interface.");
    }

    private void closeQuietly(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException exception) {
            ExceptionUtil.handleUnThrowException("Exception occur when close statement", exception);
        }
    }

    private void closeQuietly(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException exception) {
            ExceptionUtil.handleUnThrowException("Exception occur when close result set", exception);
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Feature is not supported.");
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    static {
        StringBuilder strb = new StringBuilder();
        String[][] stringArray = SQL_KEYWORDS_DEFINE;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] keys;
            for (String key : keys = stringArray[i]) {
                strb.append(key).append(',');
            }
        }
        SQL_KEYWORDS = strb.substring(0, strb.length() - 1);
    }
}

