/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.cluster.check.CheckConnectionPool;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.handler.factory.ChannelHandlerFactory;
import com.huawei.gauss.handler.inner.IOClientFactory;
import com.huawei.gauss.jdbc.IGaussDriver;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussSubDriver4ClusterCN;
import com.huawei.gauss.jdbc.inner.GaussSubDriver4Direct;
import com.huawei.gauss.jdbc.inner.GaussSubDriverAbstract;
import com.huawei.gauss.jdbc.inner.UrlType;
import com.huawei.gauss.jdbc.inner.util.GaussDriverInitUtil;
import com.huawei.gauss.om.ConfigManager;
import com.huawei.gauss.om.OMConstants;
import com.huawei.gauss.util.ZenithJDBCInterface;
import com.huawei.gauss.util.lang.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class GaussDriver
implements IGaussDriver,
OMConstants {
    private static final Timer CANCEL_TIMER = new Timer("zenith.jdbc.cancelTimer", true);
    private static final int URL_ATTR_USER = 0;
    private static final int URL_ATTR_PASSWORD = 1;
    private static final int URL_ATTR_LOGIN_TIMEOUT = 2;
    private static final int URL_ATTR_SOCKET_TIMEOUT = 3;
    private static final int URL_ATTR_USE_SSL = 4;
    private static final int URL_ATTR_REQUIRE_SSL = 5;
    private static final int URL_ATTR_VERIFY_CERT = 6;
    private static final int URL_ATTR_USE_ROUTE = 7;
    private static final int URL_ATTRSSL_CIPHER = 8;
    private static final int URL_ATTR_REVOCATION_ENABLED = 9;
    private static final int URL_READ_WRITE_SEPARATION = 10;
    private static final Map<String, Integer> URL_ATTR_NAME = new HashMap<String, Integer>();
    ChannelHandlerFactory channelHandlerFactory;
    IOClientFactory ioClientFactory;
    private ConfigManager configManager = ConfigManager.getInstance();

    public GaussDriver() {
        this.channelHandlerFactory = GaussDriverInitUtil.getChannelHandlerFactories(this);
        this.ioClientFactory = GaussDriverInitUtil.getIOClientFactory(this);
    }

    public ChannelHandlerFactory getChannelHandlerFactory() {
        return this.channelHandlerFactory;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        UrlType pattern = this.checkUrl(url);
        return pattern != UrlType.EXCEPT;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.FULL_SUPPORT)
    public Connection connect(String url, Properties properties) throws SQLException {
        if (url == null || properties == null) {
            throw ExceptionUtil.processJDBCException("invalid argument ,connection url or property is null.", "S1009", 503);
        }
        UrlType urlType = this.checkUrl(url);
        if (urlType == UrlType.EXCEPT) {
            return null;
        }
        String filterUrl = this.parseUrl(url, properties);
        GaussSubDriverAbstract subDriver = urlType != UrlType.DIRECT ? new GaussSubDriver4ClusterCN(this, filterUrl, properties) : new GaussSubDriver4Direct(this, filterUrl, properties);
        GaussConnectionImpl gaussConnection = subDriver.getConnection(properties, urlType);
        gaussConnection.setOrgUrl(url);
        gaussConnection.zenithInfo.setOriginalUrl(filterUrl);
        gaussConnection.zenithInfo.setUser(properties.getProperty("user"));
        gaussConnection.setSchema(properties.getProperty("defaultSchema"));
        return gaussConnection;
    }

    String parseUrl(String url, Properties properties) throws SQLException {
        int index = url.lastIndexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1);
            if (StringUtils.isEmpty(paramString)) {
                throw new SQLException("url needs parameter string after '?'");
            }
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                String paramValuePair = queryParams.nextToken();
                int indexOfEquals = StringUtils.lastIndexOf(paramValuePair, "=");
                String key = null;
                String value = null;
                if (indexOfEquals != -1) {
                    key = paramValuePair.substring(0, indexOfEquals);
                    if (indexOfEquals + 1 < paramValuePair.length()) {
                        value = paramValuePair.substring(indexOfEquals + 1);
                    }
                }
                if (StringUtils.isEmpty(value) || StringUtils.isEmpty(key)) continue;
                try {
                    this.putAttribute(key, URLDecoder.decode(value, "UTF-8"), properties);
                }
                catch (UnsupportedEncodingException uee) {
                    this.putAttribute(key, value, properties);
                }
                catch (Exception e) {
                    throw new SQLException(e.toString());
                }
            }
        }
        String moveSchemaUrl = index == -1 ? url : url.substring(0, index);
        int atIndex = url.indexOf("@");
        return moveSchemaUrl.substring(atIndex + 1);
    }

    void putAttribute(String key, String value, Properties props) throws SQLException {
        if (!URL_ATTR_NAME.containsKey(key)) {
            throw new SQLException("invalid url parameter name: " + key + ", it's case sensitive");
        }
        int attrSerial = URL_ATTR_NAME.get(key);
        switch (attrSerial) {
            case 0: {
                props.setProperty("user", value);
                break;
            }
            case 1: {
                props.setProperty("password", value);
                break;
            }
            case 2: {
                Integer.parseInt(value);
                props.setProperty("loginTimeout", value);
                break;
            }
            case 3: {
                Integer.parseInt(value);
                props.setProperty("socketTimeout", value);
                break;
            }
            case 4: {
                Boolean.parseBoolean(value);
                props.setProperty("useSSL", value);
                break;
            }
            case 5: {
                Boolean.parseBoolean(value);
                props.setProperty("requireSSL", value);
                break;
            }
            case 6: {
                Boolean.parseBoolean(value);
                props.setProperty("verifyServerCertificate", value);
                break;
            }
            case 7: {
                Boolean.parseBoolean(value);
                props.setProperty("useRoute", value);
                break;
            }
            case 8: {
                props.setProperty("sslCipher", value);
                break;
            }
            case 9: {
                Boolean.parseBoolean(value);
                props.setProperty("isRevocationEnabled", value);
                break;
            }
            case 10: {
                Boolean.parseBoolean(value);
                props.setProperty("dnReadWriteSeparation", value);
                break;
            }
            default: {
                throw new SQLException("invalid url parameter name: " + key + ", it's case sensitive");
            }
        }
    }

    UrlType checkUrl(String url) {
        int idx;
        Matcher directMatcher;
        String rawUrl = url;
        int index = StringUtils.lastIndexOf(url, "?");
        if (index != -1) {
            rawUrl = url.substring(0, index);
        }
        if ((directMatcher = DIRECT_URL_PATTERN.matcher(rawUrl)).matches()) {
            return UrlType.DIRECT;
        }
        directMatcher = BALANECE_URL_PATTERN.matcher(rawUrl);
        if (directMatcher.matches()) {
            return UrlType.BALANCE;
        }
        directMatcher = ETCD_URL_PATTERN.matcher(rawUrl);
        if (directMatcher.matches() && (idx = rawUrl.indexOf(47)) > 0) {
            return UrlType.ETCD;
        }
        directMatcher = READ_WRITE_SEPARATION_URL_PATTERN.matcher(rawUrl);
        if (directMatcher.matches()) {
            return UrlType.RWSEPARATION;
        }
        return UrlType.EXCEPT;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int getMajorVersion() {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.PART_SUPPORT)
    public int getMinorVersion() {
        return 0;
    }

    @Override
    @ZenithJDBCInterface(description=ZenithJDBCInterface.Description.NO_SUPPORT)
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public void cancel(String gaussNode, int cancelSessionId, int cancelSerialNumber, int cancelSeqNo, String localUsr) throws SQLException {
        CheckConnectionPool.cancel(gaussNode, cancelSessionId, cancelSerialNumber, cancelSeqNo, localUsr);
    }

    @Override
    public Timer getCancelTimer() {
        return CANCEL_TIMER;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("not support feature getParentLogger.");
    }

    static {
        try {
            DriverManager.registerDriver(new GaussDriver());
            URL_ATTR_NAME.put("loginTimeout", 2);
            URL_ATTR_NAME.put("socketTimeout", 3);
            URL_ATTR_NAME.put("user", 0);
            URL_ATTR_NAME.put("password", 1);
            URL_ATTR_NAME.put("useSSL", 4);
            URL_ATTR_NAME.put("requireSSL", 5);
            URL_ATTR_NAME.put("verifyServerCertificate", 6);
            URL_ATTR_NAME.put("useRoute", 7);
            URL_ATTR_NAME.put("sslCipher", 8);
            URL_ATTR_NAME.put("isRevocationEnabled", 9);
            URL_ATTR_NAME.put("useRW", 10);
        }
        catch (Exception e) {
            ExceptionUtil.handleUnThrowException("Exception occur when register Driver", e);
        }
    }
}

