/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussParameterMetaData;
import com.huawei.gauss.jdbc.inner.GaussPrepareStmtImpl;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import java.sql.SQLException;

public class GaussParameterMetaDataImpl
implements GaussParameterMetaData {
    private final GaussPrepareStmtImpl prePareStmt;
    GaussResultSetImpl metadata = null;

    public GaussParameterMetaDataImpl(GaussPrepareStmtImpl prePareStmt, GaussResultSetImpl metadata) {
        this.prePareStmt = prePareStmt;
        this.metadata = metadata;
    }

    public GaussPrepareStmtImpl getGaussPrepareStmtImpl() throws SQLException {
        return this.prePareStmt;
    }

    @Override
    public int getParameterCount() throws SQLException {
        if (this.prePareStmt != null && this.prePareStmt.getParamsData() != null) {
            return this.prePareStmt.getParamsData().getParamCount();
        }
        return 0;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkAvailable();
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkBounds(param);
        return false;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkBounds(param);
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkBounds(param);
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkBounds(param);
        return FieldType.VARCHAR.getJdbcType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkBounds(param);
        return FieldType.VARCHAR.getName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkBounds(param);
        return "java.lang.String";
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void checkAvailable() throws SQLException {
        if (this.metadata == null) {
            throw ExceptionUtil.processJDBCException("Feature is not supported, unimplement method or interface.", "S1C00", 513);
        }
    }

    private void checkBounds(int paramNumber) throws SQLException {
        if (paramNumber < 1) {
            throw ExceptionUtil.processJDBCException("INDEX OF PARAM OUT OF RANGE.", "S1009", 512);
        }
        if (paramNumber > this.getParameterCount()) {
            throw ExceptionUtil.processJDBCException("INDEX OF PARAM OUT OF RANGE.", "S1009", 512);
        }
    }
}

