/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.jdbc.inner;

import com.huawei.gauss.channel.context.statement.ParamsData;
import com.huawei.gauss.channel.context.statement.ParamsDataProcessor;
import com.huawei.gauss.channel.context.statement.prepare.PrepareStmtCloseContext;
import com.huawei.gauss.channel.context.statement.prepare.PrepareStmtExecuteBatchContext;
import com.huawei.gauss.channel.context.statement.prepare.PrepareStmtExecuteContext;
import com.huawei.gauss.channel.context.statement.prepare.PrepareStmtExecuteQueryContext;
import com.huawei.gauss.channel.context.statement.prepare.PrepareStmtExecuteUpdateContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussResultSet;
import com.huawei.gauss.jdbc.IGaussDriver;
import com.huawei.gauss.jdbc.inner.GaussPrepareStmtImpl;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementHelper;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class GaussPrepareStatementHelper {
    public static final int BATCH_MAX_ERROR_COUNT = 10;

    private GaussPrepareStatementHelper() {
    }

    static final boolean execute(GaussPrepareStmtImpl gaussPrepareStmt) throws SQLException {
        GaussPrepareStatementHelper.saveLobFirst(gaussPrepareStmt.paramsData);
        PrepareStmtExecuteContext context = new PrepareStmtExecuteContext((IGaussDriver)gaussPrepareStmt.gaussDriver, (GaussConnection)gaussPrepareStmt.gaussConnection, gaussPrepareStmt);
        context.setSql(gaussPrepareStmt.parsedSql.getToServerSql());
        context.setAutoGeneratedKeys(gaussPrepareStmt.getGeneratedKeyType());
        gaussPrepareStmt.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussPrepareStmt, context);
        boolean hasResult = (Boolean)context.getResult();
        if (hasResult) {
            GaussResultSetImpl resultSetImpl = new GaussResultSetImpl(gaussPrepareStmt, gaussPrepareStmt.parsedSql.getToServerSql());
            gaussPrepareStmt.gaussDriver.channelHandlerFactory.createResultSetCHandlers(resultSetImpl.channelHandlers, gaussPrepareStmt.gaussConnection);
            resultSetImpl.rowsData = context.getRowsData();
            gaussPrepareStmt.resultSet = resultSetImpl;
            gaussPrepareStmt.returnResults.add(resultSetImpl);
        }
        gaussPrepareStmt.fetchAllReturnResults();
        return gaussPrepareStmt.returnResults.size() > 0;
    }

    static final int executeUpdate(GaussPrepareStmtImpl gaussPrepareStmt) throws SQLException {
        GaussPrepareStatementHelper.saveLobFirst(gaussPrepareStmt.paramsData);
        PrepareStmtExecuteUpdateContext context = new PrepareStmtExecuteUpdateContext((IGaussDriver)gaussPrepareStmt.gaussDriver, (GaussConnection)gaussPrepareStmt.gaussConnection, gaussPrepareStmt);
        context.setSql(gaussPrepareStmt.parsedSql.getToServerSql());
        context.setAutoGeneratedKeys(gaussPrepareStmt.getGeneratedKeyType());
        gaussPrepareStmt.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussPrepareStmt, context);
        return (Integer)context.getResult();
    }

    static final GaussResultSet executeQuery(GaussPrepareStmtImpl gaussPrepareStmt) throws SQLException {
        GaussPrepareStatementHelper.saveLobFirst(gaussPrepareStmt.paramsData);
        GaussResultSetImpl resultSetImpl = new GaussResultSetImpl(gaussPrepareStmt, gaussPrepareStmt.parsedSql.getToServerSql());
        gaussPrepareStmt.gaussDriver.channelHandlerFactory.createResultSetCHandlers(resultSetImpl.channelHandlers, gaussPrepareStmt.gaussConnection);
        PrepareStmtExecuteQueryContext context = new PrepareStmtExecuteQueryContext((IGaussDriver)gaussPrepareStmt.gaussDriver, (GaussConnection)gaussPrepareStmt.gaussConnection, resultSetImpl);
        context.setSql(gaussPrepareStmt.parsedSql.getToServerSql());
        context.setAutoGeneratedKeys(gaussPrepareStmt.getGeneratedKeyType());
        gaussPrepareStmt.execute(context);
        GaussStatementHelper.getGeneratedKeyRows(gaussPrepareStmt, context);
        if (gaussPrepareStmt.getLangType() == 4) {
            gaussPrepareStmt.fetchAllReturnResults();
            if (gaussPrepareStmt.returnResults.size() == 0) {
                return resultSetImpl;
            }
            return (GaussResultSet)gaussPrepareStmt.returnResults.get(0);
        }
        gaussPrepareStmt.returnResults.add(resultSetImpl);
        return (GaussResultSet)context.getResult();
    }

    private static void setAutoCommitOn(Connection conn, boolean autoCommit) {
        try {
            conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when set autocommit", e);
        }
    }

    private static void commitIgnoreException(Connection conn) {
        try {
            conn.commit();
        }
        catch (SQLException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when commit", e);
        }
    }

    private static void rollbackIgnoreException(Connection conn) {
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            ExceptionUtil.handleUnThrowException("Exception occur when rollback", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] executeBatch(GaussPrepareStmtImpl gaussPrepareStmt) throws SQLException {
        boolean isAutoCommitOn;
        Connection conn;
        int totalUpdateCnt;
        int[] affectedRows;
        block18: {
            int batchCount = gaussPrepareStmt.paramsData.getParamsCache().size();
            affectedRows = new int[batchCount];
            for (int i = 0; i < batchCount; ++i) {
                affectedRows[i] = -2;
            }
            totalUpdateCnt = 0;
            conn = gaussPrepareStmt.getConnection();
            isAutoCommitOn = conn.getAutoCommit();
            if (isAutoCommitOn) {
                GaussPrepareStatementHelper.setAutoCommitOn(conn, false);
            }
            try {
                if (batchCount == 0) {
                    try {
                        affectedRows = new int[]{-2};
                        PrepareStmtExecuteBatchContext context = new PrepareStmtExecuteBatchContext((IGaussDriver)gaussPrepareStmt.gaussDriver, (GaussConnection)gaussPrepareStmt.gaussConnection, gaussPrepareStmt);
                        context.setSql(gaussPrepareStmt.parsedSql.getToServerSql());
                        context.setAutoGeneratedKeys(gaussPrepareStmt.getGeneratedKeyType());
                        gaussPrepareStmt.execute(context);
                        GaussStatementHelper.getGeneratedKeyRows(gaussPrepareStmt, context);
                        break block18;
                    }
                    catch (Exception e) {
                        if (isAutoCommitOn) {
                            GaussPrepareStatementHelper.rollbackIgnoreException(conn);
                        }
                        affectedRows[0] = -3;
                        if (e instanceof SQLException) {
                            throw new BatchUpdateException(e.getMessage(), ((SQLException)e).getSQLState(), ((SQLException)e).getErrorCode(), affectedRows);
                        }
                        throw new BatchUpdateException(e.getMessage(), affectedRows);
                    }
                }
                try {
                    gaussPrepareStmt.setGeneratedKeyRows(null);
                    GaussPrepareStatementHelper.saveLobFirst(gaussPrepareStmt.paramsData);
                    ParamsDataProcessor processor = gaussPrepareStmt.paramsData.getProcessor();
                    processor.reBindData();
                    while (!processor.isEnd() || processor.hasNextParam()) {
                        PrepareStmtExecuteBatchContext context = new PrepareStmtExecuteBatchContext((IGaussDriver)gaussPrepareStmt.gaussDriver, (GaussConnection)gaussPrepareStmt.gaussConnection, gaussPrepareStmt);
                        context.setSql(gaussPrepareStmt.parsedSql.getToServerSql());
                        context.setAutoGeneratedKeys(gaussPrepareStmt.getGeneratedKeyType());
                        gaussPrepareStmt.execute(context);
                        GaussStatementHelper.getGeneratedKeyRows(gaussPrepareStmt, context);
                        totalUpdateCnt += gaussPrepareStmt.updateCount;
                    }
                }
                catch (Exception e) {
                    if (isAutoCommitOn) {
                        GaussPrepareStatementHelper.rollbackIgnoreException(conn);
                    }
                    for (int i = 0; i < batchCount; ++i) {
                        affectedRows[i] = -3;
                    }
                    if (e instanceof SQLException) {
                        throw new BatchUpdateException(e.getMessage(), ((SQLException)e).getSQLState(), ((SQLException)e).getErrorCode(), affectedRows);
                    }
                    throw new BatchUpdateException(e.getMessage(), affectedRows);
                }
            }
            finally {
                if (isAutoCommitOn) {
                    GaussPrepareStatementHelper.setAutoCommitOn(conn, true);
                }
            }
        }
        if (isAutoCommitOn) {
            GaussPrepareStatementHelper.commitIgnoreException(conn);
        }
        gaussPrepareStmt.updateCount = totalUpdateCnt;
        return affectedRows;
    }

    static final void closePrepareStatement(GaussPrepareStmtImpl gaussPrepareStmt) throws SQLException {
        PrepareStmtCloseContext closePrepareStmtContext = new PrepareStmtCloseContext((IGaussDriver)gaussPrepareStmt.gaussDriver, (GaussConnection)gaussPrepareStmt.gaussConnection, gaussPrepareStmt);
        gaussPrepareStmt.execute(closePrepareStmtContext);
    }

    static final void saveLobFirst(ParamsData paramsData) throws SQLException {
        List<AbstractGaussLob> allLobs = paramsData.getProcessor().getAllLob();
        for (AbstractGaussLob lob : allLobs) {
            lob.flushAllDataToServer();
        }
    }

    static final void validateAddBatch(GaussPrepareStmtImpl gaussPrepareStmt) throws SQLException {
        ParamsData paramsData = gaussPrepareStmt.paramsData;
        if (paramsData.getParamCount() < 1) {
            throw ExceptionUtil.processJDBCException("There is no params to need bind, can not add batch.");
        }
    }
}

